//
// $Id$
//

#include "FrameworkHAL.h"
#include "BMPCodec.h"

//-----------------------------------------------------------------------------
// BMPCodec
//-----------------------------------------------------------------------------
BMPCodec::BMPCodec()
{
}

BMPCodec::~BMPCodec()
{
}

inline bool AdvanceDecode(BMPCodec::ImageDst &image, BMPCodec::Stream &stream,
				int &x, int &y, int biWidth, int biHeight, int bytesAlign)
{
	x++;
	if (x < biWidth) return false;
	x = 0;
	y++;
	if (y >= biHeight) return true;
	image.ScanLine();
	stream.Seek(stream.Tell() + bytesAlign);
	return false;
}

bool BMPCodec::Decode(ImageDst &image, const DecodeFlag &decodeFlag, Stream &stream)
{
	if (stream.Read(&_bfh, 14) < 14) return false;
	if (XUnpackUSHORT(_bfh.bfType) != 0x4d42) return false;
	if (stream.Read(&_bih, 40) < 40) return false;
	ULONG bfOffBits = XUnpackULONG(_bfh.bfOffBits);
	int biWidth = XUnpackLONG(_bih.biWidth);
	int biHeight = XUnpackLONG(_bih.biHeight);
	USHORT biBitCount = XUnpackUSHORT(_bih.biBitCount);
	int x = 0, y = 0;
	if (biBitCount == 1 || biBitCount == 4 || biBitCount == 8) {
		int cntPalette = 1 << biBitCount;
		ULONG bytesPalette = sizeof(Palette) * cntPalette;
		Palette *paletteTbl = reinterpret_cast<Palette *>(
				Allocater::GetInstance()->Alloc(bytesPalette));
		if (paletteTbl == NULL) return false;
		if (stream.Read(paletteTbl, bytesPalette) < bytesPalette) return false;
		if (bfOffBits != 0) stream.Seek(bfOffBits);
		image.BeginDecode(biWidth, biHeight);
		if (biBitCount == 1) {
			ULONG bytesPerLine = (biWidth + 7) / 8 * 8;
			ULONG bytesAlign = (bytesPerLine + 3) / 4 * 4 - bytesPerLine;
			UCHAR ch, data;
			int bitsRest = 0;
			for (;;) {
				if (bitsRest == 0) {
					if (stream.Read(&ch, 1) < 1) break;
					bitsRest = 8;
				}
				data = ch >> 7;
				ch <<= 1, bitsRest--;
				const Palette &palette = paletteTbl[data];
				image.PutAndScanPixelRGB(
							palette.elemR, palette.elemG, palette.elemB);
				if (::AdvanceDecode(image, stream, x, y,
										biWidth, biHeight, bytesAlign)) break;
			}
		} else if (biBitCount == 4) {
			ULONG bytesPerLine = (biWidth * 4 + 7) / 8 * 8;
			ULONG bytesAlign = (bytesPerLine + 3) / 4 * 4 - bytesPerLine;
			UCHAR ch, data;
			int bitsRest = 0;
			for (;;) {
				if (bitsRest == 0) {
					if (stream.Read(&ch, 1) < 1) break;
					bitsRest = 8;
				}
				data = ch >> 4;
				ch <<= 4, bitsRest -= 4;
				const Palette &palette = paletteTbl[data];
				image.PutAndScanPixelRGB(
							palette.elemR, palette.elemG, palette.elemB);
				if (::AdvanceDecode(image, stream, x, y,
										biWidth, biHeight, bytesAlign)) break;
			}
		} else if (biBitCount == 8) {
			ULONG bytesPerLine = biWidth;
			ULONG bytesAlign = (bytesPerLine + 3) / 4 * 4 - bytesPerLine;
			UCHAR ch;
			while (stream.Read(&ch, 1) == 1) {
				const Palette &palette = paletteTbl[ch];
				image.PutAndScanPixelRGB(
							palette.elemR, palette.elemG, palette.elemB);
				if (::AdvanceDecode(image, stream, x, y,
										biWidth, biHeight, bytesAlign)) break;
			}
		}
		image.EndDecode();
		Allocater::GetInstance()->Free(paletteTbl);
	} else if (biBitCount == 24) {
		ULONG bytesPerLine = 3 * biWidth;
		ULONG bytesAlign = (bytesPerLine + 3) / 4 * 4 - bytesPerLine;
		if (bfOffBits != 0) stream.Seek(bfOffBits);
		image.BeginDecode(biWidth, biHeight);
		UCHAR buff[3];
		while (stream.Read(buff, sizeof(buff)) == sizeof(buff)) {
			image.PutAndScanPixelRGB(buff[2], buff[1], buff[0]);
			if (::AdvanceDecode(image, stream, x, y,
										biWidth, biHeight, bytesAlign)) break;
		}
		image.EndDecode();
	} else if (biBitCount == 32) {
		ULONG bytesPerLine = 4 * biWidth;
		ULONG bytesAlign = (bytesPerLine + 3) / 4 * 4 - bytesPerLine;
		if (bfOffBits != 0) stream.Seek(bfOffBits);
		image.BeginDecode(biWidth, biHeight);
		UCHAR buff[4];
		while (stream.Read(buff, sizeof(buff)) == sizeof(buff)) {
			image.PutAndScanPixelRGB(buff[2], buff[1], buff[0]);
			if (::AdvanceDecode(image, stream, x, y,
										biWidth, biHeight, bytesAlign)) break;
		}
		image.EndDecode();
	} else {
		return false;
	}
	return true;
}

inline bool AdvanceEncode(BMPCodec::ImageSrc &image, BMPCodec::Stream &stream,
				int &x, int &y, int biWidth, int biHeight, int bytesAlign)
{
	x++;
	if (x < biWidth) return false;
	x = 0;
	y++;
	if (y >= biHeight) return true;
	image.ScanLine();
	stream.Write(const_cast<char *>("\x00\x00\x00\x00"), bytesAlign);
	return false;
}

bool BMPCodec::Encode(ImageSrc &image, const EncodeFlag &encodeFlag, Stream &stream)
{
	::memset(&_bfh, 0x00, 14);
	::memset(&_bih, 0x00, 40);
	int biWidth, biHeight;
	image.BeginEncode(&biWidth, &biHeight);
	ULONG bfOffBits = 14 + 40;
	ULONG bfSize = (3 * biWidth + 3) / 4 * 4 * biHeight + bfOffBits;
	USHORT biBitCount = 24;
	XPackUSHORT(_bfh.bfType,			0x4d42);
	XPackULONG(_bfh.bfSize,				bfSize);
	XPackUSHORT(_bfh.bfOffBits,			bfOffBits);
	XPackULONG(_bih.biSize,				40);
	XPackULONG(_bih.biWidth,			biWidth);
	XPackULONG(_bih.biHeight,			biHeight);
	XPackUSHORT(_bih.biPlanes,			1);
	XPackUSHORT(_bih.biBitCount,		biBitCount);
	XPackULONG(_bih.biCompression,		0);
	XPackULONG(_bih.biSizeImage,		0);
	XPackULONG(_bih.biXPelsPerMeter,	3780);
	XPackULONG(_bih.biYPelsPerMeter,	3780);
	XPackULONG(_bih.biClrUsed,			0);
	XPackULONG(_bih.biClrImportant,		0);
	if (stream.Write(&_bfh, 14) < 14) return false;
	if (stream.Write(&_bih, 40) < 40) return false;
	int x = 0, y = 0;
	if (biBitCount == 1 || biBitCount == 4 || biBitCount == 8) {
		// not implemented yet
		return false;
	} else if (biBitCount == 24) {
		ULONG bytesPerLine = 3 * biWidth;
		ULONG bytesAlign = (bytesPerLine + 3) / 4 * 4 - bytesPerLine;
		UCHAR buff[3];
		for (;;) {
			image.GetAndScanPixelRGB(buff[2], buff[1], buff[0]);
			stream.Write(buff, 3);
			if (::AdvanceEncode(image, stream, x, y,
									biWidth, biHeight, bytesAlign)) break;
		}
	} else {
		return false;
	}
	return true;
}
