#ifndef __OBJECT_STREAM_H__
#define __OBJECT_STREAM_H__

#include "Object.h"
#include "Stream.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Stream
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Stream : public Class {
public:
	Class_Stream(Environment *pEnvOuter);
	virtual bool CastFrom(Environment &env, Signal sig, Value &value);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

//-----------------------------------------------------------------------------
// Object_Stream
//-----------------------------------------------------------------------------
class DLLDECLARE Object_Stream : public Object {
public:
	class IteratorLine : public Iterator {
	private:
		Object_Stream *_pObj;
		int _nLinesMax;
		bool _includeEOLFlag;
		int _nLines;
	public:
		inline IteratorLine(Object_Stream *pObj, int nLinesMax, bool includeEOLFlag) :
			Iterator(pObj->GetStream().IsInfinite()), _pObj(pObj), _nLinesMax(nLinesMax),
			_includeEOLFlag(includeEOLFlag), _nLines(0) {}
		virtual ~IteratorLine();
		virtual bool DoNext(Environment &env, Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
public:
	AScript_DeclareObjectAccessor(Stream)
protected:
	Stream *_pStream;
public:
	inline Object_Stream(Environment &env, Stream *pStream) :
						Object(env.LookupClass(VTYPE_Stream)), _pStream(pStream) {}
	inline Object_Stream(Class *pClass, Stream *pStream) :
						Object(pClass), _pStream(pStream) {}
	inline Stream &GetStream() { return *_pStream; }
	virtual ~Object_Stream();
	virtual Iterator *CreateIterator(Signal sig);
	virtual Value DoPropGet(Signal sig, const Symbol *pSymbol, bool &evaluatedFlag);
	virtual String ToString(Signal sig, bool exprFlag);
};

}

#endif
