#ifndef __OBJECT_DATETIME_H__
#define __OBJECT_DATETIME_H__

#include "Object.h"
#include "Environment.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_DateTime / Object_DateTime
//-----------------------------------------------------------------------------
class DLLDECLARE Class_DateTime : public Class {
public:
	Class_DateTime(Environment *pEnvOuter);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLDECLARE Object_DateTime : public Object {
public:
	inline static Object_DateTime *GetSelfObj(Args &args) {
		return dynamic_cast<Object_DateTime *>(args.GetSelfObj());
	}
private:
	DateTime _dateTime;
public:
	inline Object_DateTime(Environment &env, const DateTime &dateTime) :
				Object(env.LookupClass(VTYPE_DateTime)), _dateTime(dateTime) {}
	inline Object_DateTime(Class *pClass, const DateTime &dateTime) :
				Object(pClass), _dateTime(dateTime) {}
	Object_DateTime(const Object_DateTime &obj);
	virtual ~Object_DateTime();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	inline const DateTime &GetDateTime() const { return _dateTime; }
};

}

#endif
