#ifndef __OBJECT_TIMEDELTA_H__
#define __OBJECT_TIMEDELTA_H__

#include "Object.h"
#include "Environment.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_TimeDelta / Object_TimeDelta
//-----------------------------------------------------------------------------
class DLLDECLARE Class_TimeDelta : public Class {
public:
	Class_TimeDelta(Environment *pEnvOuter);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLDECLARE Object_TimeDelta : public Object {
public:
	inline static Object_TimeDelta *GetSelfObj(Args &args) {
		return dynamic_cast<Object_TimeDelta *>(args.GetSelfObj());
	}
private:
	TimeDelta _timeDelta;
public:
	inline Object_TimeDelta(Class *pClass, const TimeDelta &timeDelta) :
				Object(pClass), _timeDelta(timeDelta) {}
	inline Object_TimeDelta(Environment &env, const TimeDelta &timeDelta) :
				Object(env.LookupClass(VTYPE_TimeDelta)), _timeDelta(timeDelta) {}
	Object_TimeDelta(const Object_TimeDelta &obj);
	virtual ~Object_TimeDelta();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	inline const TimeDelta &GetTimeDelta() const { return _timeDelta; }
};

}

#endif
