#ifndef __OBJECT_ERROR_H__
#define __OBJECT_ERROR_H__

#include "Object.h"
#include "Environment.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Error / Object_Error
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Error : public Class {
public:
	Class_Error(Environment *pEnvOuter);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLDECLARE Object_Error : public Object {
public:
	AScript_DeclareObjectAccessor(Error)
private:
	ErrorType _errType;
public:
	inline Object_Error(Environment &env, ErrorType errType) :
					Object(env.LookupClass(VTYPE_Error)), _errType(errType) {}
	inline Object_Error(Class *pClass, ErrorType errType) :
					Object(pClass), _errType(errType) {}
	Object_Error(const Object_Error &obj);
	virtual ~Object_Error();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	inline ErrorType GetErrorType() const { return _errType; }
};

}

#endif
