#==============================================================================
# Makefile for Borland C++
#==============================================================================
ASCRIPT_VERSION = 0.0.2

LIB_ASCRIPT_D = ..\lib\libascript.bcc.lib
LIB_ASCRIPT_S = ..\lib\libascript_s.bcc.lib
DLL_ASCRIPT = ..\libascript.bcc.dll

SRCS = \
Common.cpp Parser.cpp Expr.cpp Value.cpp Iterator.cpp \
Symbol.cpp String.cpp Environment.cpp Signal.cpp Formatter.cpp Option.cpp \
Function.cpp Operator.cpp Declaration.cpp \
Algorithm.cpp Codec.cpp \
Stream.cpp Directory.cpp DateTime.cpp OAL.cpp DLLMain.cpp

SRCS = $(SRCS) Object.cpp \
Object_Function.cpp Object_String.cpp Object_Binary.cpp \
Object_List.cpp Object_Matrix.cpp Object_Dict.cpp Object_Stream.cpp \
Object_DateTime.cpp Object_TimeDelta.cpp \
Object_Expr.cpp Object_Environment.cpp Object_Error.cpp Object_URI.cpp \
Object_Struct.cpp Object_Custom.cpp Object_Iterator.cpp Object_Semaphore.cpp \
Object_Image.cpp Object_Color.cpp Object_Palette.cpp Object_Audio.cpp Object_Codec.cpp

SRCS = $(SRCS) Module.cpp \
Module_basement.cpp \
Module_sys.cpp \
Module_codecs_basic\Module_codecs_basic.cpp \
Module_codecs_iso8859\Module_codecs_iso8859.cpp \
Module_codecs_japanese\Module_codecs_japanese.cpp \
Module_codecs_japanese\Conv_Japanese.cpp \
Module_fs\Module_fs.cpp \
Module_os\Module_os.cpp \
Module_path\Module_path.cpp \
Module_time\Module_time.cpp \
Module_string\Module_string.cpp \
Module_math\Module_math.cpp

OBJS = $(SRCS:.cpp=.obj)

OBJS_EXTRA = sfmt.obj

SFMTDIR = SFMT-src-1.3.3

LDFLAGS = -tWD -tWM -M -q \
-L$(MAKEDIR)\..\Lib -L$(MAKEDIR)\..\Lib\psdk -lS:10000000

CFLAGS = \
-q -I..\include -I$(MAKEDIR)\..\Include -w-8057 -w-8004 \
-DASCRIPT_VERSION=\"$(ASCRIPT_VERSION)\" -DASCRIPT_EXPORTS

#CFLAGS = $(CFLAGS) -DDEBUG_ASCRIPT

.cpp.obj:
	@bcc32 $(CFLAGS) -o$(<R).obj -c $<

all: program module

program: $(LIB_ASCRIPT_D)
	@cd Program_ascript
	@make
	@cd ..\Program_ascriptw
	@make
	@cd ..

module: $(LIB_ASCRIPT_D)
	@..\ascript build_modules.az install-root

$(LIB_ASCRIPT_D): $(DLL_ASCRIPT)
	@implib $@ $(DLL_ASCRIPT) >nul
	@echo $@ was created

$(LIB_ASCRIPT_S): $(OBJS) $(OBJS_EXTRA)
	@if exist $@ del $@ >nul
	@tlib $@ /P128 /a $**
	@echo $@ was created

$(DLL_ASCRIPT): $(OBJS) $(OBJS_EXTRA)
	@bcc32 $(LDFLAGS) -e$@ $**
	@echo $@ was created

sfmt.obj: $(SFMTDIR)\sfmt.c
	@bcc32 -I$(MAKEDIR)\..\Include -q -w-8027 -c -o$@ $**

clean: clean_module clean_program
	@del $(SRCS:.cpp=.obj)
	@del $(LIB_ASCRIPT_D) $(DLL_ASCRIPT) $(OBJS_EXTRA)
	@del $(DLL_ASCRIPT:.dll=.map) $(DLL_ASCRIPT:.dll=.tds)

clean_program:
	@cd Program_ascript
	@make clean
	@cd ..\Program_ascriptw
	@make clean
	@cd ..

clean_module:
	@..\ascript build_modules.az clean

#------------------------------------------------------------------------------
SVNREPO = https://svn.sourceforge.jp/svnroot/ascript

ZIPSRCFILE_PRE = ascript-$(ASCRIPT_VERSION)-src
ZIPBINFILE = ascript-$(ASCRIPT_VERSION)-win32.zip
ZIPBINFILE_EXTRA = ascript-extra-$(ASCRIPT_VERSION)-win32.zip

DISTFILES = \
ascript\ascript.exe \
ascript\ascriptw.exe \
ascript\ascriptshell.exe \
ascript\libascript.bcc.dll \
ascript\module\*.az \
ascript\module.bcc\*.az \
ascript\module.bcc\*.azd \
ascript\module.bcc\net\*.az \
ascript\module.bcc\net\*.azd \
ascript\module.bcc\codecs\*.az \
ascript\module.bcc\codecs\*.azd \
ascript\test\test-*.az \
ascript\test\50records-en.csv \
ascript\test\50records-jp.csv \
ascript\test\temperature.txt \
ascript\test\chars-cp932.txt \
ascript\test\chars-eucjp.txt \
ascript\test\chars-utf8-jp.txt \
ascript\test\chars-jis.txt \
ascript\test\ipss.go.jp-report-1.csv \
ascript\test\testall.bat \
ascript\test\result\test-*.sample.txt \
ascript\sample\cairo\cairo-*.az \
ascript\sample\canvas\canvas-*.az \
ascript\sample\freetype\freetype-*.az \
ascript\sample\http\http-*.az \
ascript\sample\http\proxy_setting.sample.az \
ascript\sample\misc\*.az \
ascript\sample\opengl\gl-*.az \
ascript\sample\opengl\*.rgb \
ascript\sample\resource\readme.txt \
ascript\sample\resource\*.ico \
ascript\sample\resource\*.gif \
ascript\sample\resource\*.jpg \
ascript\sample\resource\*.bmp \
ascript\sample\resource\*.png \
ascript\sample\resource\*.ttf \
ascript\sample\resource\*.zip \
ascript\sample\scribble\*.az \
ascript\sample\sdl\sdl-*.az \
ascript\sample\tk\tk-*.az \
ascript\sample\win32\win32-*.az \
ascript\extra\lib.win32\*.dll \
ascript\extra\tcl\bin\*.dll \
ascript\extra\tcl\lib\*.*

listtag:
	svn ls $(SVNREPO)/tags

deltag:
	svn del $(SVNREPO)/tags/$(ASCRIPT_VERSION) -m ""

maketag:
	svn copy $(SVNREPO)/trunk $(SVNREPO)/tags/$(ASCRIPT_VERSION) -m "version $(ASCRIPT_VERSION) release"

distsrc:
	if exist ascript-$(ASCRIPT_VERSION) rmdir /s /q ascript-$(ASCRIPT_VERSION)
	svn export $(SVNREPO)/tags/$(ASCRIPT_VERSION) ascript-$(ASCRIPT_VERSION)
	7z a $(ZIPSRCFILE_PRE).tar ascript-$(ASCRIPT_VERSION)
	7z a $(ZIPSRCFILE_PRE).tar.gz $(ZIPSRCFILE_PRE).tar
	del $(ZIPSRCFILE_PRE).tar
	move /Y $(ZIPSRCFILE_PRE).tar.gz ..\..
	rmdir /s /q ascript-$(ASCRIPT_VERSION)

distbin:
	cd ..\..
	del $(ZIPBINFILE)
	7z a $(ZIPBINFILE) $(DISTFILES)
