//-----------------------------------------------------------------------------
// AScript testm module
//-----------------------------------------------------------------------------
#include <ascript.h>

AScript_BeginModule(testm)

class AudioSrc {
public:
	virtual ~AudioSrc();
};

class AudioDst {
public:
	virtual ~AudioDst();
};

typedef std::vector<AudioSrc *> AudioSrcList;
typedef std::vector<AudioDst *> AudioDstList;

AudioSrc::~AudioSrc()
{
}

AudioDst::~AudioDst()
{
}

//-----------------------------------------------------------------------------
// Object_Audio declaration
//-----------------------------------------------------------------------------
AScript_DeclarePrivClass(Audio);

class Object_Audio : public Object {
private:
	AudioSrcList _audioSrcList;
	AudioDstList _audioDstList;
public:
	AScript_DeclareObjectAccessor(Audio)
public:
	inline Object_Audio() : Object(AScript_PrivClass(Audio)) {}
	virtual ~Object_Audio();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	inline void AddSrc(AudioSrc *pAudioSrc) { _audioSrcList.push_back(pAudioSrc); }
	inline void AddDst(AudioDst *pAudioDst) { _audioDstList.push_back(pAudioDst); }
};

//-----------------------------------------------------------------------------
// Object_Audio implementation
//-----------------------------------------------------------------------------
Object_Audio::~Object_Audio()
{
	foreach (AudioSrcList, ppAudioSrc, _audioSrcList) {
		delete *ppAudioSrc;
	}
	foreach (AudioDstList, ppAudioDst, _audioDstList) {
		delete *ppAudioDst;
	}
}

Object *Object_Audio::Clone() const
{
	return NULL;
}

String Object_Audio::ToString(Signal sig, bool exprFlag)
{
	return String("<Audio>");
}

//-----------------------------------------------------------------------------
// AScript interfaces for Object_Audio
//-----------------------------------------------------------------------------
// testm.audio#test()
AScript_DeclareMethod(Audio, test)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
}

AScript_ImplementMethod(Audio, test)
{
	Object_Audio *pSelf = Object_Audio::GetSelfObj(args);
	return Value(env, "Audio object");
}

// implementation of class Audio
AScript_ImplementPrivClass(Audio)
{
	AScript_AssignMethod(Audio, test);
}

//-----------------------------------------------------------------------------
// AScript module functions: testm
//-----------------------------------------------------------------------------
// testm.audio()
AScript_DeclareFunction(audio)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
}

AScript_ImplementFunction(audio)
{
	Object_Audio *pObjAudio = new Object_Audio();
	return Value(pObjAudio);
}

// Module entry
AScript_ModuleEntry()
{
	// class realization
	AScript_RealizePrivClass(Audio, "audio", env.LookupClass(VTYPE_Object));
	// function assignment
	AScript_AssignFunction(audio);
}

AScript_ModuleTerminate()
{
}

AScript_EndModule(testm, testm)

AScript_RegisterModule(testm)
