//---------------------------------------------------------------------------
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
//		asticyan	ver.1.0 
//		アイデアプロセッサー JavaScript部
//		(C)Copyright 2006 , Yoshimiti ENDOU All right reserved.
//---------------------------------------------------------------------------
//unit01.jsは付箋に関する処理
//---------------------------------------------------------------------------
gZindexMax = 100;			//zIndexの値
gZindexMin = 100;
gID        = 0;				//現在の付箋のID
//---------------------------------------------------------------------------
function LabelMenu(pElement)
//付箋のメニューをクリックした
//引数	pElement:メニューオブジェクト
{
	var		aFlag;

	gID = pElement.parentNode.id;		//現在の付箋のIDをグローバル変数に記憶する

	aFlag = GetAttK(gID,kEditable);
	if(aFlag == 1) {					//1:編集可能
		$('iLabelMenu').style.top  = ($(gID).offsetTop  + gMenuPosOffset) + 'px';
		$('iLabelMenu').style.left = ($(gID).offsetLeft + gMenuPosOffset) + 'px';
		ShowObject('iLabelMenu');
	} else {
		$('iLabelMenu2').style.top  = ($(gID).offsetTop  + gMenuPosOffset) + 'px';
		$('iLabelMenu2').style.left = ($(gID).offsetLeft + gMenuPosOffset) + 'px';
		ShowObject('iLabelMenu2');
	}
}
//---------------------------------------------------------------------------
function SizeLabel(pSize)
//ラベルの大きさを見やすいように調整する
//引数		pSize:設定値 0:auto 1:横幅制限 2:縮小表示
{
	var		id;

	id = gID + '.content';
	switch(Number(pSize)) {
		case 0:		$(id).style.height  = 'auto';	//付箋の中身の大きさ
					$(id).style.width   = 'auto';
					$(gID).style.height = 'auto';	//付箋の外側
					$(gID).style.width  = 'auto';
					break;
		case 1:		$(id).style.height  = 'auto';
					$(id).style.width   = (gShrinkWidth  - 0.2) + 'em';
					$(gID).style.height = 'auto';
					$(gID).style.width  =  gShrinkWidth  + 'em';
					break;
		case 2:		$(id).style.height  = (gShrinkHeight - 1.3) + 'em';
					$(id).style.width   = (gMiniWidth    - 0.2) + 'em';
					$(gID).style.height =  gShrinkHeight + 'em';
					$(gID).style.width  =  gMiniWidth    + 'em';
					break;
	}
	SetAttK(gID,kSize,pSize);
}
//---------------------------------------------------------------------------
function SizeAllLabel(pSize)
//全ての付箋の大きさを変える
{
	var		aLabelList,i,aFlag;

	aLabelList = document.getElementsByClassName('cLabel');
	for(i=0;i<aLabelList.length;i++) {
		gID = aLabelList[i].id;
		aFlag = GetAttK(gID,kEditable);
		if((pSize == '2') || (aFlag == '1'))SizeLabel(pSize);
	}
}
//---------------------------------------------------------------------------
function ToggleEditF()
//編集制限フラグを反転し、データファイルの書き込み可能パーミッションを変更する
{
	var		aFlag,key,key2,aAtt;

	aFkag = GetAttK(gID,kEditable);
	key   = GetAttK(gID,kKeyWord);

	if(aFkag == 1) {		//編集可能なので不可にする
		key2 = prompt('管理キーワードを入力してください。管理キーワードは英数字のみです。\n管理キーワードは付箋毎に設定できます。','');
		if(key2 == null) {
			alert('管理キーワードが入力されませんでした');
			return;
		}
		if(key2.search(/\W/) != -1) {
			alert('入力に英数字以外があります');
			return;
		}
		aFkag = 0;
	} else {				//編集不可なので可能にする
		key2 = prompt('管理キーワードを入力してください。\n管理キーワードは付箋毎に設定されています。','');
		if(key != key2) {
			alert('管理キーワードが一致しませんでした');
			return;
		}
		aFkag = 1;
	}

	SetAttK(gID,kEditable,aFkag);
	SetAttK(gID,kKeyWord,key2);
	aAtt = GetAtt(gID);

	SendData('AttLabelE',gID,aAtt,'dummy');
}
//---------------------------------------------------------------------------
function DelLabel()
//付箋削除
{
	var		ret,now,sec;

	ret = confirm('削除してもよろしいですか？\n削除したものを復活させることはできません。');
	if(ret) {
		now   = new Date();
		sec   = now.getSeconds();		//秒
		switch(sec % 4) {				//お遊び
			case 0:		Effect.BlindUp(gID,{afterFinishInternal:EffectFinished});	break;
			case 1:		Effect.Fade(gID,{afterFinishInternal:EffectFinished});		break;
			case 2:		Effect.Shrink(gID,{afterFinishInternal:EffectFinished});	break;
			case 3:		Effect.DropOut(gID,{afterFinishInternal:EffectFinished});	break;
		}
		//他に色々な効果がある。ただし、効果の中にはafterFinishInternalが無いものもあるので注意

		SendData('DelLabel',gID,'dummy','dummy');
	}
}
//---------------------------------------------------------------------------
function EffectFinished()
//削除の効果が終わってから、実体を消す
//すぐに消してしまうと、効果が現れない
{
	document.body.removeChild($(gID));
}
//---------------------------------------------------------------------------
function ToFront()
//付箋を最前面へ
{
	var		index;

	$(gID).style.zIndex = ++gZindexMax;
}
//---------------------------------------------------------------------------
function ToRear()
//付箋を最背面へ
{
	var		index;

	--gZindexMin;
	if(gZindexMin < 1) gZindexMin = 1;
	$(gID).style.zIndex = gZindexMin;
}
//---------------------------------------------------------------------------
function AttLabel()
//付箋の属性を保存する--メニューでは「位置保存」
{
	var		aAtt;

	aAtt = GetAtt(gID);
	SendData('AttLabel',gID,aAtt,'dummy');
}
//---------------------------------------------------------------------------
function SetAllLabel()
//全ての付箋の属性を保存する
{
	var		aLabelList,i;

	aLabelList = document.getElementsByClassName('cLabel');
	for(i=0;i<aLabelList.length;i++) {
		gID = aLabelList[i].id;
		AttLabel();
	}
}
//---------------------------------------------------------------------------
function EditLabel()
//内容を変更するために、編集ウインドウを出す
{
	var		txt;

	txt                       = $(gID + '.content').innerHTML;
	if(kReplaceCR) txt        = txt.replace(/<br \/>\n*|<br>\n*/ig,'\n');
	txt                       = unescapeHTML(txt);

	$('iEditText').value      = txt;
	$('iEditForm').style.top  = $(gID).style.top;		//フォームを適当な位置に持ってきて表示
	$('iEditForm').style.left = $(gID).style.left;
	ShowObject('iEditForm');
}
//---------------------------------------------------------------------------
function EditNewLabel(pID)
//新しい付箋を作るために、編集ウインドウを出す
//引数	pID:呼び出したオブジェクトのID - pIDは上部のメニューと付箋のメニューがある
{
	gID = 'new';										//新規付箋の仮ID

	$('iEditText').value      = '';
	$('iEditForm').style.top  = $(pID).style.top;		//フォームを適当な位置に持ってきて表示
	$('iEditForm').style.left = $(pID).style.left;
	ShowObject('iEditForm');
}
//---------------------------------------------------------------------------
function EditNewLabelDBClick(evt)
//ダブルクリックされたときに、新しい付箋を作るために、編集ウインドウを出す
//引数	evt:イベントオブジェクト
{
	gID = 'new';										//新規付箋の仮ID

	$('iEditText').value      = '';
	$('iEditForm').style.top  = (Event.pointerY(evt) - gMenuPosOffset) + 'px';	//フォームを適当な位置に持ってきて表示
	$('iEditForm').style.left = (Event.pointerX(evt) - gMenuPosOffset) + 'px';
	ShowObject('iEditForm');
}
//---------------------------------------------------------------------------
function EditFormDBClick(evt)
//編集ウインドウでのダブルクリックのフック
{
	Event.stop(evt);	//イベントをここで止めて親に渡さない
}
//---------------------------------------------------------------------------
function DecideChange()
//編集確定
{
	HideObject('iEditForm');

	if(gID == 'new') NewLabel();	//箋を作る
	  else			 ModLabel();	//付箋を変更
}
//---------------------------------------------------------------------------
function ModLabel()
//付箋を変更
{
	var		aAtt,txt,aFlag;

	txt                           = $F('iEditText');	//ブラウザに表示しているデータを更新
	if(! kAllowHTML) txt          = escapeHTML(txt);
	if(kReplaceCR)   txt          = txt.replace(/\r\n|\r|\n/g,'<br />\n');
	$(gID + '.content').innerHTML = txt;

	$(gID).style.color            = $F('iLabelColor');
	$(gID).style.borderColor      = $F('iLabelBorderColor');
	$(gID).style.backgroundColor  = $F('iLabelBackColor');

	aAtt = GetAtt(gID);
	SendData('ModLabel',gID,aAtt,txt);					//サーバーのデータを更新
}
//---------------------------------------------------------------------------
function NewLabel()
//付箋を作る
{
	var		aAtt,a,id,aNewLabel,aContPart,txt;

	a                        = new Array();
	id                       = MakeIDFromDate();								//日付を元にIDを作る

	a[kID]                   = id;												//付箋の属性を作る
	a[kX]                    = parseInt($('iEditForm').style.left);
	a[kY]                    = parseInt($('iEditForm').style.top);
	a[kLabelColor]           = gColorValue.indexOf($F('iLabelColor'));
	a[kLabelBorderColor]     = gColorValue.indexOf($F('iLabelBorderColor'));
	a[kLabelBackColor]       = gColorValue.indexOf($F('iLabelBackColor'));
	a[kZIndex]               = ++gZindexMax;
	a[kSize]                 = 0;
	a[kEditable]             = 1;
	a[kKeyWord]              = 'asticyan';
	aAtt                     = a.join();

	aNewLabel                = MakeLabelFrame(aAtt);							//外枠を作る
	document.body.appendChild(aNewLabel);										//ドキュメントに登録する
	gID                      = aNewLabel.id;

	txt                      = $F('iEditText');
	if(! kAllowHTML) txt     = escapeHTML(txt);
	if(kReplaceCR)   txt     = txt.replace(/\r\n|\r|\n/g,'<br />\n');

	aContPart                = document.createElement('div');					//内容を作る
	aContPart.id             = id + '.content';
	aContPart.innerHTML      = txt;
	aContPart.style.overflow = 'hidden';
	aNewLabel.appendChild(aContPart);											//外枠に中身を入れる

	$(gID + '.attr').style.width    = gMiniWidth + 'em';							//最小の大きさにする（つっかい棒）
	$(gID + '.attr').style.overflow = 'hidden';
	SizeLabel(0);															//ラベルの大きさの調整

	new Draggable(aNewLabel,{starteffect:DragStartEff,endeffect:DragEndEff});	//動くようにする

	SendData('NewLabel',id,aAtt,txt);
}
//---------------------------------------------------------------------------
function GetAtt(pID)
//付箋のすべての属性を文字列にして得る
//引数		pID:付箋のID
//戻り値	属性 , でつないだ文字列
{
	var		a,aAtt;

	aAtt = $(pID + '.attr').innerHTML;			//innerHTMLは変な変換を行うが、属性データに変換を伴うものはない
	a    = aAtt.split(',');;

	a[kX]                = parseInt($(pID).style.left);
	a[kY]                = parseInt($(pID).style.top);
	a[kLabelColor]       = gColorValue.indexOf($(pID).style.color);
	a[kLabelBorderColor] = gColorValue.indexOf($(pID).style.borderLeftColor);	//borderColorではなくborderLeftColorにするところがミソ
	a[kLabelBackColor]   = gColorValue.indexOf($(pID).style.backgroundColor);
	a[kZIndex]           = $(pID).style.zIndex;
	aAtt                 = a.join();

	return(aAtt);
}
//---------------------------------------------------------------------------
function GetAttK(pID,pKey)
//付箋の指定された属性を得る
//引数		pID:付箋のID
//			pKey:属性の識別子
//戻り値	指定された属性の値
{
	var		aAtt,a;

	aAtt = GetAtt(pID);
	a    = aAtt.split(',');;

	return(a[pKey]);
}
//---------------------------------------------------------------------------
function SetAtt(pID,pAtt)
//付箋に属性を設定する -- サーバーには書きにいかない
//引数		pID:付箋のID
//			pAtt:属性の文字列
{
	$(pID + '.attr').innerHTML = pAtt;
}
//---------------------------------------------------------------------------
function SetAttK(pID,pKey,pValue)
//付箋の属性の指定されたものを入れ替える
//引数		pID:付箋のID
//			pKey:属性の識別子
//			pValue:変更する値
{
	var		aAtt,a,id;

	aAtt    = $(pID + '.attr').innerHTML;

	a       = aAtt.split(',');;
	a[pKey] = pValue;
	aAtt    = a.join();

	$(pID + '.attr').innerHTML = aAtt;
}
//---------------------------------------------------------------------------
function ShowLabel()
//テスト用の関数
//gIDの情報を表示
{
	var		a,str,aAtt,aAtt2;

	aAtt = GetAtt(gID);
	a    = aAtt.split(',');

	aAtt2 = new Array();
	aAtt2[kID]               = 'ID       = ' + a[kID];
	aAtt2[kX]                = 'Left     = ' + a[kX];
	aAtt2[kY]                = 'Top      = ' + a[kY];
	aAtt2[kLabelColor]       = 'Color    = ' + a[kLabelColor]       + ' : ' + $(gID).style.color;
	aAtt2[kLabelBorderColor] = 'BDColor  = ' + a[kLabelBorderColor] + ' : ' + $(gID).style.borderColor;
	aAtt2[kLabelBackColor]   = 'BGColor  = ' + a[kLabelBackColor]   + ' : ' + $(gID).style.backgroundColor;
	aAtt2[kZIndex]           = 'ZIndex   = ' + a[kZIndex];
	aAtt2[kSize]             = 'kSize    = ' + a[kSize];
	aAtt2[kEditable]         = 'Editable = ' + a[kEditable];
	aAtt2[kKeyWord]          = 'KeyWord  = ' + a[kKeyWord];

	str = aAtt2.join('\n');
	str = aAtt + '\n' + str + '\n---- content ----\n' + $(gID  + '.content').innerHTML;
	alert(str);
}
//---------------------------------------------------------------------------
function SendData(pCmd,pID,pAtt,pText)
//データをiSendDataフォームを利用して送信する
//iSendDataはURLエンコードのため利用する
//引数		pCmd  :コマンド
//			pID   :付箋ID
//			pAtt  :付箋属性
//			pText :内容
{
	var		param,aAjax;

	if(kDebug) ShowObject('iInfo');

	param = 'nCmd=' + pCmd + '&nID=' + pID + '&nAtt=' + pAtt + '&nText=' + encodeURIComponent(pText);
	aAjax = new Ajax.Updater('iInfoText',gCGIProgram,{method: 'post',parameters: param,onFailure: ErrorAlert});
}
//---------------------------------------------------------------------------
