//---------------------------------------------------------------------------
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
//unit03.jsはその他の処理
//---------------------------------------------------------------------------
gMenuFlag    = 'none';				//[メニュー]をクリックしたかどうか
gSizeValue   = 0;					//大きさのレベル
//---------------------------------------------------------------------------
function escapeHTML(text)
//HTMLタグを変換する
//引数		text：変換する文字列
{
	text = text.replace(/&/g,'&amp;');
	text = text.replace(/</g,'&lt;');
	text = text.replace(/>/g,'&gt;');
	text = text.replace(/\"/g,'&quot;');
	text = text.replace(/\'/g,'&#39;');
	return(text);
}
//---------------------------------------------------------------------------
function unescapeHTML(text)
//escapeHTMLの反対
//引数		text：変換する文字列
{
	text = text.replace(/&amp;/g,'&');
	text = text.replace(/&lt;/g,'<');
	text = text.replace(/&gt;/g,'>');
	text = text.replace(/&quot;/g,'\"');
	text = text.replace(/&#39;/g,'\'');
	return(text);
}
//---------------------------------------------------------------------------
function Sleep(pTime)
//時間待ち
//引数		pTime：待ち時間(sec)
{
	var		d1,d2;

	d1 = new Date().getTime();
	d2 = new Date().getTime();
	while( d2 < d1 + 1000 * pTime ){		//pTime秒待つ
		d2 = new Date().getTime();
	}
	return;
} 
//---------------------------------------------------------------------------
function About()
//このサイトについて
{
	SendPageCmd('About','dummy','dummy');
	ShowObject('iInfo');
	$('iInfo').style.top  = (gMenuPosOffset) + 'px';
	$('iInfo').style.left = (gMenuPosOffset) + 'px';
}
//---------------------------------------------------------------------------
function MakeIDFromDate()
//日付を元にIDを作る
//戻り値	IDの文字列
{
	var		now,year,month,day,hour,min,sec,id;

	now   = new Date();

	year  = now.getFullYear();		//年
	month = now.getMonth() + 1;		//月
	day   = now.getDate();			//日
	hour  = now.getHours();			//時
	min   = now.getMinutes();		//分
	sec   = now.getSeconds();		//秒

	//数値が1桁の場合、頭に0を付けて2桁で表示する指定
	year = String(year);
	if(month < 10) {month = '0' + month;} else {month = String(month);}
	if(day   < 10) {day   = '0' + day;}   else {day   = String(day);}
	if(hour  < 10) {hour  = '0' + hour;}  else {hour  = String(hour);}
	if(min   < 10) {min   = '0' + min;}   else {min   = String(min);}
	if(sec   < 10) {sec   = '0' + sec;}   else {sec   = String(sec);}
	id = 'i' + year + month + day + hour + min + sec;
	return(id);
}
//---------------------------------------------------------------------------
function ErrorAlert(request)
//エラーの場合、内容を表示する
{
	ShowObject('iInfo');
	alert('通信中にエラーが起きました');
}
//---------------------------------------------------------------------------
function HideObject(pObjectID)
//オブジェクトを非表示にする
//引数	pObjectID:オブジェクトのID
{
	$(pObjectID).style.visibility = 'hidden';
	gMenuFlag                     = 'none';
}
//---------------------------------------------------------------------------
function ShowObject(pObjectID)
//オブジェクトを表示にする
//引数	pObjectID:オブジェクトのID
{
	$(pObjectID).style.visibility = 'visible';
	$(pObjectID).style.zIndex     = gZindexMax + 1;
	gMenuFlag                     = pObjectID;
}
//---------------------------------------------------------------------------
function CloseMenus()
//開いているメニューを閉じる
//window.document.onclick = CloseMenusにより、<div>へのイベントがまわってくる
{
	switch(gMenuFlag) {
		case 'iLabelMenu':	HideObject('iLabelMenu2');HideObject('iMainMenu');break;
		case 'iLabelMenu2':	HideObject('iMainMenu');HideObject('iLabelMenu');break;
		case 'iMainMenu':	HideObject('iLabelMenu');HideObject('iLabelMenu2');break;
		default:			HideObject('iLabelMenu');HideObject('iLabelMenu2');HideObject('iMainMenu');
	}
	gMenuFlag = 'none';
}
//---------------------------------------------------------------------------
function PageMenu()
//ページ上部のメニューをクリックした
{
	$('iMainMenu').style.top  = ($('iMenu').offsetTop  + gMenuPosOffset) + 'px';
	$('iMainMenu').style.left = ($('iMenu').offsetLeft + gMenuPosOffset) + 'px';
	ShowObject('iMainMenu');
}
//---------------------------------------------------------------------------
function AddShowLabelFunc()
//デバッグの時の追加メニュー
{
	var		info,info2;

	info            = document.createElement("span");
	info.innerHTML  = '[情報]';
	info.onclick    = ShowLabel;
	$('iLabelMenu').appendChild(info);

	info2           = document.createElement("span");
	info2.innerHTML = '[情報]';
	info2.onclick   = ShowLabel;
	$('iLabelMenu2').appendChild(info2);
}
//---------------------------------------------------------------------------
function DragStartEff(element)
//ドラッグする前の効果
//引数	element:現在のオブジェクト
//透明にする
{
	element._opacity = Element.getOpacity(element);
	new Effect.Opacity(element, {duration:0.1, from:element._opacity, to:1.0});
}
//---------------------------------------------------------------------------
function DragEndEff(element)
//ドラッグした後の効果
//引数	element:現在のオブジェクト
//透明度を元に戻す
{
	var toOpacity = typeof element._opacity == 'number' ? element._opacity : 1.0
	new Effect.Opacity(element, {duration:0.5, from:1.0, to:toOpacity});
}
//---------------------------------------------------------------------------
function MakeColorList()
//入力、編集時の色選択コンボボックスを作る
{
	var		str,i;

	str = '\n';
	for(i=0;i<gColorValue.length;i++) {
		str = str + '  <option value=\"' + gColorValue[i] + '\">' + gColorName[i] + '</option>\n';
	}
	//I.Eの場合、selectタグはinnerHTMLに対応していない(FireFoxは対応しているみたいだが)
	$('iSelectA').innerHTML = '文字色\n<select id=\"iLabelColor\" name=\"nLabelColor\">'         + str + '</select>';
	$('iSelectB').innerHTML = '境界色\n<select id=\"iLabelBorderColor\" name=\"nLabelBrColor\">' + str + '</select>';
	$('iSelectC').innerHTML = '背景色\n<select id=\"iLabelBackColor\" name=\"nLabelBackColor\">' + str + '</select>';

	$('iLabelColor').selectedIndex       = kDefaultColor;	//初期状態で選択されているもの
	$('iLabelBorderColor').selectedIndex = kDefaultBorderColor;
	$('iLabelBackColor').selectedIndex   = kDefaultBackColor;
}
//---------------------------------------------------------------------------
function MakeLastPart(pID)
//最終更新日の欄を作る
//引数	pID:付箋のid
{
	var		part;

	part                = document.createElement('div');
	part.id             = pID + '.last';
	part.className      = 'cLast';
	part.style.overflow = 'hidden';
	return(part);
}
//---------------------------------------------------------------------------
function MakeContPart(pID)
//ページを表示したときのHTMLデータから付箋の本体を作る
//引数	pID:付箋のid
{
	var		part;

	part                = document.createElement('div');
	part.id             = pID + '.content';
	part.innerHTML      =  $(pID + '.txt').innerHTML;			//innerHTMLは予期しない変換を行っている <br />-><BR>とか & -> &amp;とか．．．
	part.style.overflow = 'hidden';
	return(part);
}
//---------------------------------------------------------------------------
function MakeLabelFrame(pAtt)
//付箋の外枠を作る
//引数		pAtt:属性文字列
//戻り値	作った付箋の外枠
//変更する要素はここで必ず設定する
{
	var		aAtt,aNewLabel,aMenu;

	aAtt = pAtt.split(',');		//属性文字列を分解
	//付箋の属性 aAtt[kID]:id  [kX]:X  [kY]:Y  [kLabelColor]:文字色  [kLabelBorderColor]:境界色
	//           aAtt[kLabelBackColor]:背景色 [kZIndex]:Z  [kSize]:付箋の大きさ(0:auto 1:横幅制限 2:縮小表示)
	//           aAtt[kEditable]:編集可能(1:編集可能) [kKeyWord]:編集可能にするキーワード

	//外枠
	aNewLabel                   = document.createElement("div");
	aNewLabel.className         = 'cLabel';
	aNewLabel.id                = aAtt[kID];
	aNewLabel.style.left        = aAtt[kX] + 'px';
	aNewLabel.style.top         = aAtt[kY] + 'px';
	aNewLabel.style.width       = 'auto';
	aNewLabel.style.height      = 'auto';
	aNewLabel.style.color       = gColorValue[aAtt[kLabelColor]];			//文字色
	aNewLabel.style.borderColor = gColorValue[aAtt[kLabelBorderColor]];		//境界線の色
	aNewLabel.style.backgroundColor = gColorValue[aAtt[kLabelBackColor]];	//背景色
	aNewLabel.style.zIndex      = Number(aAtt[kZIndex]);					//Zオーダー  JavaScriptで参照渡しがわからないので、グローバル変数を使う  明示的に数字にしておかないと後にうまくいかない
	gSizeValue                  = aAtt[kSize];								//画面ロード時の大きさ まだ付箋が登録されていないのでShrinkLabelを呼び出すことができない

	//メニュー、属性
	aMenu = '<div class=\"cFixedMenu\" onclick=\"LabelMenu(this)\">［メニュー］</div>' + 
	        '<div id=\"' + aAtt[kID] + '.attr\" class=\"cHiddenObject\">' + pAtt + '</div>';
	aNewLabel.innerHTML = aMenu;

	return(aNewLabel);
}
//---------------------------------------------------------------------------
window.onload = function()
//JavaScriptが読み込まれて実行する関数
{
//付箋を作る
	var		aLabelList,aContPart,aNewLabel,zindex,aLastMod;

	gZindexMax = gZindexMin = 100;
	aLabelList = document.getElementsByName('nLabelList');
	for(i=0;i<aLabelList.length; i++) {
		aNewLabel = MakeLabelFrame(aLabelList[i].value);								//外枠を作る
		document.body.appendChild(aNewLabel);											//ドキュメントに登録する
		gID       = aNewLabel.id;
		aContPart = MakeContPart(gID);													//ページを表示したときのHTMLデータから付箋の本体を作る
		aNewLabel.appendChild(aContPart);												//外枠に中身を入れる
		aLastMod  = MakeLastPart(gID);													//最終更新日の欄を作る
		aNewLabel.appendChild(aLastMod);
		RecvData('SendLastMod',gID + '.last',gID);										//最終更新日を変更
		$(gID + '.attr').style.width    = gMiniWidth + 'em';							//最小の大きさにする（つっかい棒）
		$(gID + '.attr').style.overflow = 'hidden';
		SizeLabel(gSizeValue);															//付箋の大きさの調整

		zindex = Number(aNewLabel.style.zIndex);										//Zオーダーの確認
		if(gZindexMax < zindex) gZindexMax = zindex;
		if(zindex < gZindexMin) gZindexMin = zindex;

		new Draggable(aNewLabel,{starteffect:DragStartEff,endeffect:DragEndEff});		//動くようにする
	}

	new Draggable($('iEditForm'),{starteffect:DragStartEff,endeffect:DragEndEff});		//動くようにする
	new Draggable($('iInfo'),{starteffect:DragStartEff,endeffect:DragEndEff});			//動くようにする

	$('iEditForm').style.width = (gShrinkWidth + 3) + 'em';								//入力用ウインドウの幅を設定
	MakeColorList();																	//入力、編集時の色選択コンボボックスを作る

	window.document.onclick    = CloseMenus;											//何もないところをクリックしたらメニューを閉じる
	Event.observe(window.document, "dblclick", EditNewLabelDBClick, false);				//I.E.で動かすにはこれが大事
	window.document.ondblclick = EditNewLabelDBClick;									//ダブルクリックしたら新規編集 I.Eでは重要
	Event.observe($('iEditForm'), "dblclick", EditFormDBClick, false);					//編集ウインドウでのダブルクリックのフック　順番もI.E.では重要

	if(kDebug) AddShowLabelFunc();														//デバッグの時の追加メニュー
}
//---------------------------------------------------------------------------
