#
# A.T.Edit -- Another Tcl/Tk based text editor
# Copyright (C) 2004 Shinji Moiino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#-- edit_menu.tcl --
#
### Functions called by callback functions. ###################################
#
#------------------------------------------------------------------------------
# @editmenu_delete_dialog
#------------------------------------------------------------------------------
proc editmenu_delete_dialog {} {
    global RES
    set RES "cancel"
}

#------------------------------------------------------------------------------
# @editmenu_find_input_dialog
#------------------------------------------------------------------------------
proc editmenu_find_input_dialog {} {
    global RES
    global TEMP_FIND_WORD TEMP_FIND_NOCASE
    global TEMP_FIND_SELECTION
    global CST_BTN_FONT
    global M3006 M5001 M5003 M5004 M5005 WM5005 M5006 M5014

    # Create the toplevel dialog
    toplevel .dlg
    wm title .dlg $M3006
    wm protocol .dlg WM_DELETE_WINDOW editmenu_delete_dialog
    wm resizable .dlg 0 0

    frame .dlg.f1
    pack .dlg.f1 -side top -fill x -anchor w
        LabelEntry .dlg.f1.ent -label $M5001
        pack .dlg.f1.ent -fill x -padx 4 -pady 4 -anchor w

        #Start find when return key is pressed.
        bind .dlg.f1.ent.e <Return> {
            set RES "forwards"
        }
        bind .dlg.f1.ent.e <F3> {
            set RES "forwards"
        }
        bind .dlg.f1.ent.e <Shift-F3> {
            set RES "backwards"
        }
        bind .dlg.f1.ent.e <Escape> {
            set RES "cancel"
        }

    frame .dlg.f2
    pack .dlg.f2 -side top -fill x  -anchor w
        checkbutton .dlg.f2.cb1 -text $M5003 -variable TEMP_FIND_NOCASE
        if {$TEMP_FIND_NOCASE == 1} {
            .dlg.f2.cb1 select
        } else {
            .dlg.f2.cb1 deselect
        }
        pack .dlg.f2.cb1 -fill x -side left

    frame .dlg.f3
    pack .dlg.f3 -side top -fill x  -anchor w
        checkbutton .dlg.f3.cb1 -text $M5014 -variable TEMP_FIND_SELECTION
        set selrange [.base.textarea tag ranges sel]
        if { $selrange != ""} {
            set str [.base.textarea get \
                                 [lindex $selrange 0] [lindex $selrange 1]]
            if {[regexp -all -- \n "$str"] || [regexp -all -- \r "$str"]} {
                .dlg.f1.ent.e insert 0 $TEMP_FIND_WORD
                .dlg.f1.ent.e icursor end
                .dlg.f1.ent.e selection range 0 end
                .dlg.f3.cb1 select
            } else {
                .dlg.f1.ent.e insert 0 $str
                .dlg.f1.ent.e icursor end
                .dlg.f1.ent.e selection range 0 end
                .dlg.f3.cb1 deselect
            }
        } else {
            .dlg.f1.ent.e insert 0 $TEMP_FIND_WORD
            .dlg.f1.ent.e icursor end
            .dlg.f1.ent.e selection range 0 end
            .dlg.f3.cb1 deselect
        }
        pack .dlg.f3.cb1 -fill x -side left

    # Create a separator  
    Separator  .dlg.s1 -orient horizontal
    pack .dlg.s1 -fill x -padx 2 -pady 2

    # Create a row of button at the bottom of the dialog.
    frame .dlg.bbox
    pack  .dlg.bbox -side right -fill x -anchor e

    button .dlg.bbox.btn1 -width $WM5005 -text $M5004 -font $CST_BTN_FONT \
                          -command {set RES "forwards"}
    button .dlg.bbox.btn2 -width $WM5005 -text $M5005 -font $CST_BTN_FONT \
                          -command {set RES "backwards"}
    button .dlg.bbox.btn3 -width $WM5005 -text $M5006 -font $CST_BTN_FONT \
                          -command {set RES "cancel"}
    bind .dlg.bbox.btn1 <Return> {
        set RES "forwards"
    }
    bind .dlg.bbox.btn2 <Return> {
        set RES "backwards"
    }
    bind .dlg.bbox.btn3 <Return> {
        set RES "cancel"
    }

    pack .dlg.bbox.btn1 -side left -expand 1 -padx 3m -pady 1m
    pack .dlg.bbox.btn2 -side left -expand 1 -padx 3m -pady 1m
    pack .dlg.bbox.btn3 -side left -expand 1 -padx 3m -pady 1m

    # Grub the focus.
    ::tk::SetFocusGrab .dlg .dlg.f1.ent.e

    # Wait for input.
    vwait RES
    if {$RES != "cancel"} {
        set TEMP_FIND_WORD [.dlg.f1.ent cget -text]
    }

    # Release the focus.
    ::tk::RestoreFocusGrab .dlg .dlg.f1.ent.e destroy

    return $RES
}

#------------------------------------------------------------------------------
# @editmenu_replace_input_dialog
#------------------------------------------------------------------------------
proc editmenu_replace_input_dialog {} {
    global RES
    global TEMP_FIND_WORD TEMP_FIND_NOCASE
    global TEMP_FIND_SELECTION TEMP_REPLACED_WORD TEMP_REPLACE_CONFIRM
    global CST_BTN_FONT
    global M3007 M5001 M5003 M5004 M5005 WM5005 M5006 M5014 M5015 M5016 M5017

    # Create the toplevel dialog
    toplevel .dlg
    wm title .dlg $M3007
    wm protocol .dlg WM_DELETE_WINDOW editmenu_delete_dialog
    wm resizable .dlg 0 0

    frame .dlg.f1
    pack .dlg.f1 -side top -fill x -anchor w
        LabelEntry .dlg.f1.ent -label $M5001
        pack .dlg.f1.ent -fill x -padx 4 -pady 4 -anchor w

        #Start find when return key is pressed.
        bind .dlg.f1.ent.e <Return> {
            set RES "forwards"
        }
        bind .dlg.f1.ent.e <Escape> {
            set RES "cancel"
        }

    frame .dlg.f2
    pack .dlg.f2 -side top -fill x -anchor w
        LabelEntry .dlg.f2.ent -label $M5015 -textvariable TEMP_REPLACED_WORD
        .dlg.f2.ent.e icursor end
        pack .dlg.f2.ent -fill x -padx 4 -pady 4 -anchor w

        #Start find when return key is pressed.
        bind .dlg.f2.ent.e <Return> {
            set RES "forwards"
        }
        bind .dlg.f2.ent.e <Escape> {
            set RES "cancel"
        }

    frame .dlg.f3
    pack .dlg.f3 -side top -fill x  -anchor w
        checkbutton .dlg.f3.cb1 -text $M5003 -variable TEMP_FIND_NOCASE
        if {$TEMP_FIND_NOCASE == 1} {
            .dlg.f3.cb1 select
        } else {
            .dlg.f3.cb1 deselect
        }
        pack .dlg.f3.cb1 -fill x -side left

    frame .dlg.f4
    pack .dlg.f4 -side top -fill x  -anchor w
        checkbutton .dlg.f4.cb1 -text $M5014 -variable TEMP_FIND_SELECTION

        if {[llength [.base.textarea tag ranges sel]] > 0} {
            .dlg.f4.cb1 select
        } else {
            .dlg.f4.cb1 deselect
        }
        pack .dlg.f4.cb1 -fill x -side left

    frame .dlg.f5
    pack .dlg.f5 -side top -fill x  -anchor w
        checkbutton .dlg.f5.cb1 -text $M5016 -variable TEMP_REPLACE_CONFIRM
        if {$TEMP_REPLACE_CONFIRM == 1} {
            .dlg.f5.cb1 select
        } else {
            .dlg.f5.cb1 deselect
        }
        pack .dlg.f5.cb1 -fill x -side left

    # Create a separator  
    Separator  .dlg.s1 -orient horizontal
    pack .dlg.s1 -fill x -padx 2 -pady 2

    # Create a row of button at the bottom of the dialog.
    frame .dlg.bbox
    pack  .dlg.bbox -side right -fill x -anchor e

    button .dlg.bbox.btn1 -width $WM5005 -text $M5004 -font $CST_BTN_FONT \
                          -command {set RES "forwards"}
    button .dlg.bbox.btn2 -width $WM5005 -text $M5005 -font $CST_BTN_FONT \
                          -command {set RES "backwards"}
    button .dlg.bbox.btn3 -width $WM5005 -text $M5017 -font $CST_BTN_FONT \
                          -command {set RES "replace"}
    button .dlg.bbox.btn4 -width $WM5005 -text $M5006 -font $CST_BTN_FONT \
                          -command {set RES "cancel"}
    bind .dlg.bbox.btn1 <Return> {
        set RES "forwards"
    }
    bind .dlg.bbox.btn2 <Return> {
        set RES "backwards"
    }
    bind .dlg.bbox.btn3 <Return> {
        set RES "replace"
    }
    bind .dlg.bbox.btn4 <Return> {
        set RES "cancel"
    }

    pack .dlg.bbox.btn1 -side left -expand 1 -padx 3m -pady 1m
    pack .dlg.bbox.btn2 -side left -expand 1 -padx 3m -pady 1m
    pack .dlg.bbox.btn3 -side left -expand 1 -padx 3m -pady 1m
    pack .dlg.bbox.btn4 -side left -expand 1 -padx 3m -pady 1m

    # Grub the focus.
    ::tk::SetFocusGrab .dlg .dlg.f1.ent.e

    # Wait for input.
    vwait RES
    set TEMP_FIND_WORD     [.dlg.f1.ent cget -text]
    set TEMP_REPLACED_WORD [.dlg.f2.ent cget -text]

    # Release the focus.
    ::tk::RestoreFocusGrab .dlg .dlg.f1.ent.e destroy

    return $RES
}

#------------------------------------------------------------------------------
# @editmenu_replace_confirm_dialog
#------------------------------------------------------------------------------
proc editmenu_replace_confirm_dialog {} {
    global RES
    global CST_BTN_FONT
    global M3007 M5009 M5017 M5018 M5019 M5020

    # Create the toplevel dialog
    toplevel .dlg
    wm title .dlg $M3007
    wm protocol .dlg WM_DELETE_WINDOW editmenu_delete_dialog
    wm resizable .dlg 0 0

    # Create a row of button at the bottom of the dialog.
    frame .dlg.bbox
    pack  .dlg.bbox -side right -fill x -anchor e

    button .dlg.bbox.btn1 -width 8 -text $M5018 -font $CST_BTN_FONT \
                          -command {set RES "replace"}
    button .dlg.bbox.btn2 -width 8 -text $M5020 -font $CST_BTN_FONT \
                          -command {set RES "replace+"}
    button .dlg.bbox.btn3 -width 8 -text $M5017 -font $CST_BTN_FONT \
                          -command {set RES "all"}
    button .dlg.bbox.btn4 -width 8 -text $M5019 -font $CST_BTN_FONT \
                          -command {set RES "skip"}
    button .dlg.bbox.btn5 -width 8 -text $M5009 -font $CST_BTN_FONT \
                          -command {set RES "cancel"}
    bind .dlg.bbox.btn1 <Return> {
        set RES "replace"
    }
    bind .dlg.bbox.btn2 <Return> {
        set RES "replace+"
    }
    bind .dlg.bbox.btn3 <Return> {
        set RES "all"
    }
    bind .dlg.bbox.btn4 <Return> {
        set RES "skip"
    }
    bind .dlg.bbox.btn5 <Return> {
        set RES "cancel"
    }
    pack .dlg.bbox.btn1 -side left -expand 1 -padx 3m -pady 1m
    pack .dlg.bbox.btn2 -side left -expand 1 -padx 3m -pady 1m
    pack .dlg.bbox.btn3 -side left -expand 1 -padx 3m -pady 1m
    pack .dlg.bbox.btn4 -side left -expand 1 -padx 3m -pady 1m
    pack .dlg.bbox.btn5 -side left -expand 1 -padx 3m -pady 1m

    # Grub the focus.
    ::tk::SetFocusGrab .dlg .dlg.bbox.btn1

    # Wait for input.
    vwait RES

    # Release the focus.
    ::tk::RestoreFocusGrab .dlg .dlg.bbox.btn1 destroy

    return $RES
}

#------------------------------------------------------------------------------
# @editmenu_goto_line_dialog
#------------------------------------------------------------------------------
proc editmenu_goto_line_dialog {} {
    global RES
    global CST_BTN_FONT
    global TEMP_GOTO_LINE
    global M3008 M5007 M5008 M5009

    # Create the toplevel dialog
    toplevel .dlg
    wm title .dlg $M3008
    wm protocol .dlg WM_DELETE_WINDOW editmenu_delete_dialog
    wm resizable .dlg 0 0

    frame .dlg.f1
    pack .dlg.f1 -side top -fill x -anchor w
        LabelEntry .dlg.f1.ent -label $M5007 -textvariable $TEMP_GOTO_LINE
        pack .dlg.f1.ent -fill x -padx 4 -pady 4 -anchor w

        #Start find when return key is pressed.
        bind .dlg.f1.ent.e <Return> {
            set RES "ok"
        }
        bind .dlg.f1.ent.e <Escape> {
            set RES "cancel"
        }

    # Create a row of button at the bottom of the dialog.
    frame .dlg.bbox
    pack  .dlg.bbox -side right -fill x -anchor e

    button .dlg.bbox.btn1 -width 8 -text $M5008 -font $CST_BTN_FONT \
                          -command {set RES "ok"}
    button .dlg.bbox.btn2 -width 8 -text $M5009 -font $CST_BTN_FONT \
                          -command {set RES "cancel"}
    bind .dlg.bbox.btn1 <Return> {
        set RES "ok"
    }
    bind .dlg.bbox.btn2 <Return> {
        set RES "cancel"
    }

    pack .dlg.bbox.btn1 -side left -expand 1 -padx 3m -pady 1m
    pack .dlg.bbox.btn2 -side left -expand 1 -padx 3m -pady 1m

    # Grub the focus.
    ::tk::SetFocusGrab .dlg .dlg.f1.ent.e

    # Wait for input.
    vwait RES
    set TEMP_GOTO_LINE [.dlg.f1.ent cget -text]

    # Release the focus.
    ::tk::RestoreFocusGrab .dlg .dlg.f1.ent.e destroy

    return $RES
}

#------------------------------------------------------------------------------
# @editmenu_search_common
#------------------------------------------------------------------------------
proc editmenu_search_common {back} {
    global M3001 M3005 M4009 M4010
    global TEMP_FIND_WORD TEMP_FIND_NOCASE
    global TEMP_FIND_SELECTION

    if {$TEMP_FIND_WORD == ""} {
        return ""
    }

    if {$back == 1} {
        set direction "-backwards"
        if {$TEMP_FIND_SELECTION == 1} {
            if {[llength [.base.textarea tag ranges sel]] > 0} {
                set si [lindex [.base.textarea tag ranges sel] 1]
                set ei [lindex [.base.textarea tag ranges sel] 0]
            } else {
                set si "insert -1 chars"
                set ei "1.0"
            }
        } else {
            set si "insert -1 chars"
            set ei "1.0"
        }
    } else {
        set direction "-forwards"
        if {$TEMP_FIND_SELECTION == 1} {
            if {[llength [.base.textarea tag ranges sel]] > 0} {
                set si [lindex [.base.textarea tag ranges sel] 0]
                set ei [lindex [.base.textarea tag ranges sel] 1]
            } else {
                set si "insert"
                set ei "end"
            }
        } else {
            set si "insert"
            set ei "end"
        }
    }
    
    if {$TEMP_FIND_NOCASE == 1} {
        set idx [.base.textarea search $direction -exact \
                                       -- $TEMP_FIND_WORD $si $ei]
    } else {
        set idx [.base.textarea search $direction -nocase -exact \
                                       -- $TEMP_FIND_WORD $si $ei]
    }

    return $idx
}

#------------------------------------------------------------------------------
# @editmenu_search_forwards
#------------------------------------------------------------------------------
proc editmenu_search_forwards {} {
    global TEMP_FIND_WORD
    global M3005 M4009

    after 10 {
        set idx [editmenu_search_common 0]
        if {$idx != ""} {
            .base.textarea tag remove sel 1.0 end
            .base.textarea mark set insert "$idx +1 chars"
            .base.textarea see $idx
            .base.textarea tag add sel $idx \
                           "$idx +[string length $TEMP_FIND_WORD] chars"
            update idletasks
        } else {
            tk_messageBox -type ok -title $M3005 -icon info  -message $M4009
        }
    }
}

#------------------------------------------------------------------------------
# @editmenu_search_backwards
#------------------------------------------------------------------------------
proc editmenu_search_backwards {} {
    global TEMP_FIND_WORD
    global M3005 M4009

    after 10 {
        set idx [editmenu_search_common 1]
        if {$idx != ""} {
            .base.textarea tag remove sel 1.0 end
            .base.textarea mark set insert $idx
            .base.textarea see $idx
            .base.textarea tag add sel $idx \
                           "$idx +[string length $TEMP_FIND_WORD] chars"
            update idletasks
        } else {
            tk_messageBox -type ok -title $M3005 -icon info  -message $M4009
        }
    }
}

#------------------------------------------------------------------------------
# @editmenu_replace_common
#------------------------------------------------------------------------------
proc editmenu_replace_common {direction is_all} {
    global RES
    global USR_CNF_HIGHLIGHT
    global TEMP_FIND_WORD TEMP_REPLACED_WORD TEMP_REPLACE_COUNT
    global TEMP_REPLACE_CONFIRM
    global M3005 M3010 M4009 M4011

    set TEMP_REPLACE_COUNT 0

    if {[llength [.base.textarea tag ranges sel]] > 0} {
        set si [lindex [.base.textarea tag ranges sel] 0]
        set ei [lindex [.base.textarea tag ranges sel] 1]
    } else {
        set si ""
        set ei ""
    }
    set replace_ok 1
    set idx [editmenu_search_common $direction]
    while {$idx != ""} {
        if {$direction == 1} {
            .base.textarea mark set insert $idx
        } else {
            .base.textarea mark set insert "$idx +1 chars"
            if {$si != ""} {
                .base.textarea tag remove sel $si insert
            }
        }
        .base.textarea see $idx
        if {$TEMP_REPLACE_CONFIRM == 1} {
            .base.textarea tag remove tag1 1.0 end
            .base.textarea tag add tag1 $idx \
                           "$idx +[string length $TEMP_FIND_WORD] chars"
            .base.textarea tag configure tag1 -background $USR_CNF_HIGHLIGHT
            editmenu_replace_confirm_dialog
            switch $RES {
                "replace" {
                    set is_all 0
                    set replace_ok 1
                }
                "replace+" {
                    set is_all 1
                    set replace_ok 1
                }
                "all"     {
                    set TEMP_REPLACE_CONFIRM 0
                    set is_all 1
                    set replace_ok 1
                }
                "skip"    {
                    set is_all 1
                    set replace_ok 0
                }
                "cancel" {
                    set replace_ok 0
                    set idx ""
                    break
                }
            }
        }
        if {$replace_ok == 1} {
            .base.textarea delete $idx \
                                  "$idx +[string length $TEMP_FIND_WORD] chars"
            .base.textarea insert $idx $TEMP_REPLACED_WORD
            if {$direction == 1} {
                .base.textarea mark set insert $idx
            } else {
                .base.textarea mark set insert "$idx +1 chars"
                if {$si != ""} {
                    .base.textarea tag remove sel $si insert
                }
            }
            incr TEMP_REPLACE_COUNT
        }
        if {$is_all == 1} {
            set idx [editmenu_search_common $direction]
        } else {
            set idx ""
        }
    }

    if {$TEMP_REPLACE_COUNT > 0} {
        if {$is_all == 1} {
            tk_messageBox -type ok -title $M3010 \
                          -message "$TEMP_REPLACE_COUNT $M4011"
            set_text_modified "A"
        } 
    } else {
        if {$RES != "cancel"} {
            tk_messageBox -type ok -title $M3005 -icon info -message $M4009
        }
    }

    .base.textarea tag remove tag1 1.0 end
    if {$si != ""} {
        .base.textarea tag remove sel 1.0 end
        .base.textarea tag add sel $si $ei
    }

    return
}

#------------------------------------------------------------------------------
# @editmenu_replace_forwards
#------------------------------------------------------------------------------
proc editmenu_replace_forwards {} {
    editmenu_replace_common 0 0
}
#------------------------------------------------------------------------------
# @editmenu_replace_backwards
#------------------------------------------------------------------------------
proc editmenu_replace_backwards {} {
    editmenu_replace_common 1 0
}

#------------------------------------------------------------------------------
# @editmenu_replace_all
#------------------------------------------------------------------------------
proc editmenu_replace_all {} {
    .base.textarea mark set insert 1.0
    editmenu_replace_common 0 1
}

### Callback functions of "Edit" menu. ########################################
#
#------------------------------------------------------------------------------
# @cb_editmenu_undo
#------------------------------------------------------------------------------
proc cb_editmenu_undo {} {
    if [catch {.base.textarea edit undo}] {
        #nothing
    }
}

#------------------------------------------------------------------------------
# @cb_editmenu_cut
#------------------------------------------------------------------------------
proc cb_editmenu_cut {} {
    event generate .base.textarea <<Cut>>
    set_text_modified "A"
}

#------------------------------------------------------------------------------
# @cb_editmenu_copy
#------------------------------------------------------------------------------
proc cb_editmenu_copy {} {
    event generate .base.textarea <<Copy>>
}

#------------------------------------------------------------------------------
# @cb_editmenu_paste
#------------------------------------------------------------------------------
proc cb_editmenu_paste {} {
    event generate .base.textarea <<Paste>>
    set_text_modified "A"
}

#------------------------------------------------------------------------------
# @cb_editmenu_find
#------------------------------------------------------------------------------
proc cb_editmenu_find {} {
    global RES

    editmenu_find_input_dialog
    
    switch $RES {
        "forwards" {
            editmenu_search_forwards
        }
        "backwards" {
            editmenu_search_backwards
        }
    }
}

#------------------------------------------------------------------------------
# @cb_editmenu_replace
#------------------------------------------------------------------------------
proc cb_editmenu_replace {} {
    global RES

    editmenu_replace_input_dialog

    switch $RES {
        "forwards" {
            editmenu_replace_forwards
        }
        "backwards" {
            editmenu_replace_backwards
        }
        "replace" {
            editmenu_replace_all
        }
    }
}

#------------------------------------------------------------------------------
# @cb_editmenu_select_all
#------------------------------------------------------------------------------
proc cb_editmenu_select_all {} {
    .base.textarea tag remove sel 1.0 end
    .base.textarea tag add sel 1.0 end
}

#------------------------------------------------------------------------------
# @cb_editmenu_goto_line
#------------------------------------------------------------------------------
proc cb_editmenu_goto_line {} {
    global RES
    global TEMP_GOTO_LINE

    editmenu_goto_line_dialog

    if {$RES == "ok"} {
        if [string is integer $TEMP_GOTO_LINE] {
            .base.textarea mark set insert $TEMP_GOTO_LINE.0
            .base.textarea see insert
            display_cursor_pos
        }
    }
}


