#
# A.T.Edit -- Another Tcl/Tk based text editor
# Copyright (C) 2004 Shinji Moiino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#-- messages_ja.tcl --
#
### Messages ####################################################################
# Every Message ID has 5 digits.
#
# M      x                  999
# ^      ^                  ^
# fixed  Kind of message    Sequence number
#          0 - Menu
#          1 - Toolbar(Help text)
#          2 - Title bar
#          3 - MessageBox's title
#          4 - MessageBox's body
#          5 - Label
#          9 - Others
#
#--- Menu ---------------------------------------------------------------------
set M0100 "\u30d5\u30a1\u30a4\u30eb(F)"
set UM0100 5
set M0110 "\u65b0\u898f(N)"
set UM0110 3
set M0120 "\u958b\u304f(O)"
set UM0120 3
set M0130 "\u4fdd\u5b58(S)"
set UM0130 3
set M0140 "\u540d\u524d\u3092\u3064\u3051\u3066\u4fdd\u5b58(A)"
set UM0140 9
set M0150 "\u5370\u5237(P)"
set UM0150 3
set M0160 "\u7d42\u4e86(Q)"
set UM0160 3
set M0170 "\u30ab\u30fc\u30bd\u30eb\u4f4d\u7f6e\u3078\u306e\u8aad\u307f\u8fbc\u307f(I)"
set UM0170 13
set M0180 "\u9589\u3058\u3066\u958b\u304f"

set M0200 "\u7de8\u96c6(E)"
set UM0200 3
set M0210 "\u3084\u308a\u76f4\u3057(U)"
set UM0210 5
set M0220 "\u5207\u308a\u53d6\u308a(X)"
set UM0220 5
set M0230 "\u30b3\u30d4\u30fc(C)"
set UM0230 4
set M0240 "\u8cbc\u308a\u4ed8\u3051(P)"
set UM0240 5
set M0250 "\u691c\u7d22(F)"
set UM0250 3
set M0260 "\u7f6e\u63db(R)"
set UM0260 3
set M0270 "\u3059\u3079\u3066\u9078\u629e(A)"
set UM0270 6
set M0280 "\u6307\u5b9a\u884c(G)"
set UM0280 4

set M0300 "\u7ffb\u8a33(T)"
set UM0300 3
set M0310 "\u65e5\u82f1\u7ffb\u8a33(E)"
set UM0310 5
set M0320 "\u82f1\u65e5\u7ffb\u8a33(J)"
set UM0320 5
set M0330 "\u8f9e\u66f8\u5f15\u304d(D)"
set UM0330 5

set M0400 "\u8a2d\u5b9a(O)"
set UM0400 3
set M0410 "\u8a2d\u5b9a(O)"
set UM0410 3

set M0500 "\u30d8\u30eb\u30d7(H)"
set UM0500 4
set M0510 "About(A)"
set UM0510 5

#--- Toolbar ------------------------------------------------------------------
set M1001 "\u65b0\u898f"
set M1002 "\u958b\u304f"
set M1003 "\u4e0a\u66f8\u304d\u4fdd\u5b58"
set M1004 "\u5370\u5237"
set M1005 "\u3084\u308a\u76f4\u3057"
set M1006 "\u5207\u308a\u53d6\u308a"
set M1007 "\u30b3\u30d4\u30fc"
set M1008 "\u8cbc\u308a\u4ed8\u3051"
set M1009 "\u691c\u7d22\u30c0\u30a4\u30a2\u30ed\u30b0"
set M1010 "\u4e0b\u65b9\u5411\u306b\u691c\u7d22"
set M1011 "\u4e0a\u65b9\u5411\u306b\u691c\u7d22"
set M1012 "\u30de\u30fc\u30af\u30bb\u30c3\u30c8"
set M1013 "\u30de\u30fc\u30af\u4f4d\u7f6e\u3078\u79fb\u52d5"

#--- Titlebar -----------------------------------------------------------------
set M2001 "(\u66f4\u65b0)"

#--- MessageBox's title -------------------------------------------------------
set M3001 "\u30a8\u30e9\u30fc"
set M3002 "\u8b66\u544a"
set M3003 "\u958b\u304f"
set M3004 "\u4fdd\u5b58"
set M3005 "\u60c5\u5831"
set M3006 "\u691c\u7d22"
set M3007 "\u7f6e\u63db"
set M3008 "\u6307\u5b9a\u884c"
set M3009 "\u8a2d\u5b9a"
set M3010 "\u7d50\u679c"
set M3011 "\u8272\u306e\u9078\u629e"
set M3012 "\u30d5\u30a9\u30f3\u30c8"
set M3013 "\u62e1\u5f35\u5b50"
set M3014 "A.T.Edit\u306b\u3064\u3044\u3066"
set M3015 "\u8f9e\u66f8\u5f15\u304d"
set M3016 "\u9589\u3058\u3066\u958b\u304f"

#--- MessageBox's body --------------------------------------------------------
set M4000 "\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308bTcl/Tk\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u53e4\u3044\u3088\u3046\u3067\u3059\u3002\n\
(\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u30d0\u30fc\u30b8\u30e7\u30f3 ==> $tk_version) \n\n\
<http://www.scriptics.com/> \u304b\u3089\u30d0\u30fc\u30b8\u30e7\u30f3 8.3\u4ee5\u964d\u3092\u5165\u624b\u3057\u3001\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002"
set M4001 "\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u306f\u66f4\u65b0\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f"
set M4002 "\u306f\u66f4\u65b0\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f"
set M4003 "\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002"
set M4004 "\u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u3059\u3002"
set M4005 "\u3092\u8aad\u307f\u8fbc\u3080\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002"
set M4006 "\u306b\u66f8\u304d\u8fbc\u3080\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002"
set M4007 "\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002"
set M4008 "\u66f8\u8fbc\u307f\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002"
set M4009 "\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002"
set M4010 "\u6b63\u898f\u8868\u73fe\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059\u3002"
set M4011 "\u500b\u306e\u7f6e\u63db\u3092\u884c\u3044\u307e\u3057\u305f\u3002"
set M4012 "\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002"
set M4013 "\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u66f8\u8fbc\u307f\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002"
set M4014 "\u7ffb\u8a33\u7528\u306e\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002"
set M4015 "\u5370\u5237\u7528\u306e\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002"
set M4016 "\u4f5c\u696d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3068\u540c\u540d\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u3066\u3044\u308b\u305f\u3081\u3001A.T.Edit\u3092\u8d77\u52d5\u3067\u304d\u307e\u305b\u3093\u3002"
set M4017 "\u4f5c\u696d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002"
set M4018 "\u5370\u5237\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\n"
set M4019 "\u7ffb\u8a33\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\n"
set M4020 "\u7ffb\u8a33\u4e2d\u30fb\u30fb\u30fb"
set M4021 "\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002"

#--- Label --------------------------------------------------------------------
set M5001  "\u691c\u7d22: "
set M5002  "\u6b63\u898f\u8868\u73fe"
set M5003  "\u5927\u6587\u5b57\uff0f\u5c0f\u6587\u5b57\u306e\u533a\u5225"
set M5004  "\u4e0b\u691c\u7d22"
set M5005  "\u4e0a\u691c\u7d22"
set WM5005 8
set M5006  "\u9589\u3058\u308b"
set M5007  "\u884c\u756a\u53f7: "
set M5008  "   OK   "
set M5009  "  \u53d6\u6d88  "
set M5010  "\u6841: "
set M5011  "\u884c: "
set M5012  "\u30d5\u30a9\u30f3\u30c8: "
set M5013  "\u9078\u629e"
set WM5013 6
set M5014  "\u9078\u629e\u3057\u305f\u7bc4\u56f2\u306e\u307f"
set M5015  "\u7f6e\u63db: "
set M5016  "\u7f6e\u63db\u3059\u308b\u524d\u306b\u78ba\u8a8d"
set M5017  "\u5168\u7f6e\u63db"
set M5018  "\u7f6e\u63db"
set M5019  "\u30b9\u30ad\u30c3\u30d7"
set M5020  "\u7f6e\u63db\uff0b\u6b21"
set M5021  "\u6587\u5b57\u8272    :"
set M5022  "\u80cc\u666f\u8272    :"
set M5023  "\u30cf\u30a4\u30e9\u30a4\u30c8:"
set M5024  "\u5916\u89b3"
set M5025  "ABCDE abcde 12345 \u3042\u3044\u3046\u3048\u304a"
set M5026  "\u62e1\u5f35\u5b50"
set M5027  "\u30b3\u30de\u30f3\u30c9"
set M5028  "\u8ffd\u52a0"
set M5029  "\u7de8\u96c6"
set M5030  "\u524a\u9664"
set M5031  "\u4e0a\u3078"
set M5032  "\u4e0b\u3078"
set WM5028 4
set M5033  " \u5370\u5237 "
set M5034  " \u7ffb\u8a33 "
set M5035  "\u65e5\u82f1\u7ffb\u8a33: "
set M5036  "\u82f1\u65e5\u7ffb\u8a33: "
set M5037  "\u8f9e\u66f8\u5f15\u304d: "
set WM5035 9
set M5038  "\u540d\u524d"
set WM5038 8
set M5039  "\u30d1\u30bf\u30fc\u30f3"
set M5040  "\u4f8b) *.*, *.txt"
set M5041  "\u30bf\u30d6: "
set M5042  "\u8a00\u8a9e: "
set WM5042 6
set M5043  "\u8f9e\u66f8"
set WM5043 6
set M5044  "\u30de\u30fc\u30af\u4f4d\u7f6e\u3078\u79fb\u52d5"
set M5055  "\u79fb\u52d5"
set M5056  "\u65e5\u82f1\u7ffb\u8a33"
set M5057  "\u82f1\u65e5\u7ffb\u8a33"
set M5058  "\u8f9e\u66f8\u3092\u5f15\u304f"
set M5059  "\u30ab\u30fc\u30bd\u30eb\u884c:"

#--- Others -------------------------------------------------------------------
set M9001 "\u7121\u984c"
set M9002 "A.T.Edit - "
set M9003 "A.T.Edit version 1.00"
set M9004 "(C) 2004 Shinji Morino"
set M9005 "<http://sourceforge.net/projects/atedit/>"
set M9006 "<peace24@blue.email.ne.jp>"

