#
# A.T.Edit -- Another Tcl/Tk based text editor
# Copyright (C) 2004 Shinji Moiino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#-- option_menu.tcl --
#
### Callback functions of "Option" menu.#######################################
#
#------------------------------------------------------------------------------
# @option_menu_set_tfont
#------------------------------------------------------------------------------
proc option_menu_set_tfont {en} {
    global OPT_T_FONT
    global M3012 M5025

    set font [SelectFont .dlg.sf -title $M3012 -font $OPT_T_FONT \
                                 -sampletext $M5025 -type dialog   ]
    if {$font != ""} {
        set OPT_T_FONT $font
    }
    $en configure -state normal -bg white
    $en delete 0 end
    $en insert 0 $OPT_T_FONT
    $en configure -state disabled -bg gray
}

#------------------------------------------------------------------------------
# @option_menu_delete_dialog
#------------------------------------------------------------------------------
proc option_menu_delete_dialog {} {
    global RES

    set RES "cancel"
}

#------------------------------------------------------------------------------
# @option_menu_color_dialog
#------------------------------------------------------------------------------
proc option_menu_color_dialog {initial} {
    global M3011

    return [SelectColor .sc -title $M3011 -color $initial -type dialog]

#   tk_chooseColor forces main window to raise when it is destroyed.
#   This causes that option dialog is hidden beyond the main window.
#    return [tk_chooseColor -title $M3011 -initialcolor $initial]
}

#------------------------------------------------------------------------------
# @option_menu_ext_add_dialog
#------------------------------------------------------------------------------
proc option_menu_ext_add_dialog {idx} {
    global RES1
    global OPT_EXT
    global TEMP_EXT_NAME TEMP_EXT_PAT

    global M3013 M5008 M5009 M5038 M5039 WM5038 M5040

    # Create the toplevel dialog
    toplevel .dlg.d
    wm transient .dlg.d
    wm title .dlg.d $M3013
    wm protocol .dlg.d WM_DELETE_WINDOW option_menu_delete_dialog
    wm resizable .dlg.d 0 0

    # Create Colmuns and Rows entry
    frame .dlg.d.f
    pack .dlg.d.f -fill x -expand 1 -padx 2 -pady 1 -anchor w
      frame .dlg.d.f.f1
      pack .dlg.d.f.f1 -fill x -expand 1 -padx 2 -pady 1 -anchor w
        label .dlg.d.f.f1.l1 -text $M5038 -width $WM5038
        entry .dlg.d.f.f1.e1 -width 30
        if {$idx > -1} {
            .dlg.d.f.f1.e1 insert 0 [lindex [lindex $OPT_EXT $idx] 0]
        }
        pack .dlg.d.f.f1.l1 -expand 0 -padx 1 -pady 1 -side left
        pack .dlg.d.f.f1.e1 -fill x -expand 1 -side left
      frame .dlg.d.f.f2
      pack .dlg.d.f.f2 -fill x -expand 1 -padx 2 -pady 1 -anchor w
        label .dlg.d.f.f2.l1 -text $M5039 -width $WM5038
        entry .dlg.d.f.f2.e1 -width 30
        if {$idx > -1} {
            .dlg.d.f.f2.e1 insert 0 [lindex [lindex $OPT_EXT $idx] 1]
        }
        pack .dlg.d.f.f2.l1 -expand 0 -padx 1 -pady 1 -side left
        pack .dlg.d.f.f2.e1 -fill x -expand 1 -side left
      frame .dlg.d.f.f3
      pack .dlg.d.f.f3 -fill x -expand 1 -padx 2 -pady 1 -anchor w
        label .dlg.d.f.f3.l1 -text "" -width $WM5038
        label .dlg.d.f.f3.l2 -text $M5040
        pack .dlg.d.f.f3.l1 -expand 0 -padx 1 -pady 1 -side left
        pack .dlg.d.f.f3.l2 -expand 1 -padx 1 -pady 1 -side left -anchor w

    # Create a separator
    Separator  .dlg.d.s1 -orient horizontal
    pack .dlg.d.s1 -fill x -padx 2 -pady 4

    # Create a row of button at the bottom of the dialog.
    frame .dlg.d.bbox
    pack  .dlg.d.bbox -side bottom -fill both

    button .dlg.d.bbox.okbtn -width 8 -text $M5008 -command {set RES1 "ok"}
    button .dlg.d.bbox.cnbtn -width 8 -text $M5009 -command {set RES1 "cancel"}
    bind .dlg.d.bbox.okbtn <Return> {
        set RES1 "ok"
    }
    bind .dlg.d.bbox.cnbtn <Return> {
        set RES1 "cancel"
    }
    pack .dlg.d.bbox.okbtn -side left -expand 1 -padx 3m -pady 1m
    pack .dlg.d.bbox.cnbtn -side left -expand 1 -padx 3m -pady 1m

    ::tk::SetFocusGrab .dlg.d .dlg.d.bbox.cnbtn

    vwait RES1

    # Set {TEMP variables} {User configuration}
    if {$RES1 == "ok"} {
        set name [.dlg.d.f.f1.e1 get]
        set pat  [.dlg.d.f.f2.e1 get]
        regsub -all -- { } $name {} chk1
        regsub -all -- { } $pat  {} chk2
        if {$chk1 != "" && $chk2 != ""} {
            regsub -all -- {["{}]} $name {} TEMP_EXT_NAME
            regsub -all -- {["{}]} $pat  {} TEMP_EXT_PAT
        } else {
            set TEMP_EXT_NAME ""
            set TEMP_EXT_PAT  ""
        }
    }

    ::tk::RestoreFocusGrab .dlg.d .dlg.d.bbox.cnbtn destroy

    raise .dlg

    return
}

#------------------------------------------------------------------------------
# @option_menu_ext_add
#------------------------------------------------------------------------------
proc option_menu_ext_add {} {
    global RES1
    global OPT_EXT
    global TEMP_EXT_NAME TEMP_EXT_PAT

    option_menu_ext_add_dialog -1

    # Set {TEMP variables} {User configuration}
    if {$RES1 == "ok"} {
        if {$TEMP_EXT_NAME != "" && $TEMP_EXT_PAT != ""} {
            append new_ext {"}
            append new_ext $TEMP_EXT_NAME
            append new_ext {" }
            append new_ext "{"
            append new_ext "$TEMP_EXT_PAT"
            append new_ext "}"
            lappend OPT_EXT $new_ext
        }
    }

    return
}

#------------------------------------------------------------------------------
# @option_menu_ext_edit
#------------------------------------------------------------------------------
proc option_menu_ext_edit {} {
    global RES1
    global OPT_EXT
    global TEMP_EXT_NAME TEMP_EXT_PAT

    set tf [.dlg.n getframe tab2]
    set idx  [$tf.frame1.lb curselection]
    option_menu_ext_add_dialog $idx

    # Set {TEMP variables} {User configuration}
    if {$RES1 == "ok"} {
        if {$TEMP_EXT_NAME != "" && $TEMP_EXT_PAT != ""} {
            append new_ext {"}
            append new_ext $TEMP_EXT_NAME
            append new_ext {" }
            append new_ext "{"
            append new_ext "$TEMP_EXT_PAT"
            append new_ext "}"
            set OPT_EXT [lreplace $OPT_EXT $idx $idx $new_ext]
        }
    }

    return
}

#------------------------------------------------------------------------------
# @option_menu_ext_up
#------------------------------------------------------------------------------
proc option_menu_ext_up {} {
    global OPT_EXT

    set tf [.dlg.n getframe tab2]
    set idx1 [$tf.frame1.lb curselection]

    if {$idx1 == ""} {
        return
    }
    if {$idx1 < 1} {
        return
    }
    set idx2 [expr $idx1 - 1]

    set item1 [$tf.frame1.lb get $idx1]
    set item2 [$tf.frame1.lb get $idx2]

    set OPT_EXT [lreplace $OPT_EXT $idx2 $idx1 $item1 $item2]

    $tf.frame1.lb selection clear 0 end
    $tf.frame1.lb selection set $idx2
}

#------------------------------------------------------------------------------
# @option_menu_ext_down
#------------------------------------------------------------------------------
proc option_menu_ext_down {} {
    global OPT_EXT

    set tf [.dlg.n getframe tab2]
    set idx1 [$tf.frame1.lb curselection]

    if {$idx1 == ""} {
        return
    }
    set item1 [$tf.frame1.lb get $idx1]

    set idx2 [expr $idx1 + 1]
    set item2 [$tf.frame1.lb get $idx2]
    if {$item2 == ""} {
        return
    }

    set OPT_EXT [lreplace $OPT_EXT $idx1 $idx2 $item2 $item1]

    $tf.frame1.lb selection clear 0 end
    $tf.frame1.lb selection set $idx2
}

#------------------------------------------------------------------------------
# @option_menu_ext_delete
#------------------------------------------------------------------------------
proc option_menu_ext_delete {} {
    global OPT_EXT

    set tf [.dlg.n getframe tab2]
    set idx [$tf.frame1.lb curselection]
    if {$idx == ""} {
        return
    }

    set OPT_EXT [lreplace $OPT_EXT $idx $idx]
}

#------------------------------------------------------------------------------
# @option_menu_make_tab1
#------------------------------------------------------------------------------
proc option_menu_make_tab1 {} {
    global LANGLIST
    global CST_BTN_FONT CST_BTN_FONT2
    global OPT_T_WIDTH OPT_T_HEIGHT OPT_T_TAB
    global OPT_T_FONT
    global OPT_T_FG OPT_T_BG OPT_T_CUR_COLOR OPT_HIGHLIGHT OPT_LANG
    global M3009 M5008 M5009 M5010 M5011 M5012 M5013 WM5013
    global M5021 M5022 M5023 M5041 M5042 WM5042 M5059

    set tframe [.dlg.n getframe tab1]

    frame $tframe.frame1
    pack  $tframe.frame1 -side top -fill both -padx 2 -pady 1
      LabelEntry $tframe.frame1.le1 \
                  -label $M5010 -textvariable OPT_T_WIDTH  -width 3
      LabelEntry $tframe.frame1.le2 \
                  -label $M5011 -textvariable OPT_T_HEIGHT -width 3
      LabelEntry $tframe.frame1.le3 \
                  -label $M5041 -textvariable OPT_T_TAB    -width 2
      pack  $tframe.frame1.le1 -side left -anchor w -padx 4
      pack  $tframe.frame1.le2 -side left -anchor w -padx 4
      pack  $tframe.frame1.le3 -side left -anchor w -padx 4

    # Create Font for textarea entry
    frame $tframe.frame2
    pack  $tframe.frame2 -side top -fill both -padx 2 -pady 1
      label $tframe.frame2.lb1 -text $M5012

      # 'Entry' widget is from BWidget, not Tk build-in 'entry'.
      Entry $tframe.frame2.en -width 25

      $tframe.frame2.en insert 0 $OPT_T_FONT 
      $tframe.frame2.en configure -state disabled
      button $tframe.frame2.bt -text $M5013 -width $WM5013 \
           -command {option_menu_set_tfont [.dlg.n getframe tab1].frame2.en} \
           -font $CST_BTN_FONT
      pack  $tframe.frame2.lb1 -side left -anchor w
      pack  $tframe.frame2.en  -side left -anchor w
      pack  $tframe.frame2.bt  -side left -anchor w -padx 2 -pady 2

    # Create color entry.
    frame $tframe.frame3
    pack  $tframe.frame3 -side top -fill both -padx 2 -pady 1
      label $tframe.frame3.lb1 -text $M5021
      button $tframe.frame3.e1 -width 3 -font $CST_BTN_FONT2 \
                               -bg $OPT_T_FG -fg $OPT_T_FG \
                               -disabledforeground $OPT_T_FG \
                               -relief ridge -state disabled
      bind $tframe.frame3.e1 <Button-1> {
          global OPT_T_FG
          set res [option_menu_color_dialog $OPT_T_FG]
          if {$res != ""} {
              set OPT_T_FG $res
              set f [.dlg.n getframe tab1]
              $f.frame3.e1 configure -bg $OPT_T_FG \
                                     -fg $OPT_T_FG \
                                     -disabledforeground $OPT_T_FG
          }
      }
      label $tframe.frame3.lb2 -text $M5022
      button $tframe.frame3.e2 -width 3 -font $CST_BTN_FONT2 \
                               -bg $OPT_T_BG -fg $OPT_T_BG \
                               -disabledforeground $OPT_T_BG \
                               -relief ridge -state disabled
      bind $tframe.frame3.e2 <Button-1> {
          global OPT_T_BG
          set res [option_menu_color_dialog $OPT_T_BG]
          if {$res != ""} {
              set OPT_T_BG $res
              set f [.dlg.n getframe tab1]
              $f.frame3.e2 configure -bg $OPT_T_BG \
                                     -fg $OPT_T_BG \
                                     -disabledforeground $OPT_T_BG
          }
      }
      pack  $tframe.frame3.lb1 -side left -anchor w
      pack  $tframe.frame3.e1  -side left -anchor w -padx 2 -pady 1
      pack  $tframe.frame3.lb2 -side left -anchor w
      pack  $tframe.frame3.e2  -side left -anchor w -padx 2 -pady 1

    frame $tframe.frame4
    pack  $tframe.frame4 -side top -fill both -padx 2 -pady 1
      label $tframe.frame4.lb3 -text $M5023
      button $tframe.frame4.e3  -width 3 -font $CST_BTN_FONT2 \
                               -bg $OPT_HIGHLIGHT -fg $OPT_HIGHLIGHT \
                               -disabledforeground $OPT_HIGHLIGHT \
                               -relief ridge -state disabled
      bind $tframe.frame4.e3 <Button-1> {
          global OPT_HIGHLIGHT
          set res [option_menu_color_dialog $OPT_HIGHLIGHT]
          if {$res != ""} {
              set OPT_HIGHLIGHT $res
              set f [.dlg.n getframe tab1]
              $f.frame4.e3 configure -bg $OPT_HIGHLIGHT \
                                     -fg $OPT_HIGHLIGHT \
                                     -disabledforeground $OPT_HIGHLIGHT
          }
      }
      label $tframe.frame4.lb4 -text $M5059
      button $tframe.frame4.e4  -width 3 -font $CST_BTN_FONT2 \
                               -bg $OPT_T_CUR_COLOR -fg $OPT_T_CUR_COLOR \
                               -disabledforeground $OPT_T_CUR_COLOR \
                               -relief ridge -state disabled
      bind $tframe.frame4.e4 <Button-1> {
          global OPT_T_CUR_COLOR
          set res [option_menu_color_dialog $OPT_T_CUR_COLOR]
          if {$res != ""} {
              set OPT_T_CUR_COLOR $res
              set f [.dlg.n getframe tab1]
              $f.frame4.e4 configure -bg $OPT_T_CUR_COLOR \
                                     -fg $OPT_T_CUR_COLOR \
                                     -disabledforeground $OPT_T_CUR_COLOR
          }
      }
      pack  $tframe.frame4.lb3 -side left -anchor w
      pack  $tframe.frame4.e3  -side left -anchor w -padx 2 -pady 1
      pack  $tframe.frame4.lb4 -side left -anchor w
      pack  $tframe.frame4.e4  -side left -anchor w -padx 2 -pady 1

    # Create language entry.
    frame $tframe.frame5
    pack  $tframe.frame5 -side top -fill both -padx 2 -pady 1
       label $tframe.frame5.l1 -text $M5042 -width $WM5042
       pack $tframe.frame5.l1 -side left -anchor w -padx 2 -expand 0
       ComboBox $tframe.frame5.c -values $LANGLIST
       $tframe.frame5.c setvalue first
       switch $OPT_LANG {
           "ja" {
               set j [lsearch $LANGLIST " Japanese"]
           }
           default {
               set j [lsearch $LANGLIST " English"]
           }
       }
       for {set i 0} {$i < $j} {incr i} {
           $tframe.frame5.c setvalue next
       }
       pack $tframe.frame5.c -expand 1 -fill x -pady 2

    # Dummy to justify dialog box.
    frame $tframe.frame6
    pack  $tframe.frame6 -side top -fill both -padx 2 -pady 1
      label $tframe.frame6.lb1 -text ""
      pack  $tframe.frame6.lb1 -side top
      label $tframe.frame6.lb2 -text ""
      pack  $tframe.frame6.lb2 -side top
}

#------------------------------------------------------------------------------
# @option_menu_make_tab2
#------------------------------------------------------------------------------
proc option_menu_make_tab2 {} {
    global CST_BTN_FONT
    global OPT_EXT
    global M5028 M5029 M5030 M5031 M5032 WM5028

    set tframe [.dlg.n getframe tab2]

    frame $tframe.frame1
    pack  $tframe.frame1 -side left -fill both -expand 1 -padx 2 -pady 1
      listbox $tframe.frame1.lb -exportselection 0 -listvar OPT_EXT \
                                -yscrollcommand "$tframe.frame1.y set"
      pack $tframe.frame1.lb -side left -anchor w -fill both -expand 1
      $tframe.frame1.lb selection set 0
      scrollbar $tframe.frame1.y -command "$tframe.frame1.lb yview" \
                                 -orient vertical
      pack $tframe.frame1.y -side right -fill y

    frame $tframe.frame2
    pack  $tframe.frame2 -side left -fill both -expand 0 -padx 2 -pady 1
      button $tframe.frame2.b1 -text $M5028 -font $CST_BTN_FONT \
                               -width $WM5028 -command option_menu_ext_add
      button $tframe.frame2.b2 -text $M5029 -font $CST_BTN_FONT \
                               -width $WM5028 -command option_menu_ext_edit
      button $tframe.frame2.b3 -text $M5030 -font $CST_BTN_FONT \
                               -width $WM5028 -command option_menu_ext_delete
      button $tframe.frame2.b4 -text $M5031 -font $CST_BTN_FONT \
                               -width $WM5028 -command option_menu_ext_up
      button $tframe.frame2.b5 -text $M5032 -font $CST_BTN_FONT \
                               -width $WM5028 -command option_menu_ext_down
      pack  $tframe.frame2.b1 -side top
      pack  $tframe.frame2.b2 -side top
      pack  $tframe.frame2.b3 -side top
      pack  $tframe.frame2.b4 -side top
      pack  $tframe.frame2.b5 -side top
}

#------------------------------------------------------------------------------
# @option_menu_make_tab3
#------------------------------------------------------------------------------
proc option_menu_make_tab3 {} {
    global USE_KING
    global CST_BTN_FONT
    global OPT_LPR OPT_KING_EJ OPT_KING_JE OPT_KING_DICT
    global M5033 M5034 M5035 M5036 M5037 WM5035

    set tframe [.dlg.n getframe tab3]

    TitleFrame $tframe.frame1 -text $M5033
    pack  $tframe.frame1 -side top -fill x -expand 1 -padx 2 -pady 1 -anchor n
      set tf [$tframe.frame1 getframe]
      entry $tf.le1 -width 15
      $tf.le1 insert 0 $OPT_LPR
      pack $tf.le1 -fill x -expand 1 -side top

    if {$USE_KING == 1} {
        TitleFrame $tframe.frame2 -text $M5034
        pack  $tframe.frame2 -side top -fill x -expand 1 -padx 2 -pady 1
          set tf [$tframe.frame2 getframe]
          frame $tf.f1
          pack $tf.f1 -side top -fill x -expand 1 -padx 2 -pady 1
            label $tf.f1.lb1 -text $M5035 -width $WM5035
            entry $tf.f1.e1  -width 15
            $tf.f1.e1 insert 0 $OPT_KING_EJ
          frame $tf.f2
          pack $tf.f2 -side top -fill x -expand 1 -padx 2 -pady 1
            label $tf.f2.lb1 -text $M5036 -width $WM5035
            entry $tf.f2.e1  -width 15
            $tf.f2.e1 insert 0 $OPT_KING_JE
          frame $tf.f3
          pack $tf.f3 -side top -fill x -expand 1 -padx 2 -pady 1
            label $tf.f3.lb1 -text $M5037 -width $WM5035
            entry $tf.f3.e1  -width 15
            $tf.f3.e1 insert 0 $OPT_KING_DICT

          pack $tf.f1.lb1 -fill x -expand 0 -side left
          pack $tf.f1.e1  -fill x -expand 1 -side left
          pack $tf.f2.lb1 -fill x -expand 0 -side left
          pack $tf.f2.e1  -fill x -expand 1 -side left
          pack $tf.f3.lb1 -fill x -expand 0 -side left
          pack $tf.f3.e1  -fill x -expand 1 -side left
    }
}

#------------------------------------------------------------------------------
# @option_menu_configure
#------------------------------------------------------------------------------
proc option_menu_configure {} {
    global tcl_platform
    global RES
    global CST_BTN_FONT
    global LANGLIST
    global USE_KING
    global USR_CNF_T_WIDTH USR_CNF_T_HEIGHT USR_CNF_T_TAB 
    global USR_CNF_T_FONT
    global USR_CNF_T_FG USR_CNF_T_BG USR_CNF_T_CUR_COLOR USR_CNF_HIGHLIGHT \
    global USR_CNF_EXT USR_CNF_LPR USR_CNF_LANG
    global USR_CNF_KING_EJ USR_CNF_KING_JE USR_CNF_KING_DICT
    global OPT_T_WIDTH OPT_T_HEIGHT OPT_T_TAB
    global OPT_T_FONT
    global OPT_T_FG OPT_T_BG OPT_T_CUR_COLOR OPT_HIGHLIGHT OPT_EXT \
    global OPT_LPR OPT_LANG
    global OPT_KING_EJ OPT_KING_JE OPT_KING_DICT
    global M3009 M5008 M5009 M5024 M5026 M5027

    # Initialize TEMP variables.
    set OPT_T_WIDTH           $USR_CNF_T_WIDTH
    set OPT_T_HEIGHT          $USR_CNF_T_HEIGHT
    set OPT_T_TAB             $USR_CNF_T_TAB
    set OPT_T_FONT            $USR_CNF_T_FONT
    set OPT_T_FG              $USR_CNF_T_FG
    set OPT_T_BG              $USR_CNF_T_BG
    set OPT_T_CUR_COLOR       $USR_CNF_T_CUR_COLOR
    set OPT_HIGHLIGHT         $USR_CNF_HIGHLIGHT
    set OPT_EXT               $USR_CNF_EXT
    set OPT_LPR               $USR_CNF_LPR
    set OPT_LANG              $USR_CNF_LANG
    set OPT_KING_EJ           $USR_CNF_KING_EJ
    set OPT_KING_JE           $USR_CNF_KING_JE
    set OPT_KING_DICT         $USR_CNF_KING_DICT

    # Create the toplevel dialog
    toplevel .dlg
    wm transient .dlg
    wm title .dlg $M3009
    wm protocol .dlg WM_DELETE_WINDOW option_menu_delete_dialog
    wm resizable .dlg 0 0

    # Create Colmuns and Rows entry
    pack [NoteBook .dlg.n -side top] -fill both -padx 4 -pady 4
    .dlg.n insert end tab1 -text $M5024 -createcmd option_menu_make_tab1
    .dlg.n insert end tab2 -text $M5026 -createcmd option_menu_make_tab2
    .dlg.n insert end tab3 -text $M5027 -createcmd option_menu_make_tab3
    .dlg.n raise [.dlg.n page 2]
    .dlg.n raise [.dlg.n page 1]
    .dlg.n raise [.dlg.n page 0]

    # Create a separator  
    Separator  .dlg.s1 -orient horizontal
    pack .dlg.s1 -fill x -padx 2 -pady 2    

    # Create a row of button at the bottom of the dialog.
    frame .dlg.bbox
    pack  .dlg.bbox -side bottom -fill both

    button .dlg.bbox.okbtn -width 8 -text $M5008 -command {set RES "ok"}
    button .dlg.bbox.cnbtn -width 8 -text $M5009 -command {set RES "cancel"}
    bind .dlg.bbox.okbtn <Return> {
        set RES "ok"
    }
    bind .dlg.bbox.cnbtn <Return> {
        set RES "cancel"
    }
    pack .dlg.bbox.okbtn -side left -expand 1 -padx 3m -pady 1m
    pack .dlg.bbox.cnbtn -side left -expand 1 -padx 3m -pady 1m

    #
    # -- Tk8.4 later
    #
    #grid .btn1 -in .button_box -row 0 -column 0 -padx 3m -pady 2m -sticky ew
    #grid .btn2 -in .button_box -row 0 -column 1 -padx 3m -pady 2m -sticky ew
    #grid .btn3 -in .button_box -row 0 -column 2 -padx 3m -pady 2m -sticky ew
    #for {set i 0} {$i < 2} {incr i} {
    #  grid columnconfigure .button_box $i -uniform buttons
    #}

    ::tk::SetFocusGrab .dlg .dlg.bbox.cnbtn

    vwait RES

    # Set {TEMP variables} {User configuration}
    if {$RES == "ok"} {
        # Tab1
        set tframe [.dlg.n getframe tab1]
        set t1 [$tframe.frame1.le1 cget -text]
        set t2 [$tframe.frame1.le2 cget -text]
        set t3 [$tframe.frame1.le3 cget -text]
        if [string is integer $t1] {
            set OPT_T_WIDTH $t1
        } else {
            set OPT_T_WIDTH 80
        }
        if [string is integer $t2] {
            set OPT_T_HEIGHT $t2
        } else {
            set OPT_T_HEIGHT 25
        }
        if [string is integer $t3] {
            set OPT_T_TAB $t3
        } else {
            set OPT_T_TAB 4
        }
        set t4 [lindex $LANGLIST [$tframe.frame5.c getvalue]]
        switch $t4 {
            " Japanese" { set OPT_LANG "ja"}
            default     { set OPT_LANG "en"}
        }

        # Tab2
        set tframe [.dlg.n getframe tab2]
        set OPT_EXT [$tframe.frame1.lb get 0 end]

        # Tab3
        set tframe [[.dlg.n getframe tab3].frame1 getframe]
        set OPT_LPR [$tframe.le1 get]

        if {$USE_KING == 1} {
            set tframe [[.dlg.n getframe tab3].frame2 getframe]
            set OPT_KING_EJ   [$tframe.f1.e1 get]
            set OPT_KING_JE   [$tframe.f2.e1 get]
            set OPT_KING_DICT [$tframe.f3.e1 get]
        } else {
            set OPT_KING_EJ   $USR_CNF_KING_EJ
            set OPT_KING_JE   $USR_CNF_KING_JE
            set OPT_KING_DICT $USR_CNF_KING_DICT
        }
    }

    ::tk::RestoreFocusGrab .dlg .dlg.bbox.cnbtn destroy

    return $RES
}

#------------------------------------------------------------------------------
# @set_config_option
#------------------------------------------------------------------------------
proc set_config_option {item} {
    global OPT_T_WIDTH OPT_T_HEIGHT OPT_T_TAB OPT_T_FONT
    global OPT_T_FG OPT_T_BG OPT_T_CUR_COLOR OPT_HIGHLIGHT OPT_EXT \
    global OPT_LPR OPT_LANG
    global OPT_KING_EJ OPT_KING_JE OPT_KING_DICT

    set w ""
    switch $item {
        "T_WIDTH" {
            append w $item " " $OPT_T_WIDTH
        }
        "T_HEIGHT" {
            append w $item " " $OPT_T_HEIGHT
        }
        "T_TAB" {
            append w $item " " $OPT_T_TAB
        }
        "T_FONT" {
            append w $item " {" $OPT_T_FONT "}"
        }
        "T_FG" {
            append w $item { "} $OPT_T_FG {"}
        }
        "T_BG" {
            append w $item { "} $OPT_T_BG {"}
        }
        "T_CUR_COLOR" {
            append w $item { "} $OPT_T_CUR_COLOR {"}
        }
        "HIGHLIGHT" {
            append w $item { "} $OPT_HIGHLIGHT {"}
        }
        "EXT" {
            append w $item " {" $OPT_EXT "}"
        }
        "LPR" {
            append w $item " {" $OPT_LPR "}"
        }
        "LANG" {
            append w $item { "} $OPT_LANG {"}
        }
        "KING_EJ" {
            append w $item " {" $OPT_KING_EJ "}"
        }
        "KING_JE" {
            append w $item " {" $OPT_KING_JE "}"
        }
        "KING_DICT" {
            append w $item " {" $OPT_KING_DICT "}"
        }
    }

    return $w
}

#------------------------------------------------------------------------------
# @write_config_file
#------------------------------------------------------------------------------
proc write_config_file {} {
    global errorInfo tcl_platform
    global M3001 M4012 M4013
    global CONFDIR CONFFILE

    append conf  $CONFDIR / $CONFFILE
    append confb $conf ".bak"

    if [file exists $conf] {
        if [catch {file copy -force $conf $confb} em] {
            tk_messageBox -type ok -title $M3001 -message "$M4012\n{$em}"
            return -1
        }
    }
    if [catch {open $conf w} fd1] {
        tk_messageBox -type ok -title $M3001 -message "$M4012 \n $errorInfo"
        return -1
    }

    foreach op {T_WIDTH T_HEIGHT T_TAB T_FONT T_FG T_BG T_CUR_COLOR \
                HIGHLIGHT EXT LPR LANG KING_EJ KING_JE KING_DICT} {
        set w [set_config_option $op]
        if [catch {puts $fd1 $w} em] {
            tk_messageBox -type ok -title $M3001 -message "$M4013\n{$em}"
            close $fd1
            return -1
        }
    }

    close $fd1

    return 0
}
#------------------------------------------------------------------------------
# @cb_optionmenu_config
#------------------------------------------------------------------------------
proc cb_optionmenu_config {} {
    global USR_CNF_T_WIDTH USR_CNF_T_HEIGHT USR_CNF_T_TAB
    global USR_CNF_T_FONT
    global USR_CNF_T_FG USR_CNF_T_BG USR_CNF_T_CUR_COLOR USR_CNF_HIGHLIGHT \
    global USR_CNF_EXT USR_CNF_LPR USR_CNF_LANG
    global USR_CNF_KING_EJ USR_CNF_KING_JE USR_CNF_KING_DICT

    global OPT_T_WIDTH OPT_T_HEIGHT OPT_T_TAB
    global OPT_T_FONT
    global OPT_T_FG OPT_T_BG OPT_T_CUR_COLOR OPT_HIGHLIGHT OPT_EXT \
    global OPT_LPR OPT_LANG
    global OPT_KING_EJ OPT_KING_JE OPT_KING_DICT

    set RES [option_menu_configure]

    if {$RES == "ok"} {
        if {[write_config_file] < 0} {
            return
        }

        set USR_CNF_T_WIDTH              $OPT_T_WIDTH
        set USR_CNF_T_HEIGHT             $OPT_T_HEIGHT
        set USR_CNF_T_TAB                $OPT_T_TAB
        set USR_CNF_T_FONT               $OPT_T_FONT
        set USR_CNF_T_FG                 $OPT_T_FG
        set USR_CNF_T_BG                 $OPT_T_BG
        set USR_CNF_T_CUR_COLOR          $OPT_T_CUR_COLOR
        set USR_CNF_HIGHLIGHT            $OPT_HIGHLIGHT
        set USR_CNF_EXT                  $OPT_EXT
        set USR_CNF_LPR                  $OPT_LPR
        set USR_CNF_LANG                 $OPT_LANG
        set USR_CNF_KING_EJ              $OPT_KING_EJ
        set USR_CNF_KING_JE              $OPT_KING_JE
        set USR_CNF_KING_DICT            $OPT_KING_DICT

        .base.textarea configure -width  $USR_CNF_T_WIDTH
        .base.textarea configure -height $USR_CNF_T_HEIGHT
        .base.textarea configure -tabs   [expr $USR_CNF_T_TAB * 8]
        .base.textarea configure -font   $USR_CNF_T_FONT
        .base.textarea configure -fg     $USR_CNF_T_FG
        .base.textarea configure -bg     $USR_CNF_T_BG
        .base.textarea tag configure colorline -foreground $USR_CNF_T_CUR_COLOR
        .base.textarea tag configure sel -background $USR_CNF_HIGHLIGHT
    }
}

