#
# A.T.Edit -- Another Tcl/Tk based text editor
# Copyright (C) 2004 Shinji Moiino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#-- global.tcl --
#
### Event #####################################################################
event add <<Open>>            <Control-o>
event add <<Open>>            <Control-O>
event add <<Save>>            <Control-s>
event add <<Save>>            <Control-S>
event add <<Find>>            <Control-f>
event add <<Find>>            <Control-F>
event add <<Replace>>         <Control-r>
event add <<Replace>>         <Control-R>
event add <<SelectAll>>       <Control-a>
event add <<SelectAll>>       <Control-A>
event add <<GotoLine>>        <Control-g>
event add <<GotoLine>>        <Control-G>
event add <<FindForwards>>    <F3>
event add <<FindBackwards>>   <Shift-F3>
event add <<Cut>>             <Control-x>
event add <<Cut>>             <Control-X>
event add <<Copy>>            <Control-c>
event add <<Copy>>            <Control-C>
event add <<Paste>>           <Control-v>
event add <<Paste>>           <Control-V>

### Global variables. #########################################################
#
#--- Constant -----------------------------------------------------------------
set LANGLIST {" English" " Japanese" " Italiano"}  ;# Keep same as "../setup.tcl"

#--- User Configuration -------------------------------------------------------
#%% Text Area
set USR_CNF_T_WIDTH     80           ;# Text area columns.
set USR_CNF_T_HEIGHT    25           ;# Text area rows.
set USR_CNF_T_TAB        4           ;# Text area tab width.
set USR_CNF_T_FG        black        ;# Text area foreground color.
set USR_CNF_T_BG        white        ;# Text area background color.
set USR_CNF_T_CUR_COLOR brown
set USR_CNF_HIGHLIGHT   "dodger blue"
switch $tcl_platform(platform) {
    windows   { set USR_CNF_T_FONT      "gothic 11 normal" }
    unix      { set USR_CNF_T_FONT      "fixed 13 normal" }
    macintosh { set USR_CNF_T_FONT      "fixed 13 normal" }
    default   { set USR_CNF_T_FONT      "fixed 13 normal" }
}
switch {$tcl_platform(platform)} {
    "windows" {
        set USR_CNF_EXT         {{"All" {*.*}} {"Text" {*.txt}}}
    }
    default {
        set USR_CNF_EXT         {{"All" {*}} {"Text" {*.txt}}}
    }
}
switch $tcl_platform(platform) {
    "windows" {
        set USR_CNF_LPR         "notepad.exe /p %s"
    }
    default {
        set USR_CNF_LPR         "lpr %s"
    }
}
set USR_CNF_LANG        $LANG        ;#LANG is set in instinfo.tcl.

#--- Temp ---------------------------------------------------------------------
set RES  ""
set RES1 ""
set DUMMY_FG 0
set TRANS_FG 0
set MARK ""
set PREV_MARK_NO            0
set TEMP_MARK_LIST          ""
set TEMP_FILENAME           ""
set TEMP_UNTITLED           1
set TEMP_TEXT_MODIFIED      0
set TEMP_FIND_WORD          ""
set TEMP_REPLACED_WORD      ""
set TEMP_FIND_NOCASE        0
set TEMP_FIND_SELECTION     0
set TEMP_REPLACE_CONFIRM    0
set TEMP_REPLACE_COUNT      0
set TEMP_GOTO_LINE          1
set TEMP_EXT_NAME           ""
set TEMP_EXT_PAT            ""
set TEMP_FROM_ANOTHER_EVENT 0
set TEMP_CWD                ""

#%% To get values input in configuration dialog.
set OPT_T_WIDTH             $USR_CNF_T_WIDTH
set OPT_T_HEIGHT            $USR_CNF_T_HEIGHT
set OPT_T_TAB               $USR_CNF_T_TAB
set OPT_T_FONT              $USR_CNF_T_FONT
set OPT_T_FG                $USR_CNF_T_FG
set OPT_T_BG                $USR_CNF_T_BG
set OPT_T_CUR_COLOR         $USR_CNF_T_CUR_COLOR
set OPT_HIGHLIGHT           $USR_CNF_HIGHLIGHT
set OPT_EXT                 $USR_CNF_EXT
set OPT_LPR                 $USR_CNF_LPR
set OPT_LANG                $USR_CNF_LANG
#--- Font ---------------------------------------------------------------------
switch $tcl_platform(platform) {
    windows   { option add *Font {{ms gothic}  10} }
    unix      { option add *Font {{misc fixed} 12} }
    macintosh { option add *Font {{misc fixed} 12} }
    default   { option add *Font {{misc fixed} 12} }
}

#--- Font of button -----------------------------------------------------------
switch $tcl_platform(platform) {
    windows   {
                  set CST_BTN_FONT      "gothic 9 normal" 
                  set CST_BTN_FONT2     "gothic 6 normal" 
              }
    unix      {
                  set CST_BTN_FONT      "fixed 10 normal"
                  set CST_BTN_FONT2     "fixed  8 normal"
              }
    default   {
                  set CST_BTN_FONT      "fixed 10 normal"
                  set CST_BTN_FONT2     "fixed  8 normal"
              }
}

#--- Font of statusnbar -------------------------------------------------------
switch $tcl_platform(platform) {
    windows   { set CST_SBAR_FONT      "gothic 9 normal" }
    unix      { set CST_SBAR_FONT      "fixed 10 normal" }
    macintosh { set CST_SBAR_FONT      "fixed 10 normal" }
    default   { set CST_SBAR_FONT      "fixed 10 normal" }
}

#--- King ---------------------------------------------------------------------
set USE_KING     0
set USR_CNF_KING_EJ   "kingtr -e -f %s"
set USR_CNF_KING_JE   "kingtr -j -f %s"
set USR_CNF_KING_DICT "kinglook %s" ;# Honyaku-jisyo => kingword

#--- TextArea -----------------------------------------------------------------
set T_BD         2
set T_CSR_WIDTH  2
set MAX_MARK     32
