#
# A.T.Edit -- Another Tcl/Tk based text editor
# Copyright (C) 2004 Shinji Moiino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#-- mark.tcl --
#
#------------------------------------------------------------------------------
# @mark_delete_dialog
#------------------------------------------------------------------------------
proc mark_delete_dialog {} {
    global RES
    set RES "cancel"
}

#------------------------------------------------------------------------------
# @cb_mark_delete
#------------------------------------------------------------------------------
proc cb_mark_delete {} {
    global MARK TEMP_MARK_LIST

    set idx [.dlg.f1.l curselection]
    if {$idx != ""} {
        set MARK [lreplace $MARK $idx $idx]
        set TEMP_MARK_LIST [lreplace $TEMP_MARK_LIST $idx $idx]
    }
}

#------------------------------------------------------------------------------
# @cb_mark_set
#------------------------------------------------------------------------------
proc cb_mark_set {} {
    global MAX_MARK PREV_MARK_NO MARK

    incr PREV_MARK_NO
    if {$PREV_MARK_NO > $MAX_MARK} {
        set PREV_MARK_NO 1
    }
    set i $PREV_MARK_NO

    if {[expr [llength $MARK] + 1] > $MAX_MARK} {
        set MARK [lreplace $MARK 0 0]
    }
    .base.textarea mark set MARK_$i insert

    set m {}
    lappend m "MARK_$i "
    lappend m [.base.textarea get "insert linestart" "insert linestart +32 c"]

    lappend MARK $m
}

#------------------------------------------------------------------------------
# @cb_goto_mark
#------------------------------------------------------------------------------
proc cb_goto_mark {} {
    global RES MARK TEMP_MARK_LIST MAX_MARK
    global CST_BTN_FONT
    global M5009 M5030 M5044 M5055

    # Create the toplevel dialog
    toplevel .dlg
    wm title .dlg $M5044
    wm protocol .dlg WM_DELETE_WINDOW mark_delete_dialog
    wm resizable .dlg 0 0

    set TEMP_MARK_LIST {}
    for {set i 0} {$i < [llength $MARK]} {incr i} {
        set ml {}
        lappend ml [.base.textarea index [lindex [lindex $MARK $i] 0]]
        lappend ml [lindex [lindex $MARK $i] 1]
        lappend TEMP_MARK_LIST $ml
    }

    frame .dlg.f1
    pack .dlg.f1 -side left -fill x -expand 1 -anchor w
        ## the variable specified at -listvar must be global.
        listbox .dlg.f1.l -exportselection 0 -listvar TEMP_MARK_LIST \
                          -width 50 -yscrollcommand {.dlg.f1.y set}
        .dlg.f1.l selection set 0
        pack .dlg.f1.l -side left -expand 1 -fill x -pady 2
        scrollbar .dlg.f1.y -command {.dlg.f1.l yview} -orient vertical
        pack .dlg.f1.y -side right -fill y

        #Start find when return key is pressed.
        bind .dlg.f1.l <Double-Button-1> {
            set RES "ok"
        }
        bind .dlg.f1.l <Return> {
            set RES "ok"
        }
        bind .dlg.f1.l <Escape> {
            set RES "cancel"
        }

    # Create a row of button at the bottom of the dialog.
    frame .dlg.f2
    pack .dlg.f2 -side left -fill x -anchor w
    button .dlg.f2.btn1 -width 8 -text $M5055 -font $CST_BTN_FONT \
                          -command {set RES "ok"}
    button .dlg.f2.btn2 -width 8 -text $M5030 -font $CST_BTN_FONT \
                          -command {cb_mark_delete}
    button .dlg.f2.btn3 -width 8 -text $M5009 -font $CST_BTN_FONT \
                          -command {set RES "cancel"}
    bind .dlg.f2.btn1 <Return> {
        set RES "ok"
    }
    bind .dlg.f2.btn2 <Return> {
        cb_mark_delete
    }
    bind .dlg.f2.btn3 <Return> {
        set RES "cancel"
    }
    pack .dlg.f2.btn1 -side top -expand 1 -padx 3m -pady 1m
    pack .dlg.f2.btn2 -side top -expand 1 -padx 3m -pady 1m
    pack .dlg.f2.btn3 -side top -expand 1 -padx 3m -pady 1m

    # Grub the focus.
    ::tk::SetFocusGrab .dlg .dlg.f1.l

    # Wait for input.
    vwait RES
    if {$RES == "ok"} {
        set idx [lindex [.dlg.f1.l get active] 0]
        if {$idx != ""} {
            .base.textarea mark set insert $idx
            .base.textarea see insert
            display_cursor_pos
        }
    }

    # Release the focus.
    ::tk::RestoreFocusGrab .dlg .dlg.f1.l destroy

    return $RES
}

