#
# A.T.Edit -- Another Tcl/Tk based text editor
# Copyright (C) 2004 Shinji Moiino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#-- file_menu.tcl --
#
### Callback functions of "File" menu.#########################################
#
#------------------------------------------------------------------------------
# @cb_filemenu_new
#------------------------------------------------------------------------------
proc cb_filemenu_new {fn} {
    global tcl_platform
    global WISHCMD BINDIR USE_KING
    global USR_CNF_T_WIDTH USR_CNF_T_HEIGHT USR_CNF_T_TAB USR_CNF_LANG

    append str1 $WISHCMD
    append str2 $BINDIR "/startup.tcl"
#    if {$fn != ""} {
#        if {[file_can_read $fn] < 0} {
#            set fn ""
#        }
#    }
    if {$USE_KING == 1} {
        exec $str1 $str2 -width  $USR_CNF_T_WIDTH  \
                         -height $USR_CNF_T_HEIGHT \
                         -tab    $USR_CNF_T_TAB    \
                         -lang   $USR_CNF_LANG     \
                         -king \
                         $fn &
    } else {
        exec $str1 $str2 -width  $USR_CNF_T_WIDTH  \
                         -height $USR_CNF_T_HEIGHT \
                         -tab    $USR_CNF_T_TAB    \
                         -lang   $USR_CNF_LANG     \
                         $fn &
    }
}

#------------------------------------------------------------------------------
# @cb_filemenu_open
#------------------------------------------------------------------------------
proc cb_filemenu_open {} {
    global tk_version tcl_platform
    global CST_OK_CANCEL
    global USR_CNF_EXT
    global TEMP_FILENAME TEMP_UNTITLED TEMP_TEXT_MODIFIED TEMP_CWD
    global M3003 M9002

    set types $USR_CNF_EXT
    set fn [file nativename [tk_getOpenFile -filetypes $types -title $M3003 \
                                            -initialdir $TEMP_CWD]]

    # Open a new window when current file is modified.
    if {$fn != ""} {
        if { [.base.textarea get 1.0 "end -1 chars"] != "" ||           \
             $TEMP_UNTITLED == 0                              } {
            cb_filemenu_new $fn
        } else {
            set fd [open_file $fn 1]
            if {$fd > 0} {
                .base.textarea insert end [read  $fd]
                close $fd
                .base.textarea see 0.0
                .base.textarea mark set insert 0.0
                if {$tk_version > "8.3"} {
                    .base.textarea edit reset
                }
                set TEMP_FILENAME      $fn
                set TEMP_UNTITLED      0
                set TEMP_TEXT_MODIFIED 0
                get_cwd $fn
                wm title . "$M9002 $TEMP_FILENAME" 
            }
        }
    }
}

#------------------------------------------------------------------------------
# @cb_filemenu_close_and_open
#------------------------------------------------------------------------------
proc cb_filemenu_close_and_open {} {
    global tk_version tcl_platform
    global USR_CNF_EXT
    global TEMP_FILENAME TEMP_UNTITLED TEMP_TEXT_MODIFIED TEMP_CWD
    global MAX_MARK PREV_MARK_NO MARK
    global M3002 M4001 M4002 M3016

    # Confirm whether saving current file or not.
    if {$TEMP_TEXT_MODIFIED == 1} {
        if {$TEMP_UNTITLED == 1} {
            set message $M4001
        } else {
            set message "$TEMP_FILENAME $M4002"
        }
        set res \
            [tk_messageBox -type yesnocancel -title $M3002 -icon warning \
                           -message $message]
        if {$res == "cancel"} {
            return
        }
        if {$res == "yes"} {
            if {[cb_filemenu_save] != 0} {
                return;
            }
        }
    }

    # Get new file name.
    set types $USR_CNF_EXT
    set fn [file nativename [tk_getOpenFile -filetypes $types -title $M3016 \
                                            -initialdir $TEMP_CWD]]
    if {$fn != ""} {
        set fd [open_file $fn 0]
        if {$fd > 0} {
            .base.textarea delete 0.0 end
            for {set i 1} {$i < [expr $MAX_MARK - 1]} {incr i} {
                .base.textarea mark unset MARK_$i
            }
            .base.textarea insert end [read  $fd]
            close $fd
            .base.textarea see 0.0
            .base.textarea mark set insert 0.0
            if {$tk_version > "8.3"} {
                .base.textarea edit reset
            }
            set TEMP_FILENAME      $fn
            set TEMP_UNTITLED      0
            set TEMP_TEXT_MODIFIED 0
            get_cwd $fn
            wm title . $TEMP_FILENAME 
            set PREV_MARK_NO 0
            set MARK [lreplace $MARK 0 $MAX_MARK]
        }
    }
}

#------------------------------------------------------------------------------
# @cb_filemenu_open_at_cursor
#------------------------------------------------------------------------------
proc cb_filemenu_open_at_cursor {} {
    global tk_version tcl_platform
    global CST_OK_CANCEL
    global USR_CNF_EXT
    global TEMP_CWD
    global TEMP_FILENAME TEMP_TEXT_MODIFIED
    global M2001 M3003

    set types $USR_CNF_EXT
    set fn [file nativename [tk_getOpenFile -filetypes $types -title $M3003 \
                                            -initialdir $TEMP_CWD]]

    # Open a new window when current file is modified.
    if {$fn != ""} {
        set fd [open_file $fn 1]
        if {$fd > 0} {
            .base.textarea insert insert [read  $fd]
            close $fd
            .base.textarea see insert
            set TEMP_TEXT_MODIFIED 1
            wm title . "$TEMP_FILENAME  $M2001"
            get_cwd $fn
        }
    }
}

#------------------------------------------------------------------------------
# @cb_filemenu_save
#------------------------------------------------------------------------------
proc cb_filemenu_save {} {
    global TEMP_FILENAME
    global TEMP_UNTITLED

    if {$TEMP_UNTITLED == 1} {
        return [cb_filemenu_save_as]
    }
    return [save_file $TEMP_FILENAME]
}

#------------------------------------------------------------------------------
# @cb_filemenu_save_as
#------------------------------------------------------------------------------
proc cb_filemenu_save_as {} {
    global tcl_platform
    global USR_CNF_EXT TEMP_UNTITLED TEMP_FILENAME TEMP_CWD
    global M3004

    set types $USR_CNF_EXT
    if {$TEMP_UNTITLED == 1} {
        set fn [file nativename [tk_getSaveFile -filetypes $types \
                                   -title $M3004 -initialdir $TEMP_CWD]]
    } else {
        set fn [file nativename [tk_getSaveFile -filetypes $types \
                                   -title $M3004 -initialdir $TEMP_CWD \
                                   -initialfile [file tail $TEMP_FILENAME]]]
    }
    if {$fn == ""} {
        return
    }
    set res [save_file $fn] 
    if {$res == 0} {
        set TEMP_UNTITLED 0
    }
    return $res
}

#------------------------------------------------------------------------------
# @cb_filemenu_print
#------------------------------------------------------------------------------
proc cb_filemenu_print {} {
    global tcl_platform errorInfo
    global WISHCMD BINDIR CONFDIR
    global USR_CNF_LPR
    global M3001 M4015 M4018

    for {set i 1} {$i < 999} {incr i} {
        set f0 "PRT"
        set f1 [file join $CONFDIR [append f0 $i]]
        if [file exists $f1] {
            set f0 ""
        } else {
            break
        }
    }
    if {$f1 == ""} {
        tk_messageBox -type ok -title $M3001 -message $M4015
        return
    }

    if {[llength [.base.textarea tag ranges sel]] > 0} {
        set si [lindex [.base.textarea tag ranges sel] 0]
        set ei [lindex [.base.textarea tag ranges sel] 1]
    } else {
        set si "1.0"
        set ei "end"
    }

    if [catch {set fd [open $f1 w]} em] {
        tk_messageBox -type ok -title $M3001 -message "$M4015 \n $em"
        return
    } else {
        set str [.base.textarea get $si $ei]
        if [catch {puts -nonewline $fd $str} em] {
        tk_messageBox -type ok -title $M3001 -message "$M4015 \n $em"
            close $fd
            return
        } 
        close $fd
    }
    regsub -all -- {%s} $USR_CNF_LPR "$f1" com
    switch [llength [split $com " "]] {
        "1" {
            if [catch {
                    exec [lindex $com 0]
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4018 -- $errorInfo"
            }
        }
        "2" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1]
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4018 -- $errorInfo"
            }
        }
        "3" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2]
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4018 -- $errorInfo"
            }
        }
        "4" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                         [lindex $com 3] 
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4018 -- $errorInfo"
            }
        }
        "5" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                         [lindex $com 3] [lindex $com 4] 
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4018 -- $errorInfo"
            }
        }
        "6" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                         [lindex $com 3] [lindex $com 4] [lindex $com 5] 
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4018 -- $errorInfo"
            }
        }
        "7" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                         [lindex $com 3] [lindex $com 4] [lindex $com 5] \
                         [lindex $com 6] 
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4018 -- $errorInfo"
            }
        }
        "8" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                         [lindex $com 3] [lindex $com 4] [lindex $com 5] \
                         [lindex $com 6] [lindex $com 7] 
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4018 -- $errorInfo"
            }
        }
        "9" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                         [lindex $com 3] [lindex $com 4] [lindex $com 5] \
                         [lindex $com 6] [lindex $com 7] [lindex $com 8] 
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4018 -- $errorInfo"
            }
        }
        "10" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                         [lindex $com 3] [lindex $com 4] [lindex $com 5] \
                         [lindex $com 6] [lindex $com 7] [lindex $com 8] \
                         [lindex $com 9]
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4018 -- $errorInfo"
            }
        }
    }
    file delete -force $f1
}

#------------------------------------------------------------------------------
# @cb_filemenu_quit
#------------------------------------------------------------------------------
proc cb_filemenu_quit {} {
    global TEMP_FILENAME
    global TEMP_UNTITLED
    global TEMP_TEXT_MODIFIED
    global M3002 M4001 M4002

    if {$TEMP_TEXT_MODIFIED == 1} {
        if {$TEMP_UNTITLED == 1} {
            set message $M4001
        } else {
            set message "$TEMP_FILENAME $M4002"
        }
        set res \
            [tk_messageBox -type yesnocancel -title $M3002 -icon warning \
                           -message $message]
        if {$res == "cancel"} {
            return
        }
        if {$res == "no"} {
            exit
        }
        if {[cb_filemenu_save] != 0} {
            return;
        }
    }
    exit
}

#------------------------------------------------------------------------------

