#include "cpuintrf.h"
#include "osd_cpu.h"

enum {
	SE3208_PC=1, SE3208_SR, SE3208_ER, SE3208_SP,SE3208_PPC,
	SE3208_R0, SE3208_R1, SE3208_R2, SE3208_R3, SE3208_R4, SE3208_R5, SE3208_R6, SE3208_R7
};

#define SE3208_INT	0

extern int SE3208_ICount;				  /* cycle count */

extern void SE3208_init(void);
extern void SE3208_reset (void *param);		  /* Reset registers to the initial values */
extern void SE3208_exit  (void);			  /* Shut down CPU core */
extern int	SE3208_execute(int cycles);		  /* Execute cycles - returns number of cycles actually run */
extern unsigned SE3208_get_context (void *dst);  /* Get registers, return context size */
extern void SE3208_set_context (void *src);	  /* Set registers */
extern unsigned SE3208_get_reg (int regnum);
extern void SE3208_set_reg (int regnum, unsigned val);
extern void SE3208_set_irq_line(int irqline, int state);
extern void SE3208_set_irq_callback(int (*callback)(int irqline));
extern void SE3208_state_save(void *file);
extern void SE3208_state_load(void *file);
extern const char *SE3208_info(void *context, int regnum);
extern unsigned SE3208_dasm(char *buffer, unsigned pc);

#ifdef MAME_DEBUG
int SE3208Dasm(data32_t PC,char *Buffer);
#endif
