/*****************************************************************************

    Irem M92 system games:

    Gunforce (World)                M92-A   (c) 1991 Irem Corp
    Gunforce (USA)                  M92-A   (c) 1991 Irem America Corp
    Gunforce (Japan)                M92-A   (c) 1991 Irem Corp
    Blademaster (World)                     (c) 1991 Irem Corp
    Lethal Thunder (World)                  (c) 1991 Irem Corp
    Thunder Blaster (Japan)                 (c) 1991 Irem Corp
    Undercover Cops (World)                 (c) 1992 Irem Corp
    Undercover Cops (Japan)                 (c) 1992 Irem Corp
    Mystic Riders (World)                   (c) 1992 Irem Corp
    Gun Hohki (Japan)                       (c) 1992 Irem Corp
    Major Title 2 (World)           M92-F   (c) 1992 Irem Corp
    Major Title 2 (Japan)           M92-F   (c) 1992 Irem Corp
    The Irem Skins Game (USA Set 1) M92-F   (c) 1992 Irem America Corp
    The Irem Skins Game (USA Set 2) M92-F   (c) 1992 Irem America Corp
    Hook (World)                            (c) 1992 Irem Corp
    Hook (Japan)                            (c) 1992 Irem Corp
    Hook (USA)                              (c) 1992 Irem America Corp
    R-Type Leo (World)                      (c) 1992 Irem Corp
    R-Type Leo (Japan)                      (c) 1992 Irem Corp
    In The Hunt (World)             M92-E   (c) 1993 Irem Corp
    In The Hunt (USA)               M92-E   (c) 1993 Irem Corp
    Kaitei Daisensou (Japan)        M92-E   (c) 1993 Irem Corp
    Ninja Baseball Batman (USA)             (c) 1993 Irem America Corp
    Yakyuu Kakutou League-Man (Japan)       (c) 1993 Irem Corp
    Perfect Soldiers (Japan)        M92-G   (c) 1993 Irem Corp
    Dream Soccer 94 (Japan)         M92-G   (c) 1994 Irem Corp
    Gunforce 2 (US)                 M92-G   (c) 1994 Irem Corp
    Geostorm (Japan)                M92-G   (c) 1994 Irem Corp

System notes:
    Each game has an encrypted sound cpu (see irem_cpu.c), the sound cpu and
    the sprite chip are on the game board rather than the main board and
    can differ between games.

    Irem Skins Game has an eeprom and ticket payout(?).
    R-Type Leo & Lethal Thunder have a memory card.

    Many games use raster IRQ's for special video effects, eg,
        * Scrolling water in Undercover Cops
        * Score display in R-Type Leo

    These are slow to emulate, and can be turned on/off by pressing
    F1 - they are on by default.
    Todo:  Raster effects don't work in flipscreen mode.

Glitch list!

    Gunforce:
        Animated water sometimes doesn't appear on level 5 (but it
        always appears if you cheat and jump straight to the level).
        Almost certainly a core bug.

    Irem Skins:
        - Eeprom load/save not yet implemented - when done, MT2EEP should
          be removed from the ROM definition.

    Perfect Soliders:
        Shortly into the fight, the sound CPU enters a tight loop, conitnuously
        writing to the status port and with interrupts disabled. I don't see how
        it is supposed to get out of that loop. Maybe it's not supposed to enter
        it at all?

    LeagueMan:
        Raster effects don't work properly (not even cpu time per line?).

    Dream Soccer 94:
        Slight priority problems when goal scoring animation is played

    Emulation by Bryan McPhail, mish@tendril.co.uk
    Thanks to Chris Hardy and Olli Bergmann too!


Sound programs:

Game                          Year  ID string
----------------------------  ----  ------------
Gunforce                      1991  -
Blade Master                  1991  -
Lethal Thunder                1991  -
Undercover Cops               1992  Rev 3.40 M92
Mystic Riders                 1992  Rev 3.44 M92
Major Title 2                 1992  Rev 3.44 M92
Hook                          1992  Rev 3.45 M92
R-Type Leo                    1992  Rev 3.45 M92
In The Hunt                   1993  Rev 3.45 M92
Ninja Baseball Batman         1993  Rev 3.50 M92
Perfect Soldiers              1993  Rev 3.50 M92
World PK Soccer               1995  Rev 3.51 M92
Fire Barrel                   1993  Rev 3.52 M92
Dream Soccer '94              1994  Rev 3.53 M92
Gunforce 2                    1994  Rev 3.53 M92

Gun Force
1991, Irem Corp.

PCB Layout
----------

Top board (Standard M92 Main Board)

M92-A-B   05C04170B1
|---------------------------|-----|--------------------|
|         MC3403  MC3403    |NANAO|                    |
|   064D                    |GA20 |         DSW3       |
|         MC3403  MC3403    |-----|                    |
|                             YM2151                   |
|   MC3403              YM3014                         |
|                                                      |
|J      CN6                           |-------|        |
|                      D71059C        |NEC    |        |
|A              6264                  |D71036L|        |
|                      62256   18MHz  |V33    |        |
|M                                    |-------|        |
|               6264   62256                           |
|M                           M92A-7J-.41(PAL)          |
|                                     M92A-9J-.51(PAL) |
|A                                                     |
|                               |-----|     |-----|    |
| CN4(4P)                       |NANAO|     |NANAO|    |
|                               |GA21 |     |GA22 |    |
|       M92A-3M-.11(PAL)        |-----|     |-----|    |
|                                                      |
|                       6264      6116                 |
| CN5(3P)                                              |
|       DSW2    DSW1    6264      6116      26.66666MHz|
|------------------------------------------------------|
Notes:
      V33 clock   : 9.000MHz
      GA20 clock  : 3.579545MHz (pin38)
      YM2151 clock: 3.579545MHz
      VSync       : 60Hz

      6116 : 2K x8 SRAM
      6264 : 8K x8 SRAM
      62256: 32K x8 SRAM

      CN4: Connector for 4th player controls
      CN5: Connector for 3rd player controls
      CN6: Connector for 2nd speaker (for stereo output)

      Custom chips:
                   NANAO GA20 (QFP80) - Sound chip
                   NANAO GA21 (QFP136)
                   NANAO GA22 (QFP160)



Bottom board (Game Board, differs per game)

M92-B-B   05C04171B1
|--------------------------------------------------------|
|              ROM_C0.9          ROM_001.29*  ROM_000.38 |
|                        |-----|                         |
|14.31818MHz   ROM_C1.10 |NANAO| ROM_011.30*  ROM_010.39 |
|                        |GA23 |                         |
| |----------| ROM_C2.11 |-----| ROM_021.31*  ROM_020.40 |
| |NANAO     |                                           |
| |08J27261A1| ROM_C3.12         ROM_031.32*  ROM_030.41 |
| |011       |                                           |
| |9108KK700 |                                           |
| |----------|                                           |
|                                                        |
|               GF_B-SH0-.14                             |
|                                                        |
|                                       M92_B-7H-.43(PAL)|
|                                                        |
|               6264                  GF_B-L0-C.25       |
|                                                        |
|                                     GF_B-L1-C.26       |
|               6264        62256                        |
|  M92B-2L-.7(PAL)                    GF_B-H1-C.27       |
|                           62256                        |
|  ROM_DA.8     GF_B-SL0.17           GF_B-H0-C.28       |
|                                                        |
|--------------------------------------------------------|
Notes:
      *: Unpopulated position (shown for reference for other M92 games)

      6264 : 8K x8 SRAM
      62256: 32K x8 SRAM

      Custom chips:
                   NANAO 08J27261A1 (PLCC84, encrypted V30 sound CPU, clocked at 14.31818MHz on pins 78 & 79)
                   NANAO GA23 (QFP180)



*****************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"
#include "m92.h"
#include "machine/irem_cpu.h"
#include "state.h"

static UINT8 irqvector;
static UINT16 sound_status;
static UINT32 bankaddress;

static int m92_irq_vectorbase;
static unsigned char *m92_ram,*m92_snd_ram;

#define M92_IRQ_0 ((m92_irq_vectorbase+0)/4)  /* VBL interrupt*/
#define M92_IRQ_1 ((m92_irq_vectorbase+4)/4)  /* Sprite buffer complete interrupt */
#define M92_IRQ_2 ((m92_irq_vectorbase+8)/4)  /* Raster interrupt */
#define M92_IRQ_3 ((m92_irq_vectorbase+12)/4) /* Sound cpu interrupt */

#define M92_SCANLINES	256

/* From vidhrdw/m92.c */
WRITE_HANDLER( m92_spritecontrol_w );
WRITE_HANDLER( m92_videocontrol_w );
READ_HANDLER( m92_paletteram_r );
WRITE_HANDLER( m92_paletteram_w );
READ_HANDLER( m92_vram_r );
WRITE_HANDLER( m92_vram_w );
WRITE_HANDLER( m92_pf1_control_w );
WRITE_HANDLER( m92_pf2_control_w );
WRITE_HANDLER( m92_pf3_control_w );
WRITE_HANDLER( m92_master_control_w );
VIDEO_START( m92 );
VIDEO_UPDATE( m92 );

extern int m92_raster_irq_position,m92_raster_enable;
extern unsigned char *m92_vram_data,*m92_spritecontrol;

extern int m92_sprite_buffer_busy,m92_game_kludge;

/*****************************************************************************/

static void set_m92_bank(void)
{
	unsigned char *RAM = memory_region(REGION_CPU1);
	cpu_setbank(1,&RAM[bankaddress]);
}

/*****************************************************************************/

static READ_HANDLER( m92_eeprom_r )
{
	unsigned char *RAM = memory_region(REGION_USER1);
//	logerror("%05x: EEPROM RE %04x\n",activecpu_get_pc(),offset);
	return RAM[offset/2];
}

static WRITE_HANDLER( m92_eeprom_w )
{
	unsigned char *RAM = memory_region(REGION_USER1);
//	logerror("%05x: EEPROM WR %04x\n",activecpu_get_pc(),offset);
	RAM[offset/2]=data;
}

static WRITE_HANDLER( m92_coincounter_w )
{
	if (offset==0) {
		coin_counter_w(0,data & 0x01);
		coin_counter_w(1,data & 0x02);
		/* Bit 0x8 is Motor(?!), used in Hook, In The Hunt, UCops */
		/* Bit 0x8 is Memcard related in RTypeLeo */
		/* Bit 0x40 set in Blade Master test mode input check */
	}
}

static WRITE_HANDLER( m92_bankswitch_w )
{
	if (offset==1) return; /* Unused top byte */
	bankaddress = 0x100000 + ((data&0x7)*0x10000);
	set_m92_bank();
}

static READ_HANDLER( m92_port_4_r )
{
	return readinputport(4) | m92_sprite_buffer_busy; /* Bit 7 low indicates busy */
}

/*****************************************************************************/

enum { VECTOR_INIT, YM2151_ASSERT, YM2151_CLEAR, V30_ASSERT, V30_CLEAR };

static void setvector_callback(int param)
{
	switch(param)
	{
		case VECTOR_INIT:	irqvector = 0;		break;
		case YM2151_ASSERT:	irqvector |= 0x2;	break;
		case YM2151_CLEAR:	irqvector &= ~0x2;	break;
		case V30_ASSERT:	irqvector |= 0x1;	break;
		case V30_CLEAR:		irqvector &= ~0x1;	break;
	}

	if (irqvector & 0x2)		/* YM2151 has precedence */
		cpu_irq_line_vector_w(1,0,0x18);
	else if (irqvector & 0x1)	/* V30 */
		cpu_irq_line_vector_w(1,0,0x19);

	if (irqvector == 0)	/* no IRQs pending */
		cpu_set_irq_line(1,0,CLEAR_LINE);
	else	/* IRQ pending */
		cpu_set_irq_line(1,0,ASSERT_LINE);
}

static WRITE_HANDLER( m92_soundlatch_w )
{
	if (offset==0)
	{
		timer_set(TIME_NOW,V30_ASSERT,setvector_callback);
		soundlatch_w(0,data);
//		logerror("soundlatch_w %02x\n",data);
	}
}

static READ_HANDLER( m92_sound_status_r )
{
//logerror("%06x: read sound status\n",activecpu_get_pc());
	if (offset == 0)
		return sound_status&0xff;
	return sound_status>>8;
}

static READ_HANDLER( m92_soundlatch_r )
{
	if (offset == 0)
	{
		int res = soundlatch_r(offset);
//		logerror("soundlatch_r %02x\n",res);
		return res;
	}
	else return 0xff;
}

static WRITE_HANDLER( m92_sound_irq_ack_w )
{
	if (offset == 0)
		timer_set(TIME_NOW,V30_CLEAR,setvector_callback);
}

static WRITE_HANDLER( m92_sound_status_w )
{
	if (offset == 0) {
		sound_status = data | (sound_status&0xff00);
		cpu_set_irq_line_and_vector(0,0,HOLD_LINE,M92_IRQ_3);
	}
	else
		sound_status = (data<<8) | (sound_status&0xff);
}

/*****************************************************************************/

static MEMORY_READ_START( readmem )
	{ 0x00000, 0x9ffff, MRA_ROM },
	{ 0xa0000, 0xbffff, MRA_BANK1 },
	{ 0xc0000, 0xcffff, MRA_BANK2 }, /* Mirror of rom:  Used by In The Hunt as protection */
	{ 0xd0000, 0xdffff, m92_vram_r },
	{ 0xe0000, 0xeffff, MRA_RAM },
	{ 0xf8000, 0xf87ff, MRA_RAM },
	{ 0xf8800, 0xf8fff, m92_paletteram_r },
	{ 0xffff0, 0xfffff, MRA_ROM },
MEMORY_END

static MEMORY_WRITE_START( writemem )
	{ 0x00000, 0xbffff, MWA_ROM },
	{ 0xd0000, 0xdffff, m92_vram_w, &m92_vram_data },
	{ 0xe0000, 0xeffff, MWA_RAM, &m92_ram }, /* System ram */
	{ 0xf8000, 0xf87ff, MWA_RAM, &spriteram, &spriteram_size },
	{ 0xf8800, 0xf8fff, m92_paletteram_w },
	{ 0xf9000, 0xf900f, m92_spritecontrol_w, &m92_spritecontrol },
	{ 0xf9800, 0xf9801, m92_videocontrol_w },
	{ 0xffff0, 0xfffff, MWA_ROM },
MEMORY_END

static MEMORY_READ_START( lethalth_readmem ) /* Same as above but with different VRAM addressing PAL */
	{ 0x00000, 0x7ffff, MRA_ROM },
	{ 0x80000, 0x8ffff, m92_vram_r },
	{ 0xe0000, 0xeffff, MRA_RAM },
	{ 0xf8000, 0xf87ff, MRA_RAM },
	{ 0xf8800, 0xf8fff, paletteram_r },
	{ 0xffff0, 0xfffff, MRA_ROM },
MEMORY_END

static MEMORY_WRITE_START( lethalth_writemem )
	{ 0x00000, 0x7ffff, MWA_ROM },
	{ 0x80000, 0x8ffff, m92_vram_w, &m92_vram_data },
	{ 0xe0000, 0xeffff, MWA_RAM, &m92_ram }, /* System ram */
	{ 0xf8000, 0xf87ff, MWA_RAM, &spriteram, &spriteram_size },
	{ 0xf8800, 0xf8fff, m92_paletteram_w },
	{ 0xf9000, 0xf900f, m92_spritecontrol_w, &m92_spritecontrol },
	{ 0xf9800, 0xf9801, m92_videocontrol_w },
	{ 0xffff0, 0xfffff, MWA_ROM },
MEMORY_END

static PORT_READ_START( readport )
	{ 0x00, 0x00, input_port_0_r }, /* Player 1 */
	{ 0x01, 0x01, input_port_1_r }, /* Player 2 */
	{ 0x02, 0x02, m92_port_4_r },   /* Coins & VBL */
	{ 0x03, 0x03, input_port_7_r }, /* Dip 3 */
	{ 0x04, 0x04, input_port_6_r }, /* Dip 2 */
	{ 0x05, 0x05, input_port_5_r }, /* Dip 1 */
	{ 0x06, 0x06, input_port_2_r }, /* Player 3 */
	{ 0x07, 0x07, input_port_3_r },	/* Player 4 */
	{ 0x08, 0x09, m92_sound_status_r },	/* answer from sound CPU */
PORT_END

static PORT_WRITE_START( writeport )
	{ 0x00, 0x01, m92_soundlatch_w },
	{ 0x02, 0x03, m92_coincounter_w },
	{ 0x20, 0x21, m92_bankswitch_w },
	{ 0x40, 0x43, MWA_NOP }, /* Interrupt controller, only written to at bootup */
	{ 0x80, 0x87, m92_pf1_control_w },
	{ 0x88, 0x8f, m92_pf2_control_w },
	{ 0x90, 0x97, m92_pf3_control_w },
	{ 0x98, 0x9f, m92_master_control_w },
//	{ 0xc0, 0xc1, m92_unknown_w },	// sound related?
PORT_END

/******************************************************************************/

static MEMORY_READ_START( sound_readmem )
	{ 0x00000, 0x1ffff, MRA_ROM },
	{ 0xa0000, 0xa3fff, MRA_RAM },
	{ 0xa8000, 0xa803f, IremGA20_r },
	{ 0xa8042, 0xa8043, YM2151_status_port_0_r },
	{ 0xa8044, 0xa8045, m92_soundlatch_r },
	{ 0xffff0, 0xfffff, MRA_ROM },
MEMORY_END

static MEMORY_WRITE_START( sound_writemem )
	{ 0x00000, 0x1ffff, MWA_ROM },
	{ 0x9ff00, 0x9ffff, MWA_NOP }, /* Irq controller? */
	{ 0xa0000, 0xa3fff, MWA_RAM, &m92_snd_ram },
	{ 0xa8000, 0xa803f, IremGA20_w },
	{ 0xa8040, 0xa8041, YM2151_register_port_0_w },
	{ 0xa8042, 0xa8043, YM2151_data_port_0_w },
	{ 0xa8044, 0xa8045, m92_sound_irq_ack_w },
	{ 0xa8046, 0xa8047, m92_sound_status_w },
	{ 0xffff0, 0xfffff, MWA_ROM },
MEMORY_END

/******************************************************************************/

INPUT_PORTS_START( bmaster )
	IREM_JOYSTICK_1_2(1)
	IREM_JOYSTICK_1_2(2)
	IREM_PORT_UNUSED
	IREM_PORT_UNUSED
	IREM_COINS
	IREM_SYSTEM_DIPSWITCH

	PORT_START	/* Dip switch bank 1 */
	PORT_DIPNAME( 0x03, 0x02, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x00, "1" )
	PORT_DIPSETTING(    0x03, "2" )
	PORT_DIPSETTING(    0x02, "3" )
	PORT_DIPSETTING(    0x01, "4" )
	PORT_DIPNAME( 0x0c, 0x0c, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Very_Easy) )
	PORT_DIPSETTING(    0x08, DEF_STR( Easy ) )
	PORT_DIPSETTING(    0x0c, DEF_STR( Normal ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Hard ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Bonus_Life ) )
	PORT_DIPSETTING(    0x10, "300k only" )
	PORT_DIPSETTING(    0x00, DEF_STR( None ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Allow_Continue ) )
	PORT_DIPSETTING(    0x00, DEF_STR( No ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )


	IREM_PORT_UNUSED	/* Game manual specificly mentions dip switch bank 3 is unused */
INPUT_PORTS_END

INPUT_PORTS_START( gunforce )
	IREM_JOYSTICK_1_2(1)
	IREM_JOYSTICK_1_2(2)
	IREM_PORT_UNUSED
	IREM_PORT_UNUSED
	IREM_COINS
	IREM_SYSTEM_DIPSWITCH

	PORT_START	/* Dip switch bank 1 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x02, "2" )
	PORT_DIPSETTING(    0x03, "3" )
	PORT_DIPSETTING(    0x01, "4" )
	PORT_DIPSETTING(    0x00, "5" )
	PORT_DIPNAME( 0x0c, 0x0c, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Very_Easy) )
	PORT_DIPSETTING(    0x08, DEF_STR( Easy ) )
	PORT_DIPSETTING(    0x0c, DEF_STR( Normal ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Hard ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Bonus_Life ) )
	PORT_DIPSETTING(    0x00, "15000 35000 75000 120000" )
	PORT_DIPSETTING(    0x10, "20000 40000 90000 150000" )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Allow_Continue ) )
	PORT_DIPSETTING(    0x00, DEF_STR( No ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	IREM_PORT_UNUSED	/* Game manual only mentions 2 dips */
INPUT_PORTS_END

INPUT_PORTS_START( lethalth )
	IREM_JOYSTICK_1_2(1)
	IREM_JOYSTICK_1_2(2)
	IREM_PORT_UNUSED
	IREM_PORT_UNUSED
	IREM_COINS
	IREM_SYSTEM_DIPSWITCH

	PORT_START	/* Dip switch bank 1 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x02, "2" )
	PORT_DIPSETTING(    0x03, "3" )
	PORT_DIPSETTING(    0x01, "4" )
	PORT_DIPSETTING(    0x00, "5" )
	PORT_DIPNAME( 0x0c, 0x0c, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Very_Easy) )
	PORT_DIPSETTING(    0x08, DEF_STR( Easy ) )
	PORT_DIPSETTING(    0x0c, DEF_STR( Normal ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Hard ) )
	PORT_DIPNAME( 0x10, 0x10, "Continuous Play" )
	PORT_DIPSETTING(    0x00, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x10, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Allow_Continue ) )
	PORT_DIPSETTING(    0x00, DEF_STR( No ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* Dip switch bank 3 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Bonus_Life ) )
	PORT_DIPSETTING(    0x02, "500K & 1M" )
	PORT_DIPSETTING(    0x03, "700K & 1.5M" )
	PORT_DIPSETTING(    0x00, "700K, 1.5M, 3M & 4.5M" )
	PORT_DIPSETTING(    0x01, "1M & 2M" )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Unused ) ) /* Manual states the rest are "Unused" */
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unused ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unused ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Unused ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Unused ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x80, DEF_STR( Unused ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
INPUT_PORTS_END

INPUT_PORTS_START( hook )
	IREM_JOYSTICK_1_2(1)
	IREM_JOYSTICK_1_2(2)
	IREM_JOYSTICK_3_4(3)
	IREM_JOYSTICK_3_4(4)
	IREM_COINS
	IREM_SYSTEM_DIPSWITCH_4PLAYERS

	PORT_START	/* Dip switch bank 1 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x00, "1" )
	PORT_DIPSETTING(    0x03, "2" )
	PORT_DIPSETTING(    0x02, "3" )
	PORT_DIPSETTING(    0x01, "4" )
	PORT_DIPNAME( 0x0c, 0x0c, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Very_Easy) )
	PORT_DIPSETTING(    0x08, DEF_STR( Easy ) )
	PORT_DIPSETTING(    0x0c, DEF_STR( Normal ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Hard ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, "Any Button to Start" )
	PORT_DIPSETTING(    0x00, DEF_STR( No ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	IREM_PORT_UNUSED	/* Game manual only mentions 2 dips */
INPUT_PORTS_END

INPUT_PORTS_START( majtitl2 )
	IREM_JOYSTICK_1_2(1)
	IREM_JOYSTICK_1_2(2)
	IREM_JOYSTICK_3_4(3)
	IREM_JOYSTICK_3_4(4)
	IREM_COINS
	IREM_SYSTEM_DIPSWITCH_CABINET

	PORT_START	/* Dip switch bank 1 */
	PORT_DIPNAME( 0x01, 0x01, "Given Holes/Stroke Play" )
	PORT_DIPSETTING(    0x00, "1" )
	PORT_DIPSETTING(    0x01, "2" )
	PORT_DIPNAME( 0x02, 0x02, "Given Holes/Match or Skins" )
	PORT_DIPSETTING(    0x00, "1" )
	PORT_DIPSETTING(    0x02, "2" )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Normal ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Hard ) )
	PORT_DIPNAME( 0x08, 0x08, "Joystick Configuration" )    /* Listed as "Joysticks on" */
	PORT_DIPSETTING(    0x08, DEF_STR( Upright ) )          /* "One Side" */
	PORT_DIPSETTING(    0x00, DEF_STR( Cocktail ) )         /* "Both Sides" */
	PORT_DIPNAME( 0x10, 0x10, "Number of Joysticks" )	/* 4 Way joysticks with 2 buttons each player */
	PORT_DIPSETTING(    0x10, "2 Joysticks" )
	PORT_DIPSETTING(    0x00, "4 Joysticks" )
	PORT_DIPNAME( 0x20, 0x00, "Any Button to Start" )
	PORT_DIPSETTING(    0x20, DEF_STR( No ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* Dip switch bank 3 */
	PORT_DIPNAME( 0x01, 0x01, "Ticket Dispenser" )
	PORT_DIPSETTING(    0x01, DEF_STR( Off ) )	/* "Ticket payout function is not working now" will be shown on screen */
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )	/* Stored data is shown on screen with the option to clear data */
	PORT_DIPNAME( 0x02, 0x06, "Points Per Ticket" ) /* Conversion Rate for Ticket */
	PORT_DIPSETTING(    0x06, "1 Point - 1 Ticket" )
	PORT_DIPSETTING(    0x06, "2 Points - 1 Ticket" )
	PORT_DIPSETTING(    0x02, "5 Points - 1 Ticket" )
	PORT_DIPSETTING(    0x00, "10 Points - 1 Ticket" )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unused ) ) /* Game manual states dips 4, 5, 6 & 7 are "Unused" */
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unused ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Unused ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Unused ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x80, "Deltronics Model" ) /* Ticket Despenser Model Type */
	PORT_DIPSETTING(    0x80, "DL 1275" )
	PORT_DIPSETTING(    0x00, "DL 4SS" )
INPUT_PORTS_END

INPUT_PORTS_START( mysticri )
	IREM_JOYSTICK_1_2(1)
	IREM_JOYSTICK_1_2(2)
	IREM_PORT_UNUSED
	IREM_PORT_UNUSED
	IREM_COINS
	IREM_SYSTEM_DIPSWITCH

	PORT_START	/* Dip switch bank 1 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x02, "2" )
	PORT_DIPSETTING(    0x03, "3" )
	PORT_DIPSETTING(    0x01, "4" )
	PORT_DIPSETTING(    0x00, "5" )
	PORT_DIPNAME( 0x0c, 0x0c, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Easy ) )
	PORT_DIPSETTING(    0x0c, DEF_STR( Normal ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Hard ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Hardest ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Bonus_Life ) )
	PORT_DIPSETTING(    0x00, "15000 35000 60000" )
	PORT_DIPSETTING(    0x10, "20000 50000 90000" )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Allow_Continue ) )
	PORT_DIPSETTING(    0x00, DEF_STR( No ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	IREM_PORT_UNUSED	/* Game manual specificly mentions dip switch bank 3 is unused */
INPUT_PORTS_END

INPUT_PORTS_START( uccops )
	IREM_JOYSTICK_1_2(1)
	IREM_JOYSTICK_1_2(2)
	IREM_JOYSTICK_3_4(3)
	IREM_PORT_UNUSED
	IREM_COINS
	IREM_SYSTEM_DIPSWITCH_3PLAYERS

	PORT_START	/* Dip switch bank 1 */
	PORT_DIPNAME( 0x03, 0x02, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x00, "1" )
	PORT_DIPSETTING(    0x03, "2" )
	PORT_DIPSETTING(    0x02, "3" )
	PORT_DIPSETTING(    0x01, "4" )
	PORT_DIPNAME( 0x0c, 0x0c, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Very_Easy) )
	PORT_DIPSETTING(    0x08, DEF_STR( Easy ) )
	PORT_DIPSETTING(    0x0c, DEF_STR( Normal ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Hard ) )
	/* There is ALLWAYS a Bonus Life at 300K */
	/* It does not depends on the value of bit 0x10 */
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unused ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, "Any Button to Start" )
	PORT_DIPSETTING(    0x00, DEF_STR( No ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	IREM_PORT_UNUSED	/* Game manual only mentions 2 dips */
INPUT_PORTS_END

INPUT_PORTS_START( rtypeleo )
	IREM_JOYSTICK_1_2(1)
	IREM_JOYSTICK_1_2(2)
	IREM_PORT_UNUSED
	IREM_PORT_UNUSED
	IREM_COINS
	IREM_SYSTEM_DIPSWITCH

	PORT_START	/* Dip switch bank 1 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x02, "2" )
	PORT_DIPSETTING(    0x03, "3" )
	PORT_DIPSETTING(    0x01, "4" )
	PORT_DIPSETTING(    0x00, "5" )
	PORT_DIPNAME( 0x0c, 0x0c, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Very_Easy) )
	PORT_DIPSETTING(    0x08, DEF_STR( Easy ) )
	PORT_DIPSETTING(    0x0c, DEF_STR( Normal ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Hard ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unused ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Allow_Continue ) )
	PORT_DIPSETTING(    0x00, DEF_STR( No ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	IREM_PORT_UNUSED	/* Game manual only mentions 2 dips */
INPUT_PORTS_END

INPUT_PORTS_START( inthunt )
	IREM_JOYSTICK_1_2(1)
	IREM_JOYSTICK_1_2(2)
	IREM_PORT_UNUSED
	IREM_PORT_UNUSED
	IREM_COINS
	IREM_SYSTEM_DIPSWITCH

	PORT_START	/* Dip switch bank 1 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x02, "2" )
	PORT_DIPSETTING(    0x03, "3" )
	PORT_DIPSETTING(    0x01, "4" )
	PORT_DIPSETTING(    0x00, "5" )
	PORT_DIPNAME( 0x0c, 0x0c, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Very_Easy) )
	PORT_DIPSETTING(    0x08, DEF_STR( Easy ) )
	PORT_DIPSETTING(    0x0c, DEF_STR( Normal ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Hard ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unused ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, "Any Button to Start" )
	PORT_DIPSETTING(    0x20, DEF_STR( No ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	IREM_PORT_UNUSED	/* Game manual only mentions 2 dips */
INPUT_PORTS_END

INPUT_PORTS_START( nbbatman )
	IREM_JOYSTICK_1_2(1)
	IREM_JOYSTICK_1_2(2)
	IREM_JOYSTICK_3_4(3)
	IREM_JOYSTICK_3_4(4)
	IREM_COINS
	IREM_SYSTEM_DIPSWITCH_4PLAYERS

	PORT_START	/* Dip switch bank 1 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x00, "1" )
	PORT_DIPSETTING(    0x03, "2" )
	PORT_DIPSETTING(    0x02, "3" )
	PORT_DIPSETTING(    0x01, "4" )
	PORT_DIPNAME( 0x0c, 0x0c, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Easy ) )
	PORT_DIPSETTING(    0x0c, DEF_STR( Normal ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Hard ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Hardest ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) ) /* One of these is continue */
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x00, "Any Button to Start" )
	PORT_DIPSETTING(    0x20, DEF_STR( No ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* Dip switch bank 3 */
	PORT_DIPNAME( 0x01, 0x01, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x01, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x02, 0x02, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x02, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x80, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
INPUT_PORTS_END

INPUT_PORTS_START( psoldier )
	PORT_START
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_UP    | IPF_8WAY | IPF_PLAYER1 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN  | IPF_8WAY | IPF_PLAYER1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT  | IPF_8WAY | IPF_PLAYER1 )
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY | IPF_PLAYER1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON3 | IPF_PLAYER1 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_PLAYER1 )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER1 )

	PORT_START
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_UP    | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN  | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT  | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON3 | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_PLAYER2 )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER2 )

	IREM_PORT_UNUSED

	PORT_START /* Extra connector for kick buttons */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON4 | IPF_PLAYER1 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_BUTTON5 | IPF_PLAYER1 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_BUTTON6 | IPF_PLAYER1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON4 | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_BUTTON5 | IPF_PLAYER2 )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_BUTTON6 | IPF_PLAYER2 )

	IREM_COINS
	IREM_SYSTEM_DIPSWITCH

	PORT_START	/* Dip switch bank 1 */
	PORT_DIPNAME( 0x01, 0x01, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x01, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x02, 0x02, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x02, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Unknown ) ) /* Probably difficulty */
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x00, "Any Button to Start" )
	PORT_DIPSETTING(    0x20, DEF_STR( No ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* Dip switch bank 3 */
	PORT_DIPNAME( 0x01, 0x01, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x01, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x02, 0x02, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x02, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x80, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
INPUT_PORTS_END

INPUT_PORTS_START( dsccr94j )
	IREM_JOYSTICK_1_2(1)
	IREM_JOYSTICK_1_2(2)
	IREM_JOYSTICK_3_4(3)
	IREM_JOYSTICK_3_4(4)
	IREM_COINS
	IREM_SYSTEM_DIPSWITCH /* Dip Switch 2, dip 2 is listed as "Don't Change" and is "OFF" */

	PORT_START	/* Dip switch bank 1 */
	PORT_DIPNAME( 0x03, 0x03, "Time" )
	PORT_DIPSETTING(    0x00, "1:30" )
	PORT_DIPSETTING(    0x03, "2:00" )
	PORT_DIPSETTING(    0x02, "2:30" )
	PORT_DIPSETTING(    0x01, "3:00" )
	PORT_DIPNAME( 0x0c, 0x0c, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Very_Easy) )
	PORT_DIPSETTING(    0x08, DEF_STR( Easy ) )
	PORT_DIPSETTING(    0x0c, DEF_STR( Normal ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Hard ) )
	PORT_DIPNAME( 0x10, 0x10, "Game Mode" )
	PORT_DIPSETTING(    0x10, "Match Mode" )
	PORT_DIPSETTING(    0x00, "Power Mode" )
/*
   Match Mode: Winner advances to the next game.  Game Over for the loser
   Power Mode: The Players can play the game until their respective powers run
               out, reguardless of whether they win or lose the game.
               Player 2 can join in any time during the game
               Player power (time) can be adjusted by dip switch #3
*/
	PORT_DIPNAME( 0x20, 0x20, "Starting Button" )
	PORT_DIPSETTING(    0x00, "Button 1" )
	PORT_DIPSETTING(    0x20, "Start Button" )
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* Dip switch bank 3 */
	PORT_DIPNAME( 0x03, 0x03, "Player Power" )
	PORT_DIPSETTING(    0x00, "500" )
	PORT_DIPSETTING(    0x03, "1000" )
	PORT_DIPSETTING(    0x01, "1500" )
	PORT_DIPSETTING(    0x02, "2000" )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x80, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
INPUT_PORTS_END

INPUT_PORTS_START( gunforc2 )
	IREM_JOYSTICK_1_2(1)
	IREM_JOYSTICK_1_2(2)
	IREM_PORT_UNUSED
	IREM_PORT_UNUSED
	IREM_COINS
	IREM_SYSTEM_DIPSWITCH

	PORT_START	/* Dip switch bank 1 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x02, "3" )
	PORT_DIPSETTING(    0x03, "2" )
	PORT_DIPSETTING(    0x01, "4" )
	PORT_DIPSETTING(    0x00, "1" )
	PORT_DIPNAME( 0x0c, 0x0c, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Very_Easy) )
	PORT_DIPSETTING(    0x08, DEF_STR( Easy ) )
	PORT_DIPSETTING(    0x0c, DEF_STR( Normal ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Hard ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Bonus_Life ) )
	PORT_DIPSETTING(    0x00, "15000 35000 75000 120000" )
	PORT_DIPSETTING(    0x10, "20000 40000 90000 150000" )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Allow_Continue ) )
	PORT_DIPSETTING(    0x00, DEF_STR( No ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	IREM_PORT_UNUSED	/* Game manual only mentions 2 dips */
INPUT_PORTS_END

/***************************************************************************/

static struct GfxLayout charlayout =
{
	8,8,	/* 8*8 characters */
	RGN_FRAC(1,4),
	4,	/* 4 bits per pixel */
	{ RGN_FRAC(3,4), RGN_FRAC(2,4), RGN_FRAC(1,4), RGN_FRAC(0,4) },
	{ 0, 1, 2, 3, 4, 5, 6, 7 },
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8 },
	8*8	/* every char takes 8 consecutive bytes */
};

static struct GfxLayout spritelayout =
{
	16,16,
	RGN_FRAC(1,4),
	4,
	{ RGN_FRAC(3,4), RGN_FRAC(2,4), RGN_FRAC(1,4), RGN_FRAC(0,4) },
	{ 0, 1, 2, 3, 4, 5, 6, 7,
		16*8+0, 16*8+1, 16*8+2, 16*8+3, 16*8+4, 16*8+5, 16*8+6, 16*8+7 },
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8,
			8*8, 9*8, 10*8, 11*8, 12*8, 13*8, 14*8, 15*8 },
	32*8
};

static struct GfxLayout spritelayout2 =
{
	16,16,
	RGN_FRAC(1,4),
	4,
	{ RGN_FRAC(3,4), RGN_FRAC(2,4), RGN_FRAC(1,4), RGN_FRAC(0,4) },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0*16, 1*16, 2*16, 3*16, 4*16, 5*16, 6*16, 7*16,
			8*16, 9*16, 10*16, 11*16, 12*16, 13*16, 14*16, 15*16 },
	32*8
};

static struct GfxDecodeInfo gfxdecodeinfo[] =
{
	{ REGION_GFX1, 0, &charlayout,   0, 128 },
	{ REGION_GFX2, 0, &spritelayout, 0, 128 },
	{ -1 } /* end of array */
};

static struct GfxDecodeInfo gfxdecodeinfo2[] =
{
	{ REGION_GFX1, 0, &charlayout,    0, 128 },
	{ REGION_GFX2, 0, &spritelayout2, 0, 128 },
	{ -1 } /* end of array */
};

/***************************************************************************/

static void sound_irq(int state)
{
	if (state)
		timer_set(TIME_NOW,YM2151_ASSERT,setvector_callback);
	else
		timer_set(TIME_NOW,YM2151_CLEAR,setvector_callback);
}

static struct YM2151interface ym2151_interface =
{
	1,
	14318180/4,
	{ YM3012_VOL(40,MIXER_PAN_LEFT,40,MIXER_PAN_RIGHT) },
	{ sound_irq }
};

static struct IremGA20_interface iremGA20_interface =
{
	14318180/4,
	REGION_SOUND1,
	{ MIXER(100,MIXER_PAN_LEFT), MIXER(100,MIXER_PAN_RIGHT) },
};

/***************************************************************************/

static INTERRUPT_GEN( m92_interrupt )
{
	force_partial_update(249+128);

	cpu_set_irq_line_and_vector(0, 0, HOLD_LINE, M92_IRQ_0); /* VBL */
}

static INTERRUPT_GEN( m92_raster_interrupt )
{
	int line = M92_SCANLINES - cpu_getiloops();

	/* Raster interrupt */
	if (m92_raster_enable && line==m92_raster_irq_position) {
		force_partial_update(line+128);
		cpu_set_irq_line_and_vector(0, 0, HOLD_LINE, M92_IRQ_2);
	}

	/* Redraw screen, then set vblank and trigger the VBL interrupt */
	else if (line==249) { /* 248 is last visible line */
		force_partial_update(249+128);
		cpu_set_irq_line_and_vector(0, 0, HOLD_LINE, M92_IRQ_0);
	}
}

void m92_sprite_interrupt(void)
{
	cpu_set_irq_line_and_vector(0,0,HOLD_LINE,M92_IRQ_1);
}

static MACHINE_DRIVER_START( raster )

	/* basic machine hardware */
	MDRV_CPU_ADD(V33,18000000/2)	/* NEC V33, 18 MHz clock */
	MDRV_CPU_MEMORY(readmem,writemem)
	MDRV_CPU_PORTS(readport,writeport)
	MDRV_CPU_VBLANK_INT(m92_raster_interrupt,M92_SCANLINES) /* First visible line 8? */

	MDRV_CPU_ADD(V30, 14318180/2)	/* 14.31818 MHz */
	MDRV_CPU_MEMORY(sound_readmem,sound_writemem)

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER | VIDEO_BUFFERS_SPRITERAM)
	MDRV_SCREEN_SIZE(512, 512)
	MDRV_VISIBLE_AREA(80, 511-112, 128+8, 511-128-8) /* 320 x 240 */
	MDRV_GFXDECODE(gfxdecodeinfo)
	MDRV_PALETTE_LENGTH(2048)

	MDRV_VIDEO_START(m92)
	MDRV_VIDEO_UPDATE(m92)

	/* sound hardware */
	MDRV_SOUND_ADD(YM2151, ym2151_interface)
	MDRV_SOUND_ADD(IREMGA20, iremGA20_interface)
MACHINE_DRIVER_END


static MACHINE_DRIVER_START( nonraster )

	/* basic machine hardware */
	MDRV_CPU_ADD(V33, 18000000/2)	 /* NEC V33, 18 MHz clock */
	MDRV_CPU_MEMORY(readmem,writemem)
	MDRV_CPU_PORTS(readport,writeport)
	MDRV_CPU_VBLANK_INT(m92_interrupt,1)

	MDRV_CPU_ADD(V30, 14318180/2)
	MDRV_CPU_FLAGS(CPU_AUDIO_CPU)	/* 14.31818 MHz */
	MDRV_CPU_MEMORY(sound_readmem,sound_writemem)

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER | VIDEO_BUFFERS_SPRITERAM)
	MDRV_SCREEN_SIZE(512, 512)
	MDRV_VISIBLE_AREA(80, 511-112, 128+8, 511-128-8) /* 320 x 240 */
	MDRV_GFXDECODE(gfxdecodeinfo)
	MDRV_PALETTE_LENGTH(2048)

	MDRV_VIDEO_START(m92)
	MDRV_VIDEO_UPDATE(m92)

	/* sound hardware */
	MDRV_SOUND_ADD(YM2151, ym2151_interface)
	MDRV_SOUND_ADD(IREMGA20, iremGA20_interface)
MACHINE_DRIVER_END


static MACHINE_DRIVER_START( lethalth )

	/* basic machine hardware */
	MDRV_CPU_ADD(V33, 18000000/2)	/* NEC V33, 18 MHz clock */
	MDRV_CPU_MEMORY(lethalth_readmem,lethalth_writemem)
	MDRV_CPU_PORTS(readport,writeport)
	MDRV_CPU_VBLANK_INT(m92_interrupt,1)

	MDRV_CPU_ADD(V30, 14318180/2)
	MDRV_CPU_FLAGS(CPU_AUDIO_CPU)	/* 14.31818 MHz */
	MDRV_CPU_MEMORY(sound_readmem,sound_writemem)

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER | VIDEO_BUFFERS_SPRITERAM)
	MDRV_SCREEN_SIZE(512, 512)
	MDRV_VISIBLE_AREA(80, 511-112, 128+8, 511-128-8) /* 320 x 240 */
	MDRV_GFXDECODE(gfxdecodeinfo)
	MDRV_PALETTE_LENGTH(2048)

	MDRV_VIDEO_START(m92)
	MDRV_VIDEO_UPDATE(m92)

	/* sound hardware */
	MDRV_SOUND_ADD(YM2151, ym2151_interface)
	MDRV_SOUND_ADD(IREMGA20, iremGA20_interface)
MACHINE_DRIVER_END


static MACHINE_DRIVER_START( psoldier )

	/* basic machine hardware */
	MDRV_CPU_ADD(V33, 18000000/2)		/* NEC V33, 18 MHz clock */
	MDRV_CPU_MEMORY(readmem,writemem)
	MDRV_CPU_PORTS(readport,writeport)
	MDRV_CPU_VBLANK_INT(m92_interrupt,1)

	MDRV_CPU_ADD(V30, 14318180/2)
	MDRV_CPU_FLAGS(CPU_AUDIO_CPU)	/* 14.31818 MHz */
	MDRV_CPU_MEMORY(sound_readmem,sound_writemem)

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER | VIDEO_BUFFERS_SPRITERAM)
	MDRV_SCREEN_SIZE(512, 512)
	MDRV_VISIBLE_AREA(80, 511-112, 128+8, 511-128-8) /* 320 x 240 */
	MDRV_GFXDECODE(gfxdecodeinfo2)
	MDRV_PALETTE_LENGTH(2048)

	MDRV_VIDEO_START(m92)
	MDRV_VIDEO_UPDATE(m92)

	/* sound hardware */
	MDRV_SOUND_ADD(YM2151, ym2151_interface)
	MDRV_SOUND_ADD(IREMGA20, iremGA20_interface)
MACHINE_DRIVER_END

/***************************************************************************/

ROM_START( bmaster )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "bm_d-h0.rom",  0x000001, 0x40000, 0x49b257c7 )
	ROM_LOAD16_BYTE( "bm_d-l0.rom",  0x000000, 0x40000, 0xa873523e )
	ROM_LOAD16_BYTE( "bm_d-h1.rom",  0x080001, 0x10000, 0x082b7158 )
	ROM_LOAD16_BYTE( "bm_d-l1.rom",  0x080000, 0x10000, 0x6ff0c04e )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )
	ROM_LOAD16_BYTE( "bm_d-sh0.rom",  0x000001, 0x10000, 0x9f7c075b )
	ROM_LOAD16_BYTE( "bm_d-sl0.rom",  0x000000, 0x10000, 0x1fa87c89 )

	ROM_REGION( 0x100000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "bm_c0.rom",       0x000000, 0x40000, 0x2cc966b8 )
	ROM_LOAD( "bm_c1.rom",       0x040000, 0x40000, 0x46df773e )
	ROM_LOAD( "bm_c2.rom",       0x080000, 0x40000, 0x05b867bd )
	ROM_LOAD( "bm_c3.rom",       0x0c0000, 0x40000, 0x0a2227a4 )

	ROM_REGION( 0x200000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "bm_000.rom",      0x000000, 0x80000, 0x339fc9f3 )
	ROM_LOAD( "bm_010.rom",      0x080000, 0x80000, 0x6a14377d )
	ROM_LOAD( "bm_020.rom",      0x100000, 0x80000, 0x31532198 )
	ROM_LOAD( "bm_030.rom",      0x180000, 0x80000, 0xd1a041d3 )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "bm_da.rom",       0x000000, 0x80000, 0x62ce5798 )
ROM_END

ROM_START( skingame )
	ROM_REGION( 0x180000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "is-h0-d",  0x000001, 0x40000, 0x80940abb )
	ROM_LOAD16_BYTE( "is-l0-d",  0x000000, 0x40000, 0xb84beed6 )
	ROM_LOAD16_BYTE( "is-h1",    0x100001, 0x40000, 0x9ba8e1f2 )
	ROM_LOAD16_BYTE( "is-l1",    0x100000, 0x40000, 0xe4e00626 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 64k for the audio CPU */
	ROM_LOAD16_BYTE( "mt2sh0",  0x000001, 0x10000, 0x1ecbea43 )
	ROM_LOAD16_BYTE( "mt2sl0",  0x000000, 0x10000, 0x8fd5b531 )

	ROM_REGION( 0x100000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "c0",       0x000000, 0x40000, 0x7e61e4b5 )
	ROM_LOAD( "c1",       0x040000, 0x40000, 0x0a667564 )
	ROM_LOAD( "c2",       0x080000, 0x40000, 0x5eb44312 )
	ROM_LOAD( "c3",       0x0c0000, 0x40000, 0xf2866294 )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "k30",      0x000000, 0x100000, 0x8c9a2678 )
	ROM_LOAD( "k31",      0x100000, 0x100000, 0x5455df78 )
	ROM_LOAD( "k32",      0x200000, 0x100000, 0x3a258c41 )
	ROM_LOAD( "k33",      0x300000, 0x100000, 0xc1e91a14 )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "da",        0x000000, 0x80000, 0x713b9e9f )

	ROM_REGION( 0x4000, REGION_USER1, 0 )	/* EEPROM */
	ROM_LOAD( "mt2eep",       0x000000, 0x800, 0x208af971 )
ROM_END

ROM_START( majtitl2 )
	ROM_REGION( 0x180000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "mt2-ho-b.5m",0x000001, 0x40000, 0xb163b12e )
	ROM_LOAD16_BYTE( "mt2-lo-b.5f",0x000000, 0x40000, 0x6f3b5d9d )
	ROM_LOAD16_BYTE( "is-h1",      0x100001, 0x40000, 0x9ba8e1f2 )
	ROM_LOAD16_BYTE( "is-l1",      0x100000, 0x40000, 0xe4e00626 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 64k for the audio CPU */
	ROM_LOAD16_BYTE( "mt2sh0",  0x000001, 0x10000, 0x1ecbea43 )
	ROM_LOAD16_BYTE( "mt2sl0",  0x000000, 0x10000, 0x8fd5b531 )

	ROM_REGION( 0x100000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "c0",       0x000000, 0x40000, 0x7e61e4b5 )
	ROM_LOAD( "c1",       0x040000, 0x40000, 0x0a667564 )
	ROM_LOAD( "c2",       0x080000, 0x40000, 0x5eb44312 )
	ROM_LOAD( "c3",       0x0c0000, 0x40000, 0xf2866294 )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "k30",      0x000000, 0x100000, 0x8c9a2678 )
	ROM_LOAD( "k31",      0x100000, 0x100000, 0x5455df78 )
	ROM_LOAD( "k32",      0x200000, 0x100000, 0x3a258c41 )
	ROM_LOAD( "k33",      0x300000, 0x100000, 0xc1e91a14 )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "da",        0x000000, 0x80000, 0x713b9e9f )

	ROM_REGION( 0x4000, REGION_USER1, 0 )	/* EEPROM */
	ROM_LOAD( "mt2eep",       0x000000, 0x800, 0x208af971 )
ROM_END

ROM_START( skingam2 )
	ROM_REGION( 0x180000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "mt2h0a", 0x000001, 0x40000, 0x7c6dbbc7 )
	ROM_LOAD16_BYTE( "mt2l0a", 0x000000, 0x40000, 0x9de5f689 )
	ROM_LOAD16_BYTE( "is-h1",  0x100001, 0x40000, 0x9ba8e1f2 )
	ROM_LOAD16_BYTE( "is-l1",  0x100000, 0x40000, 0xe4e00626 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )
	ROM_LOAD16_BYTE( "mt2sh0",  0x000001, 0x10000, 0x1ecbea43 )
	ROM_LOAD16_BYTE( "mt2sl0",  0x000000, 0x10000, 0x8fd5b531 )

	ROM_REGION( 0x100000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "c0",       0x000000, 0x40000, 0x7e61e4b5 )
	ROM_LOAD( "c1",       0x040000, 0x40000, 0x0a667564 )
	ROM_LOAD( "c2",       0x080000, 0x40000, 0x5eb44312 )
	ROM_LOAD( "c3",       0x0c0000, 0x40000, 0xf2866294 )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "k30",      0x000000, 0x100000, 0x8c9a2678 )
	ROM_LOAD( "k31",      0x100000, 0x100000, 0x5455df78 )
	ROM_LOAD( "k32",      0x200000, 0x100000, 0x3a258c41 )
	ROM_LOAD( "k33",      0x300000, 0x100000, 0xc1e91a14 )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "da",        0x000000, 0x80000, 0x713b9e9f )

	ROM_REGION( 0x4000, REGION_USER1, 0 )	/* EEPROM */
	ROM_LOAD( "mt2eep",       0x000000, 0x800, 0x208af971 )
ROM_END

ROM_START( gunforce )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "gf_h0-c.rom",  0x000001, 0x20000, 0xc09bb634 )
	ROM_LOAD16_BYTE( "gf_l0-c.rom",  0x000000, 0x20000, 0x1bef6f7d )
	ROM_LOAD16_BYTE( "gf_h1-c.rom",  0x040001, 0x20000, 0xc84188b7 )
	ROM_LOAD16_BYTE( "gf_l1-c.rom",  0x040000, 0x20000, 0xb189f72a )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU - encrypted V30 = NANAO custom D80001 (?) */
	ROM_LOAD16_BYTE( "gf_sh0.rom",0x000001, 0x010000, 0x3f8f16e0 )
	ROM_LOAD16_BYTE( "gf_sl0.rom",0x000000, 0x010000, 0xdb0b13a3 )

	ROM_REGION( 0x100000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "gf_c0.rom",       0x000000, 0x40000, 0xb3b74979 )
	ROM_LOAD( "gf_c1.rom",       0x040000, 0x40000, 0xf5c8590a )
	ROM_LOAD( "gf_c2.rom",       0x080000, 0x40000, 0x30f9fb64 )
	ROM_LOAD( "gf_c3.rom",       0x0c0000, 0x40000, 0x87b3e621 )

	ROM_REGION( 0x100000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "gf_000.rom",      0x000000, 0x40000, 0x209e8e8d )
	ROM_LOAD( "gf_010.rom",      0x040000, 0x40000, 0x6e6e7808 )
	ROM_LOAD( "gf_020.rom",      0x080000, 0x40000, 0x6f5c3cb0 )
	ROM_LOAD( "gf_030.rom",      0x0c0000, 0x40000, 0x18978a9f )

	ROM_REGION( 0x20000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "gf-da.rom",	 0x000000, 0x020000, 0x933ba935 )
ROM_END

ROM_START( gunforcj )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "gfbh0e.bin",  0x000001, 0x20000, 0x43c36e0f )
	ROM_LOAD16_BYTE( "gfbl0e.bin",  0x000000, 0x20000, 0x24a558d8 )
	ROM_LOAD16_BYTE( "gfbh1e.bin",  0x040001, 0x20000, 0xd9744f5d )
	ROM_LOAD16_BYTE( "gfbl1e.bin",  0x040000, 0x20000, 0xa0f7b61b )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU - encrypted V30 = NANAO custom D80001 (?) */
	ROM_LOAD16_BYTE( "gf_sh0.rom",0x000001, 0x010000, 0x3f8f16e0 )
	ROM_LOAD16_BYTE( "gf_sl0.rom",0x000000, 0x010000, 0xdb0b13a3 )

	ROM_REGION( 0x100000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "gf_c0.rom",       0x000000, 0x40000, 0xb3b74979 )
	ROM_LOAD( "gf_c1.rom",       0x040000, 0x40000, 0xf5c8590a )
	ROM_LOAD( "gf_c2.rom",       0x080000, 0x40000, 0x30f9fb64 )
	ROM_LOAD( "gf_c3.rom",       0x0c0000, 0x40000, 0x87b3e621 )

	ROM_REGION( 0x100000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "gf_000.rom",      0x000000, 0x40000, 0x209e8e8d )
	ROM_LOAD( "gf_010.rom",      0x040000, 0x40000, 0x6e6e7808 )
	ROM_LOAD( "gf_020.rom",      0x080000, 0x40000, 0x6f5c3cb0 )
	ROM_LOAD( "gf_030.rom",      0x0c0000, 0x40000, 0x18978a9f )

	ROM_REGION( 0x20000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "gf-da.rom",	 0x000000, 0x020000, 0x933ba935 )
ROM_END

ROM_START( gunforcu )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "gf_h0-d.5m",  0x000001, 0x20000, 0xa6db7b5c )
	ROM_LOAD16_BYTE( "gf_l0-d.5f",  0x000000, 0x20000, 0x82cf55f6 )
	ROM_LOAD16_BYTE( "gf_h1-d.5l",  0x040001, 0x20000, 0x08a3736c )
	ROM_LOAD16_BYTE( "gf_l1-d.5j",  0x040000, 0x20000, 0x435f524f )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU - encrypted V30 = NANAO custom D80001 (?) */
	ROM_LOAD16_BYTE( "gf_sh0.rom",0x000001, 0x010000, 0x3f8f16e0 )
	ROM_LOAD16_BYTE( "gf_sl0.rom",0x000000, 0x010000, 0xdb0b13a3 )

	ROM_REGION( 0x100000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "gf_c0.rom",       0x000000, 0x40000, 0xb3b74979 )
	ROM_LOAD( "gf_c1.rom",       0x040000, 0x40000, 0xf5c8590a )
	ROM_LOAD( "gf_c2.rom",       0x080000, 0x40000, 0x30f9fb64 )
	ROM_LOAD( "gf_c3.rom",       0x0c0000, 0x40000, 0x87b3e621 )

	ROM_REGION( 0x100000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "gf_000.rom",      0x000000, 0x40000, 0x209e8e8d )
	ROM_LOAD( "gf_010.rom",      0x040000, 0x40000, 0x6e6e7808 )
	ROM_LOAD( "gf_020.rom",      0x080000, 0x40000, 0x6f5c3cb0 )
	ROM_LOAD( "gf_030.rom",      0x0c0000, 0x40000, 0x18978a9f )

	ROM_REGION( 0x20000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "gf-da.rom",	 0x000000, 0x020000, 0x933ba935 )
ROM_END

ROM_START( inthunt )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "ith-h0-d.rom",0x000001, 0x040000, 0x52f8e7a6 )
	ROM_LOAD16_BYTE( "ith-l0-d.rom",0x000000, 0x040000, 0x5db79eb7 )
	ROM_LOAD16_BYTE( "ith-h1-b.rom",0x080001, 0x020000, 0xfc2899df )
	ROM_LOAD16_BYTE( "ith-l1-b.rom",0x080000, 0x020000, 0x955a605a )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* Irem D8000011A1 */
	ROM_LOAD16_BYTE( "ith-sh0.rom",0x000001, 0x010000, 0x209c8b7f )
	ROM_LOAD16_BYTE( "ith-sl0.rom",0x000000, 0x010000, 0x18472d65 )

	ROM_REGION( 0x200000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "ith_ic26.rom",0x000000, 0x080000, 0x4c1818cf )
	ROM_LOAD( "ith_ic25.rom",0x080000, 0x080000, 0x91145bae )
	ROM_LOAD( "ith_ic24.rom",0x100000, 0x080000, 0xfc03fe3b )
	ROM_LOAD( "ith_ic23.rom",0x180000, 0x080000, 0xee156a0a )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "ith_ic34.rom",0x000000, 0x100000, 0xa019766e )
	ROM_LOAD( "ith_ic35.rom",0x100000, 0x100000, 0x3fca3073 )
	ROM_LOAD( "ith_ic36.rom",0x200000, 0x100000, 0x20d1b28b )
	ROM_LOAD( "ith_ic37.rom",0x300000, 0x100000, 0x90b6fd4b )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "ith_ic9.rom" ,0x000000, 0x080000, 0x318ee71a )
ROM_END

ROM_START( inthuntu )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "ithhoc.bin",0x000001, 0x040000, 0x563dcec0 )
	ROM_LOAD16_BYTE( "ithloc.bin",0x000000, 0x040000, 0x1638c705 )
	ROM_LOAD16_BYTE( "ithh1a.bin",0x080001, 0x020000, 0x0253065f )
	ROM_LOAD16_BYTE( "ithl1a.bin",0x080000, 0x020000, 0xa57d688d )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* Irem D8000011A1 */
	ROM_LOAD16_BYTE( "ith-sh0.rom",0x000001, 0x010000, 0x209c8b7f )
	ROM_LOAD16_BYTE( "ith-sl0.rom",0x000000, 0x010000, 0x18472d65 )

	ROM_REGION( 0x200000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "ith_ic26.rom",0x000000, 0x080000, 0x4c1818cf )
	ROM_LOAD( "ith_ic25.rom",0x080000, 0x080000, 0x91145bae )
	ROM_LOAD( "ith_ic24.rom",0x100000, 0x080000, 0xfc03fe3b )
	ROM_LOAD( "ith_ic23.rom",0x180000, 0x080000, 0xee156a0a )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "ith_ic34.rom",0x000000, 0x100000, 0xa019766e )
	ROM_LOAD( "ith_ic35.rom",0x100000, 0x100000, 0x3fca3073 )
	ROM_LOAD( "ith_ic36.rom",0x200000, 0x100000, 0x20d1b28b )
	ROM_LOAD( "ith_ic37.rom",0x300000, 0x100000, 0x90b6fd4b )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "ith_ic9.rom" ,0x000000, 0x080000, 0x318ee71a )
ROM_END

ROM_START( kaiteids )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "ith-h0j.bin",0x000001, 0x040000, 0xdc1dec36 )
	ROM_LOAD16_BYTE( "ith-l0j.bin",0x000000, 0x040000, 0x8835d704 )
	ROM_LOAD16_BYTE( "ith-h1j.bin",0x080001, 0x020000, 0x5a7b212d )
	ROM_LOAD16_BYTE( "ith-l1j.bin",0x080000, 0x020000, 0x4c084494 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* Irem D8000011A1 */
	ROM_LOAD16_BYTE( "ith-sh0.rom",0x000001, 0x010000, 0x209c8b7f )
	ROM_LOAD16_BYTE( "ith-sl0.rom",0x000000, 0x010000, 0x18472d65 )

	ROM_REGION( 0x200000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "ith_ic26.rom",0x000000, 0x080000, 0x4c1818cf )
	ROM_LOAD( "ith_ic25.rom",0x080000, 0x080000, 0x91145bae )
	ROM_LOAD( "ith_ic24.rom",0x100000, 0x080000, 0xfc03fe3b )
	ROM_LOAD( "ith_ic23.rom",0x180000, 0x080000, 0xee156a0a )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "ith_ic34.rom",0x000000, 0x100000, 0xa019766e )
	ROM_LOAD( "ith_ic35.rom",0x100000, 0x100000, 0x3fca3073 )
	ROM_LOAD( "ith_ic36.rom",0x200000, 0x100000, 0x20d1b28b )
	ROM_LOAD( "ith_ic37.rom",0x300000, 0x100000, 0x90b6fd4b )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "ith_ic9.rom" ,0x000000, 0x080000, 0x318ee71a )
ROM_END

ROM_START( hook )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "h-h0-d.rom",0x000001, 0x040000, 0x40189ff6 )
	ROM_LOAD16_BYTE( "h-l0-d.rom",0x000000, 0x040000, 0x14567690 )
	ROM_LOAD16_BYTE( "h-h1.rom",  0x080001, 0x020000, 0x264ba1f0 )
	ROM_LOAD16_BYTE( "h-l1.rom",  0x080000, 0x020000, 0xf9913731 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU - encrypted V30 = NANAO custom D80001 (?) */
	ROM_LOAD16_BYTE( "h-sh0.rom",0x000001, 0x010000, 0x86a4e56e )
	ROM_LOAD16_BYTE( "h-sl0.rom",0x000000, 0x010000, 0x10fd9676 )

	ROM_REGION( 0x100000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "hook-c0.rom",0x000000, 0x040000, 0xdec63dcf )
	ROM_LOAD( "hook-c1.rom",0x040000, 0x040000, 0xe4eb0b92 )
	ROM_LOAD( "hook-c2.rom",0x080000, 0x040000, 0xa52b320b )
	ROM_LOAD( "hook-c3.rom",0x0c0000, 0x040000, 0x7ef67731 )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "hook-000.rom",0x000000, 0x100000, 0xccceac30 )
	ROM_LOAD( "hook-010.rom",0x100000, 0x100000, 0x8ac8da67 )
	ROM_LOAD( "hook-020.rom",0x200000, 0x100000, 0x8847af9a )
	ROM_LOAD( "hook-030.rom",0x300000, 0x100000, 0x239e877e )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "hook-da.rom" ,0x000000, 0x080000, 0x88cd0212 )
ROM_END

ROM_START( hooku )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "h0-c.3h",0x000001, 0x040000, 0x84cc239e )
	ROM_LOAD16_BYTE( "l0-c.5h",0x000000, 0x040000, 0x45e194fe )
	ROM_LOAD16_BYTE( "h-h1.rom",  0x080001, 0x020000, 0x264ba1f0 )
	ROM_LOAD16_BYTE( "h-l1.rom",  0x080000, 0x020000, 0xf9913731 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU - encrypted V30 = NANAO custom D80001 (?) */
	ROM_LOAD16_BYTE( "h-sh0.rom",0x000001, 0x010000, 0x86a4e56e )
	ROM_LOAD16_BYTE( "h-sl0.rom",0x000000, 0x010000, 0x10fd9676 )

	ROM_REGION( 0x100000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "hook-c0.rom",0x000000, 0x040000, 0xdec63dcf )
	ROM_LOAD( "hook-c1.rom",0x040000, 0x040000, 0xe4eb0b92 )
	ROM_LOAD( "hook-c2.rom",0x080000, 0x040000, 0xa52b320b )
	ROM_LOAD( "hook-c3.rom",0x0c0000, 0x040000, 0x7ef67731 )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "hook-000.rom",0x000000, 0x100000, 0xccceac30 )
	ROM_LOAD( "hook-010.rom",0x100000, 0x100000, 0x8ac8da67 )
	ROM_LOAD( "hook-020.rom",0x200000, 0x100000, 0x8847af9a )
	ROM_LOAD( "hook-030.rom",0x300000, 0x100000, 0x239e877e )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "hook-da.rom" ,0x000000, 0x080000, 0x88cd0212 )
ROM_END

ROM_START( hookj )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "h-h0-g.3h",0x000001, 0x040000, 0x5964c886 )
	ROM_LOAD16_BYTE( "h-l0-g.5h",0x000000, 0x040000, 0x7f7433f2 )
	ROM_LOAD16_BYTE( "h-h1.rom",  0x080001, 0x020000, 0x264ba1f0 )
	ROM_LOAD16_BYTE( "h-l1.rom",  0x080000, 0x020000, 0xf9913731 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU - encrypted V30 = NANAO custom D80001 (?) */
	ROM_LOAD16_BYTE( "h-sh0-a.3l",0x000001, 0x010000, 0xbd3d1f61 )
	ROM_LOAD16_BYTE( "h-sl0-a.3n",0x000000, 0x010000, 0x76371def )

	ROM_REGION( 0x100000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "hook-c0.rom",0x000000, 0x040000, 0xdec63dcf )
	ROM_LOAD( "hook-c1.rom",0x040000, 0x040000, 0xe4eb0b92 )
	ROM_LOAD( "hook-c2.rom",0x080000, 0x040000, 0xa52b320b )
	ROM_LOAD( "hook-c3.rom",0x0c0000, 0x040000, 0x7ef67731 )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "hook-000.rom",0x000000, 0x100000, 0xccceac30 )
	ROM_LOAD( "hook-010.rom",0x100000, 0x100000, 0x8ac8da67 )
	ROM_LOAD( "hook-020.rom",0x200000, 0x100000, 0x8847af9a )
	ROM_LOAD( "hook-030.rom",0x300000, 0x100000, 0x239e877e )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "hook-da.rom" ,0x000000, 0x080000, 0x88cd0212 )
ROM_END

ROM_START( rtypeleo )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "rtl-h0-c",     0x000001, 0x040000, 0x5fef7fa1 )
	ROM_LOAD16_BYTE( "rtl-l0-c",     0x000000, 0x040000, 0x8156456b )
	ROM_LOAD16_BYTE( "rtl-h1-d.bin", 0x080001, 0x020000, 0x352ff444 )
	ROM_LOAD16_BYTE( "rtl-l1-d.bin", 0x080000, 0x020000, 0xfd34ea46 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU - encrypted V30 = NANAO custom D80001 (?) */
	ROM_LOAD16_BYTE( "rtl-sh0a.bin",0x000001, 0x010000, 0xe518b4e3 )
	ROM_LOAD16_BYTE( "rtl-sl0a.bin",0x000000, 0x010000, 0x896f0d36 )

	ROM_REGION( 0x200000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "rtl-c0.bin", 0x000000, 0x080000, 0xfb588d7c )
	ROM_LOAD( "rtl-c1.bin", 0x080000, 0x080000, 0xe5541bff )
	ROM_LOAD( "rtl-c2.bin", 0x100000, 0x080000, 0xfaa9ae27 )
	ROM_LOAD( "rtl-c3.bin", 0x180000, 0x080000, 0x3a2343f6 )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "rtl-000.bin",0x000000, 0x100000, 0x82a06870 )
	ROM_LOAD( "rtl-010.bin",0x100000, 0x100000, 0x417e7a56 )
	ROM_LOAD( "rtl-020.bin",0x200000, 0x100000, 0xf9a3f3a1 )
	ROM_LOAD( "rtl-030.bin",0x300000, 0x100000, 0x03528d95 )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "rtl-da.bin" ,0x000000, 0x080000, 0xdbebd1ff )
ROM_END

ROM_START( rtypelej )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "rtl-h0-d.bin", 0x000001, 0x040000, 0x3dbac89f )
	ROM_LOAD16_BYTE( "rtl-l0-d.bin", 0x000000, 0x040000, 0xf85a2537 )
	ROM_LOAD16_BYTE( "rtl-h1-d.bin", 0x080001, 0x020000, 0x352ff444 )
	ROM_LOAD16_BYTE( "rtl-l1-d.bin", 0x080000, 0x020000, 0xfd34ea46 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU - encrypted V30 = NANAO custom D80001 (?) */
	ROM_LOAD16_BYTE( "rtl-sh0a.bin",0x000001, 0x010000, 0xe518b4e3 )
	ROM_LOAD16_BYTE( "rtl-sl0a.bin",0x000000, 0x010000, 0x896f0d36 )

	ROM_REGION( 0x200000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "rtl-c0.bin", 0x000000, 0x080000, 0xfb588d7c )
	ROM_LOAD( "rtl-c1.bin", 0x080000, 0x080000, 0xe5541bff )
	ROM_LOAD( "rtl-c2.bin", 0x100000, 0x080000, 0xfaa9ae27 )
	ROM_LOAD( "rtl-c3.bin", 0x180000, 0x080000, 0x3a2343f6 )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "rtl-000.bin",0x000000, 0x100000, 0x82a06870 )
	ROM_LOAD( "rtl-010.bin",0x100000, 0x100000, 0x417e7a56 )
	ROM_LOAD( "rtl-020.bin",0x200000, 0x100000, 0xf9a3f3a1 )
	ROM_LOAD( "rtl-030.bin",0x300000, 0x100000, 0x03528d95 )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "rtl-da.bin" ,0x000000, 0x080000, 0xdbebd1ff )
ROM_END

ROM_START( mysticri )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "mr-h0-b.bin",  0x000001, 0x040000, 0xd529f887 )
	ROM_LOAD16_BYTE( "mr-l0-b.bin",  0x000000, 0x040000, 0xa457ab44 )
	ROM_LOAD16_BYTE( "mr-h1-b.bin",  0x080001, 0x010000, 0xe17649b9 )
	ROM_LOAD16_BYTE( "mr-l1-b.bin",  0x080000, 0x010000, 0xa87c62b4 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU - encrypted V30 = NANAO custom D80001 (?) */
	ROM_LOAD16_BYTE( "mr-sh0.bin",0x000001, 0x010000, 0x50d335e4 )
	ROM_LOAD16_BYTE( "mr-sl0.bin",0x000000, 0x010000, 0x0fa32721 )

	ROM_REGION( 0x100000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "mr-c0.bin", 0x000000, 0x040000, 0x872a8fad )
	ROM_LOAD( "mr-c1.bin", 0x040000, 0x040000, 0xd2ffb27a )
	ROM_LOAD( "mr-c2.bin", 0x080000, 0x040000, 0x62bff287 )
	ROM_LOAD( "mr-c3.bin", 0x0c0000, 0x040000, 0xd0da62ab )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "mr-o00.bin", 0x000000, 0x080000, 0xa0f9ce16 )
	ROM_LOAD( "mr-o10.bin", 0x100000, 0x080000, 0x4e70a9e9 )
	ROM_LOAD( "mr-o20.bin", 0x200000, 0x080000, 0xb9c468fc )
	ROM_LOAD( "mr-o30.bin", 0x300000, 0x080000, 0xcc32433a )

	ROM_REGION( 0x40000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "mr-da.bin" ,0x000000, 0x040000, 0x1a11fc59 )
ROM_END

ROM_START( gunhohki )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "mr-h0.bin",  0x000001, 0x040000, 0x83352270 )
	ROM_LOAD16_BYTE( "mr-l0.bin",  0x000000, 0x040000, 0x9db308ae )
	ROM_LOAD16_BYTE( "mr-h1.bin",  0x080001, 0x010000, 0xc9532b60 )
	ROM_LOAD16_BYTE( "mr-l1.bin",  0x080000, 0x010000, 0x6349b520 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU - encrypted V30 = NANAO custom D80001 (?) */
	ROM_LOAD16_BYTE( "mr-sh0.bin",0x000001, 0x010000, 0x50d335e4 )
	ROM_LOAD16_BYTE( "mr-sl0.bin",0x000000, 0x010000, 0x0fa32721 )

	ROM_REGION( 0x100000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "mr-c0.bin", 0x000000, 0x040000, 0x872a8fad )
	ROM_LOAD( "mr-c1.bin", 0x040000, 0x040000, 0xd2ffb27a )
	ROM_LOAD( "mr-c2.bin", 0x080000, 0x040000, 0x62bff287 )
	ROM_LOAD( "mr-c3.bin", 0x0c0000, 0x040000, 0xd0da62ab )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "mr-o00.bin", 0x000000, 0x080000, 0xa0f9ce16 )
	ROM_LOAD( "mr-o10.bin", 0x100000, 0x080000, 0x4e70a9e9 )
	ROM_LOAD( "mr-o20.bin", 0x200000, 0x080000, 0xb9c468fc )
	ROM_LOAD( "mr-o30.bin", 0x300000, 0x080000, 0xcc32433a )

	ROM_REGION( 0x40000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "mr-da.bin" ,0x000000, 0x040000, 0x1a11fc59 )
ROM_END

ROM_START( uccops )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "uc_h0.rom",  0x000001, 0x040000, 0x240aa5f7 )
	ROM_LOAD16_BYTE( "uc_l0.rom",  0x000000, 0x040000, 0xdf9a4826 )
	ROM_LOAD16_BYTE( "uc_h1.rom",  0x080001, 0x020000, 0x8d29bcd6 )
	ROM_LOAD16_BYTE( "uc_l1.rom",  0x080000, 0x020000, 0xa8a402d8 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU - encrypted V30 = NANAO custom D80001 (?) */
	ROM_LOAD16_BYTE( "uc_sh0.rom", 0x000001, 0x010000, 0xdf90b198 )
	ROM_LOAD16_BYTE( "uc_sl0.rom", 0x000000, 0x010000, 0x96c11aac )

	ROM_REGION( 0x200000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "uc_w38m.rom", 0x000000, 0x080000, 0x130a40e5 )
	ROM_LOAD( "uc_w39m.rom", 0x080000, 0x080000, 0xe42ca144 )
	ROM_LOAD( "uc_w40m.rom", 0x100000, 0x080000, 0xc2961648 )
	ROM_LOAD( "uc_w41m.rom", 0x180000, 0x080000, 0xf5334b80 )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "uc_k16m.rom", 0x000000, 0x100000, 0x4a225f09 )
	ROM_LOAD( "uc_k17m.rom", 0x100000, 0x100000, 0xe4ed9a54 )
	ROM_LOAD( "uc_k18m.rom", 0x200000, 0x100000, 0xa626eb12 )
	ROM_LOAD( "uc_k19m.rom", 0x300000, 0x100000, 0x5df46549 )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "uc_w42.rom", 0x000000, 0x080000, 0xd17d3fd6 )
ROM_END

ROM_START( uccopsj )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "uca-h0.bin", 0x000001, 0x040000, 0x9e17cada )
	ROM_LOAD16_BYTE( "uca-l0.bin", 0x000000, 0x040000, 0x4a4e3208 )
	ROM_LOAD16_BYTE( "uca-h1.bin", 0x080001, 0x020000, 0x83f78dea )
	ROM_LOAD16_BYTE( "uca-l1.bin", 0x080000, 0x020000, 0x19628280 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU - encrypted V30 = NANAO custom D80001 (?) */
	ROM_LOAD16_BYTE( "uca-sh0.bin", 0x000001, 0x010000, 0xf0ca1b03 )
	ROM_LOAD16_BYTE( "uca-sl0.bin", 0x000000, 0x010000, 0xd1661723 )

	ROM_REGION( 0x200000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "uca-c0.bin", 0x000000, 0x080000, 0x6a419a36 )
	ROM_LOAD( "uca-c1.bin", 0x080000, 0x080000, 0xd703ecc7 )
	ROM_LOAD( "uca-c2.bin", 0x100000, 0x080000, 0x96397ac6 )
	ROM_LOAD( "uca-c3.bin", 0x180000, 0x080000, 0x5d07d10d )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "uca-o3.bin", 0x000000, 0x100000, 0x97f7775e )
	ROM_LOAD( "uca-o2.bin", 0x100000, 0x100000, 0x5e0b1d65 )
	ROM_LOAD( "uca-o1.bin", 0x200000, 0x100000, 0xbdc224b3 )
	ROM_LOAD( "uca-o0.bin", 0x300000, 0x100000, 0x7526daec )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "uca-da.bin", 0x000000, 0x080000, 0x0b2855e9 )
ROM_END

ROM_START( lethalth )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "lt_d-h0.rom",  0x000001, 0x020000, 0x20c68935 )
	ROM_LOAD16_BYTE( "lt_d-l0.rom",  0x000000, 0x020000, 0xe1432fb3 )
	ROM_LOAD16_BYTE( "lt_d-h1.rom",  0x040001, 0x020000, 0xd7dd3d48 )
	ROM_LOAD16_BYTE( "lt_d-l1.rom",  0x040000, 0x020000, 0xb94b3bd8 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU */
	ROM_LOAD16_BYTE( "lt_d-sh0.rom",0x000001, 0x010000, 0xaf5b224f )
	ROM_LOAD16_BYTE( "lt_d-sl0.rom",0x000000, 0x010000, 0xcb3faac3 )

	ROM_REGION( 0x100000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "lt_7a.rom", 0x000000, 0x040000, 0xada0fd50 )
	ROM_LOAD( "lt_7b.rom", 0x040000, 0x040000, 0xd2596883 )
	ROM_LOAD( "lt_7d.rom", 0x080000, 0x040000, 0x2de637ef )
	ROM_LOAD( "lt_7h.rom", 0x0c0000, 0x040000, 0x9f6585cd )

	ROM_REGION( 0x100000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "lt_7j.rom", 0x000000, 0x040000, 0xbaf8863e )
	ROM_LOAD( "lt_7l.rom", 0x040000, 0x040000, 0x40fd50af )
	ROM_LOAD( "lt_7s.rom", 0x080000, 0x040000, 0xc8e970df )
	ROM_LOAD( "lt_7y.rom", 0x0c0000, 0x040000, 0xf5436708 )

	ROM_REGION( 0x40000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "lt_8a.rom" ,0x000000, 0x040000, 0x357762a2 )
ROM_END

ROM_START( thndblst )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "lt_d-h0j.rom", 0x000001, 0x020000, 0xdc218a18 )
	ROM_LOAD16_BYTE( "lt_d-l0j.rom", 0x000000, 0x020000, 0xae9a3f81 )
	ROM_LOAD16_BYTE( "lt_d-h1.rom",  0x040001, 0x020000, 0xd7dd3d48 )
	ROM_LOAD16_BYTE( "lt_d-l1.rom",  0x040000, 0x020000, 0xb94b3bd8 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU */
	ROM_LOAD16_BYTE( "lt_d-sh0.rom",0x000001, 0x010000, 0xaf5b224f )
	ROM_LOAD16_BYTE( "lt_d-sl0.rom",0x000000, 0x010000, 0xcb3faac3 )

	ROM_REGION( 0x100000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "lt_7a.rom", 0x000000, 0x040000, 0xada0fd50 )
	ROM_LOAD( "lt_7b.rom", 0x040000, 0x040000, 0xd2596883 )
	ROM_LOAD( "lt_7d.rom", 0x080000, 0x040000, 0x2de637ef )
	ROM_LOAD( "lt_7h.rom", 0x0c0000, 0x040000, 0x9f6585cd )

	ROM_REGION( 0x100000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "lt_7j.rom", 0x000000, 0x040000, 0xbaf8863e )
	ROM_LOAD( "lt_7l.rom", 0x040000, 0x040000, 0x40fd50af )
	ROM_LOAD( "lt_7s.rom", 0x080000, 0x040000, 0xc8e970df )
	ROM_LOAD( "lt_7y.rom", 0x0c0000, 0x040000, 0xf5436708 )

	ROM_REGION( 0x40000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "lt_8a.rom" ,0x000000, 0x040000, 0x357762a2 )
ROM_END

ROM_START( nbbatman )
	ROM_REGION( 0x180000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "a1-h0-a.34",  0x000001, 0x040000, 0x24a9b794 )
	ROM_LOAD16_BYTE( "a1-l0-a.31",  0x000000, 0x040000, 0x846d7716 )
	ROM_LOAD16_BYTE( "a1-h1-.33",   0x100001, 0x040000, 0x3ce2aab5 )
	ROM_LOAD16_BYTE( "a1-l1-.32",   0x100000, 0x040000, 0x116d9bcc )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU */
	ROM_LOAD16_BYTE( "a1-sh0-.14",0x000001, 0x010000, 0xb7fae3e6 )
	ROM_LOAD16_BYTE( "a1-sl0-.17",0x000000, 0x010000, 0xb26d54fc )

	ROM_REGION( 0x200000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "lh534k0c.9",  0x000000, 0x080000, 0x314a0c6d )
	ROM_LOAD( "lh534k0e.10", 0x080000, 0x080000, 0xdc31675b )
	ROM_LOAD( "lh534k0f.11", 0x100000, 0x080000, 0xe15d8bfb )
	ROM_LOAD( "lh534k0g.12", 0x180000, 0x080000, 0x888d71a3 )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "lh538393.42", 0x000000, 0x100000, 0x26cdd224 )
	ROM_LOAD( "lh538394.43", 0x100000, 0x100000, 0x4bbe94fa )
	ROM_LOAD( "lh538395.44", 0x200000, 0x100000, 0x2a533b5e )
	ROM_LOAD( "lh538396.45", 0x300000, 0x100000, 0x863a66fa )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "lh534k0k.8" ,0x000000, 0x080000, 0x735e6380 )
ROM_END

ROM_START( leaguemn )
	ROM_REGION( 0x180000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "lma1-h0.34",  0x000001, 0x040000, 0x47c54204 )
	ROM_LOAD16_BYTE( "lma1-l0.31",  0x000000, 0x040000, 0x1d062c82 )
	ROM_LOAD16_BYTE( "a1-h1-.33",   0x100001, 0x040000, 0x3ce2aab5 )
	ROM_LOAD16_BYTE( "a1-l1-.32",   0x100000, 0x040000, 0x116d9bcc )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU */
	ROM_LOAD16_BYTE( "a1-sh0-.14",0x000001, 0x010000, 0xb7fae3e6 )
	ROM_LOAD16_BYTE( "a1-sl0-.17",0x000000, 0x010000, 0xb26d54fc )

	ROM_REGION( 0x200000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "lh534k0c.9",  0x000000, 0x080000, 0x314a0c6d )
	ROM_LOAD( "lh534k0e.10", 0x080000, 0x080000, 0xdc31675b )
	ROM_LOAD( "lh534k0f.11", 0x100000, 0x080000, 0xe15d8bfb )
	ROM_LOAD( "lh534k0g.12", 0x180000, 0x080000, 0x888d71a3 )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "lh538393.42", 0x000000, 0x100000, 0x26cdd224 )
	ROM_LOAD( "lh538394.43", 0x100000, 0x100000, 0x4bbe94fa )
	ROM_LOAD( "lh538395.44", 0x200000, 0x100000, 0x2a533b5e )
	ROM_LOAD( "lh538396.45", 0x300000, 0x100000, 0x863a66fa )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "lh534k0k.8" ,0x000000, 0x080000, 0x735e6380 )
ROM_END

ROM_START( ssoldier )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "f3-h0-h.bin",  0x000001, 0x040000, 0xb63fb9da )
	ROM_LOAD16_BYTE( "f3-l0-h.bin",  0x000000, 0x040000, 0x419361a2 )
	ROM_LOAD16_BYTE( "f3-h1-a.bin",  0x080001, 0x020000, 0xe3d9f619 )
	ROM_LOAD16_BYTE( "f3-l1-a.bin",  0x080000, 0x020000, 0x8cb5c396 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 ) /* 1MB for the audio CPU */
	ROM_LOAD16_BYTE( "f3_sh0.sh0",0x000001, 0x010000, 0x90b55e5e )
	ROM_LOAD16_BYTE( "f3_sl0.sl0",0x000000, 0x010000, 0x77c16d57 )

	ROM_REGION( 0x200000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "f3_w50.c0",  0x000000, 0x040000, 0x47e788ee )
	ROM_LOAD( "f3_w51.c1",  0x080000, 0x040000, 0x8e535e3f )
	ROM_LOAD( "f3_w52.c2",  0x100000, 0x040000, 0xa6eb2e56 )
	ROM_LOAD( "f3_w53.c3",  0x180000, 0x040000, 0x2f992807 )

	ROM_REGION( 0x800000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD16_BYTE( "f3_w37.000", 0x000001, 0x100000, 0xfd4cda03 )
	ROM_LOAD16_BYTE( "f3_w38.001", 0x000000, 0x100000, 0x755bab10 )
	ROM_LOAD16_BYTE( "f3_w39.010", 0x200001, 0x100000, 0xb21ced92 )
	ROM_LOAD16_BYTE( "f3_w40.011", 0x200000, 0x100000, 0x2e906889 )
	ROM_LOAD16_BYTE( "f3_w41.020", 0x400001, 0x100000, 0x02455d10 )
	ROM_LOAD16_BYTE( "f3_w42.021", 0x400000, 0x100000, 0x124589b9 )
	ROM_LOAD16_BYTE( "f3_w43.030", 0x600001, 0x100000, 0xdae7327a )
	ROM_LOAD16_BYTE( "f3_w44.031", 0x600000, 0x100000, 0xd0fc84ac )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "f3_w95.da" ,0x000000, 0x080000, 0xf7ca432b )
ROM_END

ROM_START( psoldier )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "f3_h0d.h0",  0x000001, 0x040000, 0x38f131fd )
	ROM_LOAD16_BYTE( "f3_l0d.l0",  0x000000, 0x040000, 0x1662969c )
	ROM_LOAD16_BYTE( "f3_h1.h1",   0x080001, 0x040000, 0xc8d1947c )
	ROM_LOAD16_BYTE( "f3_l1.l1",   0x080000, 0x040000, 0x7b9492fc )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )	/* 1MB for the audio CPU */
	ROM_LOAD16_BYTE( "f3_sh0.sh0",0x000001, 0x010000, 0x90b55e5e )
	ROM_LOAD16_BYTE( "f3_sl0.sl0",0x000000, 0x010000, 0x77c16d57 )

	ROM_REGION( 0x200000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "f3_w50.c0",  0x000000, 0x040000, 0x47e788ee )
	ROM_LOAD( "f3_w51.c1",  0x080000, 0x040000, 0x8e535e3f )
	ROM_LOAD( "f3_w52.c2",  0x100000, 0x040000, 0xa6eb2e56 )
	ROM_LOAD( "f3_w53.c3",  0x180000, 0x040000, 0x2f992807 )

	ROM_REGION( 0x800000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD16_BYTE( "f3_w37.000", 0x000001, 0x100000, 0xfd4cda03 )
	ROM_LOAD16_BYTE( "f3_w38.001", 0x000000, 0x100000, 0x755bab10 )
	ROM_LOAD16_BYTE( "f3_w39.010", 0x200001, 0x100000, 0xb21ced92 )
	ROM_LOAD16_BYTE( "f3_w40.011", 0x200000, 0x100000, 0x2e906889 )
	ROM_LOAD16_BYTE( "f3_w41.020", 0x400001, 0x100000, 0x02455d10 )
	ROM_LOAD16_BYTE( "f3_w42.021", 0x400000, 0x100000, 0x124589b9 )
	ROM_LOAD16_BYTE( "f3_w43.030", 0x600001, 0x100000, 0xdae7327a )
	ROM_LOAD16_BYTE( "f3_w44.031", 0x600000, 0x100000, 0xd0fc84ac )

	ROM_REGION( 0x80000, REGION_SOUND1, ROMREGION_SOUNDONLY )
	ROM_LOAD( "f3_w95.da" ,0x000000, 0x080000, 0xf7ca432b )
ROM_END

ROM_START( dsccr94j )
	ROM_REGION( 0x180000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE("a3_-h0-e.bin", 0x000001, 0x040000, 0x8de1dbcd )
	ROM_LOAD16_BYTE("a3_-l0-e.bin", 0x000000, 0x040000, 0xd3df8bfd )
	ROM_LOAD16_BYTE("ds_h1-c.rom",  0x100001, 0x040000, 0x6109041b )
	ROM_LOAD16_BYTE("ds_l1-c.rom",  0x100000, 0x040000, 0x97a01f6b )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )
	ROM_LOAD16_BYTE("ds_sh0.rom",   0x000001, 0x010000, 0x23fe6ffc )
	ROM_LOAD16_BYTE("ds_sl0.rom",   0x000000, 0x010000, 0x768132e5 )

	ROM_REGION( 0x400000, REGION_GFX1, ROMREGION_DISPOSE )	/* chars */
	ROM_LOAD("c0.bin",   0x000000, 0x100000, 0x83ea8a47 )
	ROM_LOAD("c1.bin",   0x100000, 0x100000, 0x64063e6d )
	ROM_LOAD("c2.bin",   0x200000, 0x100000, 0xcc1f621a )
	ROM_LOAD("c3.bin",   0x300000, 0x100000, 0x515829e1 )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE )	/* sprites */
	ROM_LOAD16_BYTE("a3-o00-w.bin",   0x000001, 0x80000, 0xb094e5ad )
	ROM_LOAD16_BYTE("a3-o01-w.bin",   0x000000, 0x80000, 0x91f34018 )
	ROM_LOAD16_BYTE("a3-o10-w.bin",   0x100001, 0x80000, 0xedddeef4 )
	ROM_LOAD16_BYTE("a3-o11-w.bin",   0x100000, 0x80000, 0x274a9526 )
	ROM_LOAD16_BYTE("a3-o20-w.bin",   0x200001, 0x80000, 0x32064393 )
	ROM_LOAD16_BYTE("a3-o21-w.bin",   0x200000, 0x80000, 0x57bae3d9 )
	ROM_LOAD16_BYTE("a3-o30-w.bin",   0x300001, 0x80000, 0xbe838e2f )
	ROM_LOAD16_BYTE("a3-o31-w.bin",   0x300000, 0x80000, 0xbf899f0d )

	ROM_REGION( 0x100000, REGION_SOUND1, 0 )
	ROM_LOAD("ds_da0.rom" ,  0x000000, 0x100000, 0x67fc52fd )
ROM_END

ROM_START( gunforc2 )
	ROM_REGION( 0x180000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE("a2-h0-a.6h", 0x000001, 0x040000, 0x49965e22 )
	ROM_LOAD16_BYTE("a2-l0-a.8h", 0x000000, 0x040000, 0x8c88b278 )
	ROM_LOAD16_BYTE("a2-h1-a.6f", 0x100001, 0x040000, 0x34280b88 )
	ROM_LOAD16_BYTE("a2-l1-a.8f", 0x100000, 0x040000, 0xc8c13f51 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )
	ROM_LOAD16_BYTE("a2_sho.3l",   0x000001, 0x010000, 0x2e2d103d )
	ROM_LOAD16_BYTE("a2_slo.5l",   0x000000, 0x010000, 0x2287e0b3 )

	ROM_REGION( 0x200000, REGION_GFX1, ROMREGION_DISPOSE )	/* chars */
	ROM_LOAD("a2_c0.1a",   0x000000, 0x080000, 0x68b8f574 )
	ROM_LOAD("a2_c1.1b",   0x080000, 0x080000, 0x0b9efe67 )
	ROM_LOAD("a2_c2.3a",   0x100000, 0x080000, 0x7a9e9978 )
	ROM_LOAD("a2_c3.3b",   0x180000, 0x080000, 0x1395ee6d )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "a2_000.8a", 0x000000, 0x100000, 0x38e03147 )
	ROM_LOAD( "a2_010.8b", 0x100000, 0x100000, 0x1d5b05f8 )
	ROM_LOAD( "a2_020.8c", 0x200000, 0x100000, 0xf2f461cc )
	ROM_LOAD( "a2_030.8d", 0x300000, 0x100000, 0x97609d9d )

	ROM_REGION( 0x100000, REGION_SOUND1, 0 )
	ROM_LOAD("a2_da.1l" ,  0x000000, 0x100000, 0x3c8cdb6a )
ROM_END

ROM_START( geostorm )
	ROM_REGION( 0x180000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE("geo-h0.bin", 0x000001, 0x040000, 0x9be58d09 )
	ROM_LOAD16_BYTE("geo-l0.bin", 0x000000, 0x040000, 0x59abb75d )
	ROM_LOAD16_BYTE("a2-h1-a.6f", 0x100001, 0x040000, 0x34280b88 )
	ROM_LOAD16_BYTE("a2-l1-a.8f", 0x100000, 0x040000, 0xc8c13f51 )

	ROM_REGION( 0x100000 * 2, REGION_CPU2, 0 )
	ROM_LOAD16_BYTE("a2_sho.3l",   0x000001, 0x010000, 0x2e2d103d )
	ROM_LOAD16_BYTE("a2_slo.5l",   0x000000, 0x010000, 0x2287e0b3 )

	ROM_REGION( 0x200000, REGION_GFX1, ROMREGION_DISPOSE )	/* chars */
	ROM_LOAD("a2_c0.1a",   0x000000, 0x080000, 0x68b8f574 )
	ROM_LOAD("a2_c1.1b",   0x080000, 0x080000, 0x0b9efe67 )
	ROM_LOAD("a2_c2.3a",   0x100000, 0x080000, 0x7a9e9978 )
	ROM_LOAD("a2_c3.3b",   0x180000, 0x080000, 0x1395ee6d )

	ROM_REGION( 0x400000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "a2_000.8a", 0x000000, 0x100000, 0x38e03147 )
	ROM_LOAD( "a2_010.8b", 0x100000, 0x100000, 0x1d5b05f8 )
	ROM_LOAD( "a2_020.8c", 0x200000, 0x100000, 0xf2f461cc )
	ROM_LOAD( "a2_030.8d", 0x300000, 0x100000, 0x97609d9d )

	ROM_REGION( 0x100000, REGION_SOUND1, 0 )
	ROM_LOAD("a2_da.1l" ,  0x000000, 0x100000, 0x3c8cdb6a )
ROM_END

ROM_START( crossbld )
	ROM_REGION( 0x100000, REGION_CPU1, 0 )
	ROM_LOAD16_BYTE( "bm_d-h0.3h", 0x000001, 0x40000, 0xa28a5821 )
	ROM_LOAD16_BYTE( "bm_d-l0.5h", 0x000000, 0x40000, 0xa504f1a0 )
	ROM_LOAD16_BYTE( "bm_d-h1.3e", 0x080001, 0x10000, 0x18da6c47 )
	ROM_LOAD16_BYTE( "bm_d-l1.5e", 0x080000, 0x10000, 0xa65c1b42 )

	ROM_REGION( 0x100000, REGION_CPU2, 0 )
	ROM_LOAD16_BYTE( "bm_d-sh0.rom", 0x000001, 0x10000, 0x9f7c075b )
	ROM_LOAD16_BYTE( "bm_d-sl0.rom", 0x000000, 0x10000, 0x1fa87c89 )

	ROM_REGION( 0x100000, REGION_GFX1, ROMREGION_DISPOSE ) /* Tiles */
	ROM_LOAD( "bm_c0.rom", 0x000000, 0x40000, 0x2cc966b8 )
	ROM_LOAD( "bm_c1.rom", 0x040000, 0x40000, 0x46df773e )
	ROM_LOAD( "bm_c2.rom", 0x080000, 0x40000, 0x05b867bd )
	ROM_LOAD( "bm_c3.rom", 0x0c0000, 0x40000, 0x0a2227a4 )

	ROM_REGION( 0x200000, REGION_GFX2, ROMREGION_DISPOSE ) /* Sprites */
	ROM_LOAD( "bm_000.rom", 0x000000, 0x80000, 0x339fc9f3 )
	ROM_LOAD( "bm_010.rom", 0x080000, 0x80000, 0x6a14377d )
	ROM_LOAD( "bm_020.rom", 0x100000, 0x80000, 0x31532198 )
	ROM_LOAD( "bm_030.rom", 0x180000, 0x80000, 0xd1a041d3 )

	ROM_REGION( 0x80000, REGION_SOUND1, 0 )
	ROM_LOAD( "bm_da.rom", 0x000000, 0x80000, 0x62ce5798 )
ROM_END

/***************************************************************************/

static void m92_startup(int hasbanks)
{
	unsigned char *RAM = memory_region(REGION_CPU1);

	if (hasbanks)
	{
		memcpy(RAM+0xffff0,RAM+0x7fff0,0x10); /* Start vector */
		bankaddress = 0xa0000; /* Initial bank */
		set_m92_bank();

		/* Mirror used by In The Hunt for protection */
		memcpy(RAM+0xc0000,RAM+0x00000,0x10000);
		cpu_setbank(2,&RAM[0xc0000]);
	}

	RAM = memory_region(REGION_CPU2);
	memcpy(RAM+0xffff0,RAM+0x1fff0,0x10); /* Sound cpu Start vector */

	m92_game_kludge=0;
	m92_irq_vectorbase=0x80;
	m92_raster_enable=1;
	m92_sprite_buffer_busy=0x80;
}

static void init_m92(const unsigned char *decryption_table, int hasbanks)
{
	m92_startup(hasbanks);
	setvector_callback(VECTOR_INIT);
	irem_cpu_decrypt(1,decryption_table);

	state_save_register_UINT8 ("main", 0, "irqvector",    &irqvector,    1);
	state_save_register_UINT16("main", 0, "sound_status", &sound_status, 1);
	state_save_register_UINT32("main", 0, "bankaddress",  &bankaddress,  1);
	state_save_register_func_postload(set_m92_bank);
}

static DRIVER_INIT( bmaster )
{
	init_m92(bomberman_decryption_table, 1);
}

static DRIVER_INIT( gunforce )
{
	init_m92(gunforce_decryption_table, 1);
}

static DRIVER_INIT( hook )
{
	init_m92(hook_decryption_table, 1);
}

static DRIVER_INIT( mysticri )
{
	init_m92(mysticri_decryption_table, 1);
}

static DRIVER_INIT( uccops )
{
	init_m92(dynablaster_decryption_table, 1);
}

static DRIVER_INIT( rtypeleo )
{
	init_m92(rtypeleo_decryption_table, 1);
	m92_irq_vectorbase=0x20;
}

static DRIVER_INIT( rtypelej )
{
	init_m92(rtypeleo_decryption_table, 1);
	m92_irq_vectorbase=0x20;
}

static DRIVER_INIT( majtitl2 )
{
	init_m92(majtitl2_decryption_table, 1);

	/* This game has an eprom on the game board */
	install_mem_read_handler(0, 0xf0000, 0xf3fff, m92_eeprom_r);
	install_mem_write_handler(0, 0xf0000, 0xf3fff, m92_eeprom_w);

	m92_game_kludge=2;
}

static DRIVER_INIT( kaiteids )
{
	init_m92(inthunt_decryption_table, 1);
}

static DRIVER_INIT( inthunt )
{
	init_m92(inthunt_decryption_table, 1);
}

static DRIVER_INIT( lethalth )
{
	init_m92(lethalth_decryption_table, 0);
	m92_irq_vectorbase=0x20;

	/* This game sets the raster IRQ position, but the interrupt routine
        is just an iret, no need to emulate it */
	m92_raster_enable=0;
	m92_game_kludge=3; /* No upper palette bank? It could be a different motherboard */
}

static DRIVER_INIT( nbbatman )
{
	unsigned char *RAM = memory_region(REGION_CPU1);

	init_m92(leagueman_decryption_table, 1);

	memcpy(RAM+0x80000,RAM+0x100000,0x20000);
}

static DRIVER_INIT( ssoldier )
{
	init_m92(psoldier_decryption_table, 1);
	m92_irq_vectorbase=0x20;
	/* main CPU expects an answer even before writing the first command */
	sound_status = 0x80;
}

static DRIVER_INIT( psoldier )
{
	init_m92(psoldier_decryption_table, 1);
	m92_irq_vectorbase=0x20;
	/* main CPU expects an answer even before writing the first command */
	sound_status = 0x80;
}

static DRIVER_INIT( dsccr94j )
{
	init_m92(dsoccr94_decryption_table, 1);
}

static DRIVER_INIT( gunforc2 )
{
	unsigned char *RAM = memory_region(REGION_CPU1);
	init_m92(lethalth_decryption_table, 1);
	memcpy(RAM+0x80000,RAM+0x100000,0x20000);
}

/***************************************************************************/

/* The 'nonraster' machine is for games that don't use the raster interrupt feature - slightly faster to emulate */
GAME( 1991, gunforce, 0,        raster,    gunforce, gunforce, ROT0,   "Irem",         "Gunforce - Battle Fire Engulfed Terror Island (World)" )
GAME( 1991, gunforcj, gunforce, raster,    gunforce, gunforce, ROT0,   "Irem",         "Gunforce - Battle Fire Engulfed Terror Island (Japan)" )
GAME( 1991, gunforcu, gunforce, raster,    gunforce, gunforce, ROT0,   "Irem America", "Gunforce - Battle Fire Engulfed Terror Island (US)" )
GAME( 1991, bmaster,  0,        nonraster, bmaster,  bmaster,  ROT0,   "Irem",         "Blade Master (World)" )
GAME( 1991, crossbld, bmaster,  nonraster, bmaster,  bmaster,  ROT0,   "Irem",         "Cross Blades! (Japan)" )
GAME( 1991, lethalth, 0,        lethalth,  lethalth, lethalth, ROT270, "Irem",         "Lethal Thunder (World)" )
GAME( 1991, thndblst, lethalth, lethalth,  lethalth, lethalth, ROT270, "Irem",         "Thunder Blaster (Japan)" )
GAME( 1992, uccops,   0,        raster,    uccops,   uccops,   ROT0,   "Irem",         "Undercover Cops (World)" )
GAME( 1992, uccopsj,  uccops,   raster,    uccops,   uccops,   ROT0,   "Irem",         "Undercover Cops (Japan)" )
GAME( 1992, mysticri, 0,        nonraster, mysticri, mysticri, ROT0,   "Irem",         "Mystic Riders (World)" )
GAME( 1992, gunhohki, mysticri, nonraster, mysticri, mysticri, ROT0,   "Irem",         "Gun Hohki (Japan)" )
GAMEX(1992, majtitl2, 0,        raster,    majtitl2, majtitl2, ROT0,   "Irem",         "Major Title 2 (World)", GAME_IMPERFECT_GRAPHICS )
GAMEX(1992, skingame, majtitl2, raster,    majtitl2, majtitl2, ROT0,   "Irem America", "The Irem Skins Game (US set 1)", GAME_IMPERFECT_GRAPHICS )
GAMEX(1992, skingam2, majtitl2, raster,    majtitl2, majtitl2, ROT0,   "Irem America", "The Irem Skins Game (US set 2)", GAME_IMPERFECT_GRAPHICS )
GAME( 1992, hook,     0,        nonraster, hook,     hook,     ROT0,   "Irem",         "Hook (World)" )
GAME( 1992, hooku,    hook,     nonraster, hook,     hook,     ROT0,   "Irem America", "Hook (US)" )
GAME( 1992, hookj,    hook,     nonraster, hook,     hook,     ROT0,   "Irem",         "Hook (Japan)" )
GAME( 1992, rtypeleo, 0,        raster,    rtypeleo, rtypeleo, ROT0,   "Irem",         "R-Type Leo (World rev. C)" )
GAME( 1992, rtypelej, rtypeleo, raster,    rtypeleo, rtypelej, ROT0,   "Irem",         "R-Type Leo (Japan rev. D)" )
GAME( 1993, inthunt,  0,        raster,    inthunt,  inthunt,  ROT0,   "Irem",         "In The Hunt (World)" )
GAME( 1993, inthuntu, inthunt,  raster,    inthunt,  inthunt,  ROT0,   "Irem America", "In The Hunt (US)" )
GAME( 1993, kaiteids, inthunt,  raster,    inthunt,  kaiteids, ROT0,   "Irem",         "Kaitei Daisensou (Japan)" )
GAMEX(1993, nbbatman, 0,        raster,    nbbatman, nbbatman, ROT0,   "Irem America", "Ninja Baseball Batman (US)", GAME_IMPERFECT_GRAPHICS )
GAMEX(1993, leaguemn, nbbatman, raster,    nbbatman, nbbatman, ROT0,   "Irem",         "Yakyuu Kakutou League-Man (Japan)", GAME_IMPERFECT_GRAPHICS )
GAMEX(1993, ssoldier, 0,  psoldier,  psoldier, ssoldier, ROT0,   "Irem America", "Superior Soldiers (US)", GAME_IMPERFECT_SOUND )
GAMEX(1993, psoldier, ssoldier, psoldier,  psoldier, psoldier, ROT0,   "Irem",         "Perfect Soldiers (Japan)", GAME_IMPERFECT_SOUND )
GAME( 1994, dsccr94j, dsoccr94, psoldier,  dsccr94j, dsccr94j, ROT0,   "Irem",         "Dream Soccer '94 (Japan)" )
GAME( 1994, gunforc2, 0,        raster,    gunforc2, gunforc2, ROT0,   "Irem",         "Gunforce 2 (US)" )
GAME( 1994, geostorm, gunforc2, raster,    gunforc2, gunforc2, ROT0,   "Irem",         "Geostorm (Japan)" )
