/*********************************************************************

  usrintrf.h

  Functions used to handle MAME's crude user interface.

*********************************************************************/

#ifndef USRINTRF_H
#define USRINTRF_H

struct DisplayText
{
	const char *text;	/* 0 marks the end of the array */
	int color;	/* see #defines below */
	int x;
	int y;
};

#define UI_COLOR_NORMAL 0	/* white on black text */
#define UI_COLOR_INVERSE 1	/* black on white text */
#ifdef UI_TITLE_MENU
#define UI_COLOR_BOLD  2	/* white bold text */ //Ƃ肠ǉ
#define UI_COLOR_BLACK 3	/* black bold text */ //command.list̐FɕKv
#endif /* UI_TITLE_MENU */

#ifdef KAILLERA
#define UI_COLOR_TRANS            0x02	/* white text only */
#define UI_COLOR_ATTRIBUTE        0x04	/* for IME */
#define UI_COLOR_BLEND			0x05	/*  Back  łȂ΍ */
#define UI_COLOR_BACKBLACK		0x06	/* white on black text */
#define UI_COLOR_MESH			0x07
#define UI_COLOR_SHADOW			0x08
#define UI_COLOR_FRAME			0x09
#define UI_COLOR_FRAME_2		0x0a
#define UI_COLOR_FRAME_3		0x0b

#define UI_COLOR_MASK             0x0f
#define UI_UNDERLINE              0x10
#define UI_UNDERLINE_BOLD         0x20
#define UI_UNDERLINE_DOT          0x40

#define UI_UNDERLINE_INVERSE      (UI_UNDERLINE | UI_COLOR_INVERSE)
#define UI_UNDERLINE_DOT_INVERSE  (UI_UNDERLINE_DOT | UI_COLOR_INVERSE)
#define UI_UNDERLINE_BOLD_INVERSE (UI_UNDERLINE_BOLD | UI_COLOR_INVERSE)
#endif /* KAILLERA */

#define SEL_BITS 12		/* main menu selection mask */
#define SEL_BITS2 4		/* submenu selection masks */
#define SEL_MASK ((1<<SEL_BITS)-1)
#define SEL_MASK2 ((1<<SEL_BITS2)-1)

#ifdef MAME32JP
#define SCR_PAGE_MASK  0xffffff
#define SCR_NEXT_PAGE  0x1000000
#define SCR_PREV_PAGE  0x10000000
#endif

struct GfxElement *builduifont(void);
void pick_uifont_colors(void);
void displaytext(struct mame_bitmap *bitmap,const struct DisplayText *dt);
void ui_text(struct mame_bitmap *bitmap,const char *buf,int x,int y);
#ifdef UI_COLOR_DISPLAY
void ui_text_nobk(struct mame_bitmap *bitmap,const char *buf,int x,int y);
#endif /* UI_COLOR_DISPLAY */
void displaytext_shadow(struct mame_bitmap *bitmap,const struct DisplayText *dt);
void ui_drawbox(struct mame_bitmap *bitmap,int leftx,int topy,int width,int height);
#ifdef MAME32JP
 #ifdef UI_TITLE_MENU
  int ui_displaymessagewindow(struct mame_bitmap *bitmap,const char *text,const char *title);
 #else /* UI_TITLE_MENU */
  int ui_displaymessagewindow(struct mame_bitmap *bitmap,const char *text);
 #endif /* UI_TITLE_MENU */
#else
void ui_displaymessagewindow(struct mame_bitmap *bitmap,const char *text);
#endif

#ifdef UI_TITLE_MENU
void ui_displaymenu(struct mame_bitmap *bitmap,const char **items,const char **subitems,char *flag,const char *title,int selected,int arrowize_subitem);
#else /* UI_TITLE_MENU */
void ui_displaymenu(struct mame_bitmap *bitmap,const char **items,const char **subitems,char *flag,int selected,int arrowize_subitem);
#endif /* UI_TITLE_MENU */

int showcopyright(struct mame_bitmap *bitmap);
int showgamewarnings(struct mame_bitmap *bitmap);
#ifdef MAME32JP //FOXMAME32JK
int showgameinfo(struct mame_bitmap *bitmap);
#endif
void set_ui_visarea (int xmin, int ymin, int xmax, int ymax);

void init_user_interface(void);
int handle_user_interface(struct mame_bitmap *bitmap);

int onscrd_active(void);
int setup_active(void);

void switch_ui_orientation(struct mame_bitmap *bitmap);
void switch_true_orientation(struct mame_bitmap *bitmap);

void CLIB_DECL usrintf_showmessage(const char *text,...);
void CLIB_DECL usrintf_showmessage_secs(int seconds, const char *text,...);
#ifdef MAME32JP
void CLIB_DECL usrintf_showmessage_frames(int frames, const char *text, ...);
#endif
#define popmessage usrintf_showmessage

#ifdef KAILLERA
void ui_drawmeshbox(struct mame_bitmap *bitmap,int leftx,int topy,int width,int height);
void ui_drawline(struct mame_bitmap *bitmap,int leftx,int y,int width,int linemode);

int	quiting;
#endif /* KAILLERA */

#endif
