using System;
using System.Reflection;
using System.Collections;
using System.Runtime.Remoting.Proxies;
using System.Runtime.Remoting.Messaging;

using AttoContainer.Aop.Interceptor;

namespace AttoContainer.Aop
{
	/// <summary>
	/// AopProxy
	/// </summary>
	public class AopProxy : RealProxy
	{
		object target;
		IAspect[] aspects;
		Type type;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="type">Aspect^[QbgĂC^[tF[X</param>
		/// <param name="target">Aspect^[Qbg</param>
		/// <param name="aspects">KAspect</param>
		public AopProxy(Type type, object target,IAspect[] aspects) : base(type) 
		{
			if(type==null) throw new NullReferenceException("type");
			if(target==null) throw new NullReferenceException("target");
			if(aspects==null) throw new NullReferenceException("aspects");
			this.type = type;
			this.target = target;
			this.aspects = aspects;
		}

		/// <summary>
		/// AopProxyʂIuWFNg̃\bhsƂ̃\bhĂ΂܂
		/// </summary>
		/// <param name="msg">IMessage</param>
		/// <returns>IMessage</returns>
		public override IMessage Invoke(IMessage msg) 
		{
			IMethodMessage methodMessage = msg as IMethodMessage;
			MethodInfo methodInfo = type.GetMethod(methodMessage.MethodName);
			if(methodInfo == null) methodInfo = target.GetType().GetMethod(methodMessage.MethodName);
			ArrayList interceptorList = new ArrayList();

			// `ꂽAspectInterceptor̃Xg̍쐬
			foreach(IAspect aspect in aspects)
			{
				IPointcut pointcut = aspect.Pointcut;
				// PointcutAdvice(Interceptor)}邩mF
				if(pointcut.IsApplied(methodInfo)) 
				{
					// AspectKpꍇ
					interceptorList.Add(aspect.MethodInterceptor);
				}
			}

			Object ret = null;

			if(interceptorList.Count == 0)
			{
				// Interceptor}Ȃꍇ
				ret = methodInfo.Invoke(target,methodMessage.Args);
			}
			else
			{
				// Interceptor}ꍇ
				IMethodInterceptor[] interceptors = (IMethodInterceptor[])interceptorList.ToArray(typeof(IMethodInterceptor));
				IMethodInvocation invocation = new MethodInvocation(target,methodInfo,methodMessage.Args,interceptors);
				ret = interceptors[0].Invoke(invocation);
			}

			return new ReturnMessage(ret, null, 0, 
				methodMessage.LogicalCallContext, (IMethodCallMessage)msg);

		}
	}
}
