using System;
using System.Reflection;
using System.Text;

namespace AttoContainer.Aop.Interceptor
{
	/// <summary>
	/// \bh̎sԂv܂
	/// </summary>
	public class TimeMeasureInterceptor : IMethodInterceptor
	{
		#region IMethodInterceptor o

		public object Invoke(IMethodInvocation invocation)
		{
			MethodInfo mi = invocation.MethodInfo;
			StringBuilder sb = new StringBuilder();
			sb.Append(mi.DeclaringType.FullName);
			sb.Append("#");
			sb.Append(mi.Name);
			DateTime dateTime1 = DateTime.Now;
			Console.WriteLine("BEGIN " + sb.ToString() + " " + dateTime1.ToString("yyyy/MM/dd HH:mm:ss.fff"));
			Object ret = invocation.Proceed();
			DateTime dateTime2 = DateTime.Now;
			sb.Append(" ");
			sb.Append(dateTime2.ToString("yyyy/MM/dd HH:mm:ss.fff"));
			sb.Append(" (");
			TimeSpan span = dateTime2 - dateTime1;
			sb.Append(span.Milliseconds);
			sb.Append("ms)");
			Console.WriteLine("END " + sb.ToString());
			return ret;
		}

		#endregion
	}
}
