using System;
using System.Text;
using System.Reflection;

namespace AttoContainer.Aop.Interceptor
{
	/// <summary>
	/// s郁\bh̊JnɃ\bhAB
	/// s郁\bh̏IɃ\bhA߂l̃Oo͂܂
	/// </summary>
	public class TraceInterceptor : IMethodInterceptor
	{

		#region IMethodInterceptor o

		public object Invoke(IMethodInvocation invocation)
		{
			MethodInfo mi = invocation.MethodInfo;
			StringBuilder sb = new StringBuilder();
			sb.Append(mi.DeclaringType.FullName);
			sb.Append("#");
			sb.Append(mi.Name);
			sb.Append("(");
			object[] args = invocation.Arguments;
			if(args != null && args.Length > 0)
			{
				for(int i=0;i<args.Length;i++)
				{
					sb.Append(args[i]);
					sb.Append(", ");
				}
				sb.Length = sb.Length -2;
			}
			sb.Append(")");
			Console.WriteLine("BEGIN " + sb.ToString());
			Object ret = invocation.Proceed();
			sb.Append(" : ");
			sb.Append(ret);
			Console.WriteLine("END " + sb.ToString());
			return ret;
		}

		#endregion
	}
}
