#cs #INDEX# --------------------------------------------------------------------

 Title         : autest_listener
 Author        : Takazumi Shirayanagi

 Copyright (C) 2013, Takazumi Shirayanagi
 The new BSD License is applied to this software.
 see LICENSE

#ce ----------------------------------------------------------------------------

#include-once

#include "autest_xml_generator.au3"

#cs #VARIABLE# -----------------------------------------------------------------
#ce ----------------------------------------------------------------------------

#cs #INCLUDE# ------------------------------------------------------------------
#ce ----------------------------------------------------------------------------

#cs #CURRENT# ------------------------------------------------------------------
 * @brief	ASSETION FUNCTION
 * @public
#ce ----------------------------------------------------------------------------

#cs #INTERNAL_USE_ONLY# --------------------------------------------------------
 * @private
 * Autest_OnTestStart
 * Autest_OnTestPartResult
 * Autest_OnTestEnd
 * Autest_OnTestProgramEnd
#ce ----------------------------------------------------------------------------
;
; Autest_OnTestStart
;
Func Autest_OnTestStart($testcase, $testname)
	Autest_ConsoleColorPrint($AUTEST_COLOR_GREEN, "[ RUN      ] ")
	ConsoleWrite($testcase)
	ConsoleWrite(".")
	ConsoleWrite($testname)
	ConsoleWrite(@CRLF)
EndFunc

;
; Autest_OnTestPartResult
;
Func Autest_OnTestPartResult($result, $msg)
	IF Not $result Then
		Autest_ConsolePrintLn($msg)
	EndIf
EndFunc

;
; Autest_OnTestEnd
;
Func Autest_OnTestEnd($testcase, $testname)
EndFunc

;
; Autest_OnTestProgramEnd
;
Func Autest_OnTestProgramEnd()
	Autest_DefaultXmlGenerator_OnTestProgramEnd()
EndFunc
