#cs #INDEX# --------------------------------------------------------------------

 Title         : autest_listener
 Author        : Takazumi Shirayanagi

 Copyright (C) 2013, Takazumi Shirayanagi
 The new BSD License is applied to this software.
 see LICENSE

#ce ----------------------------------------------------------------------------

#include-once

#include "autest_xml_generator.au3"

#cs #VARIABLE# -----------------------------------------------------------------
#ce ----------------------------------------------------------------------------

#cs #INCLUDE# ------------------------------------------------------------------
#ce ----------------------------------------------------------------------------

#cs #CURRENT# ------------------------------------------------------------------
 * @brief	ASSETION FUNCTION
 * @public
#ce ----------------------------------------------------------------------------

#cs #INTERNAL_USE_ONLY# --------------------------------------------------------
 * @private
 * Autest_OnTestProgramStart
 * Autest_OnTestCaseStart
 * Autest_OnTestStart
 * Autest_OnTestPartResult
 * Autest_OnTestEnd
 * Autest_OnTestCaseEnd
 * Autest_OnTestProgramEnd
#ce ----------------------------------------------------------------------------
;
; Autest_OnTestProgramStart
;
Func Autest_OnTestProgramStart()
	Autest_ConsoleColorPrint($AUTEST_COLOR_GREEN, "[==========] ")
	Local $testcase_count = Autest_GetTestCaseCount()
	Local $test_count = Autest_GetTotalTestCount()
	ConsoleWrite("Running " & String($test_count) & " tests from " & String($testcase_count) & " test cases.")
	ConsoleWrite(@CRLF)
EndFunc

;
; Autest_OnTestCaseStart
;
Func Autest_OnTestCaseStart($testcase)
	Autest_ConsoleColorPrint($AUTEST_COLOR_GREEN, "[----------] ")
	Local $testcase_name = DllStructGetData($testcase, "name")
	Local $num = DllStructGetData($testcase, "num")
	ConsoleWrite(String($num))
	ConsoleWrite(" tests from " & $testcase_name)
	ConsoleWrite(@CRLF)
EndFunc

;
; Autest_OnTestStart
;
Func Autest_OnTestStart($testcase, $testinfo)
	Local $testname = AutestTestInfo_GetName($testinfo)
	Autest_ConsoleColorPrint($AUTEST_COLOR_GREEN, "[ RUN      ] ")
	ConsoleWrite($testcase)
	ConsoleWrite(".")
	ConsoleWrite($testname)
	ConsoleWrite(@CRLF)
EndFunc

;
; Autest_OnTestPartResult
;
Func Autest_OnTestPartResult($result, $msg)
	IF Not $result Then
		Autest_ConsolePrintLn($msg)
	EndIf
EndFunc

;
; Autest_OnTestEnd
;
Func Autest_OnTestEnd($testcase, $testinfo)
	Local $testname = AutestTestInfo_GetName($testinfo)
	IF AutestTestInfo_GetResult($testinfo) Then
		Autest_ConsoleColorPrint($AUTEST_COLOR_GREEN, "[       OK ] ")
	Else
		Autest_ConsoleColorPrint($AUTEST_COLOR_RED  , "[  FAILED  ] ")
	EndIf
	ConsoleWrite($testcase)
	ConsoleWrite(".")
	ConsoleWrite($testname)
	ConsoleWrite(@CRLF)
EndFunc

;
; Autest_OnTestCaseEnd
;
Func Autest_OnTestCaseEnd($testcase)
	Autest_ConsoleColorPrint($AUTEST_COLOR_GREEN, "[----------] ")
	Local $testcase_name = DllStructGetData($testcase, "name")
	Local $num = DllStructGetData($testcase, "num")
	ConsoleWrite(String($num))
	ConsoleWrite(" tests from " & $testcase_name)
	ConsoleWrite(@CRLF)
	ConsoleWrite(@CRLF)
EndFunc

;
; Autest_OnTestProgramEnd
;
Func Autest_OnTestProgramEnd()
	Autest_DefaultXmlGenerator_OnTestProgramEnd()
EndFunc
