#cs #INDEX# --------------------------------------------------------------------

 Title         : autest_testcase
 Author        : Takazumi Shirayanagi

 Copyright (C) 2013, Takazumi Shirayanagi
 The new BSD License is applied to this software.
 see LICENSE

#ce ----------------------------------------------------------------------------

#include-once

#include "autest_testinfo.au3"

#cs #VARIABLE# -----------------------------------------------------------------
#ce ----------------------------------------------------------------------------

#cs #INCLUDE# ------------------------------------------------------------------
#ce ----------------------------------------------------------------------------

#cs #CURRENT# ------------------------------------------------------------------
 * @brief	ASSETION FUNCTION
 * @public
 * AutestTestCase_GetTotalTestCount
 * AutestTestCase_GetFatalTestCount
 * AutestTestCase_GetElapsedTime
#ce ----------------------------------------------------------------------------

;
; AutestTestCase_GetTotalTestCount
;
Func AutestTestCase_GetTotalTestCount($testcase)
	Local $num = DllStructGetData($testcase, "num")
	Return $num
EndFunc

;
; AutestTestCase_GetFatalTestCount
;
Func AutestTestCase_GetFatalTestCount($testcase)
	Local $count = 0
	Local $num = DllStructGetData($testcase, "num")-1
	Local $curr = DllStructGetData($testcase, "testinfo")
	For $I=0 To $num
		Local $result =  AutestTestInfo_GetResult($curr)
		IF Not $result Then
			$count += 1
		EndIf
		$curr = Autest_GetNextTestInfo($curr)
	Next
	Return $count
EndFunc

;
; AutestTestInfo_GetElapsedTime
;
Func AutestTestCase_GetElapsedTime($testcase)
	Return DllStructGetData($testcase, "elapsed_msec")
EndFunc

#cs #INTERNAL_USE_ONLY# --------------------------------------------------------
 * @private
 * Autest_GetTestCases
 * Autest_GetTestCaseCount
 * Autest_AddTestCase
 * Autest_GetTests
 * Autest_AddTest
 * Autest_OnTestStart
 * Autest_RunTest
#ce ----------------------------------------------------------------------------

;
; AutestTestCase_GetCases
;
Func Autest_GetTestCases()
	IF Not IsDeclared("autest_testcases") Then
		Global $autest_testcases[1]
	EndIf
	Return $autest_testcases
EndFunc

;
; Autest_GetTestCaseCount
;
Func Autest_GetTestCaseCount()
	Return UBound(Autest_GetTestCases()) - 1
EndFunc

;
; Autest_AddTestCase
;
Func Autest_AddTestCase(ByRef $testcase, $testcase_name)
	IF Not IsDeclared("autest_testcases") Then
		Global $autest_testcases[1]
	EndIf
	Local $elem = UBound($autest_testcases)
	Local $find_test_case = Autest_FindTestCase($testcase_name)
	IF $find_test_case Then
		$testcase = Autest_CastToTestCase($find_test_case)
		Return
	Else
		ReDim $autest_testcases[$elem+1]
		Local $tmp = DllStructCreate(Autest_GetTestCaseDllStructString())
		DllStructSetData($tmp, "name", $testcase_name)
		DllStructSetData($tmp, "testinfo", 0)
		DllStructSetData($tmp, "num", 0)
		DllStructSetData($tmp, "elapsed_msec", 0)
		$autest_testcases[$elem-1] = $tmp
		$testcase = $autest_testcases[$elem-1]
	EndIf
EndFunc

;
; Autest_FindTestCase
;
Func Autest_FindTestCase($testcase_name)
	IF Not IsDeclared("autest_testcases") Then
		Global $autest_testcases[1]
	EndIf
	Local $elem = UBound($autest_testcases)-2
	For $I = 0 To $elem
		Local $testcase = $autest_testcases[$I]
		Local $name = DllStructGetData($testcase, "name")
		IF StringCompare($name, $testcase_name) == 0 Then
			Return DllStructGetPtr($autest_testcases[$I])
		EndIf
	Next
	Return Ptr(0)
EndFunc

;
; Autest_GetTests
;
Func Autest_GetTests()
	IF Not IsDeclared("autest_tests") Then
		Global $autest_tests[1]
	EndIf
	Return $autest_tests
EndFunc

;
; Autest_AddTest
;
Func Autest_AddTest($testcase_name, $testname)
	IF Not IsDeclared("autest_tests") Then
		Global $autest_tests[1]
	EndIf

	Local $testcase
	Autest_AddTestCase($testcase, $testcase_name)
	Autest_AddTestInfo($testcase, $testname)

;	Local $testfullname = Autest_MakeTestFuncName($testcase_name, $testname)
;	Local $elem = UBound($autest_tests)
;	For $I = 0 To $elem-1
;		IF StringCompare($autest_tests[$I], $testfullname) == 0 Then
;			Return
;		EndIf
;	Next
;	ReDim $autest_tests[$elem+1]
;	$autest_tests[$elem-1] = $testfullname
EndFunc

;
; Autest_RunTestCase
;
Func Autest_RunTestCase($testcase_ptr)
	Local $testcase = $testcase_ptr
	Autest_OnTestCaseStart($testcase)
	Local $curr = DllStructGetData($testcase, "testinfo")
	Local $num = DllStructGetData($testcase, "num")-1
	Local $tm = TimerInit()
	For $I=0 To $num
		Autest_RunTestInfo($testcase, $curr)
		$curr = Autest_GetNextTestInfo($curr)
	Next
	Local $diff = TimerDiff($tm)
	DllStructSetData($testcase, "elapsed_msec", $diff)
	Autest_OnTestCaseEnd($testcase)
EndFunc

;
; Autest_CastToTestCase
;
Func Autest_CastToTestCase(ByRef $info)
	IF IsDllStruct($info) Then
		Return $info
	Else
		Local $testcase = DllStructCreate( Autest_GetTestCaseDllStructString(), $info)
		IF @error Then Autest_ConsolePrintLn("Autest_CastToTestCase: Failed " & @error)
		Return $testcase
	EndIf
EndFunc

;
; Autest_GetTestCaseDllStructString
;
Func Autest_GetTestCaseDllStructString()
	Local $str = "char name[256]; ptr testinfo; int num; int elapsed_msec;"
	Return $str
EndFunc
