#include	<stdio.h>
#include	<string.h>
#include	<netinet/in.h>
#include	<sys/ipc.h>
#include	<sys/msg.h>
#include	<mqueue.h>
#include	"dsgwd_pi.h"
#include	"node.h"

char	PTT_On;

extern	struct usb_dev_handle *udev;	

char	ConnectedMsg[13][12] = {
		{0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x2d,0x16},
		{0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x30,0x0c,0xdc},
		{0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x3e,0x01,0xd6},
		{0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x31,0x0c,0xc7},
		{0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x35,0x0b,0xb3},
		{0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x32,0x62,0xb3},
		{0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x22,0x0a,0xd5},
		{0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x33,0x7f,0xa7},
		{0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x47,0x6f,0xb3},
		{0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x16,0x29,0xf5},
		{0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x16,0x29,0xf5},
		{0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x55,0x55},
		{0x55,0xc8,0x7a,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x55,0x55}};

void	BeepSend (char callsign[], char flag)
{
	int	i;
	char	buff[12], flags[3];
	char	msg[20];
	char	len;

		switch (flag)
		{
			case	RespBusy:
				sprintf (msg, "%8.8s BUSY       ", callsign); 
				break;
			case	RespNoRoute:
				sprintf (msg, "%8.8s No Route   ", callsign);
				break;
			default:
				sprintf (msg, "CALLED FROM %8.8s", callsign);
				break;
		}
		/* Call Sign set */
		flags[0] = flag;
		flags[1] = 0x00;
		flags[2] = 0x00;
        	usb_control_msg (udev, 0x40, SET_MyCALL, 0, 0, client_call, 8, 100);
	        usb_control_msg (udev, 0x40, SET_MyCALL2, 0, 0, (char *)"    ", 4, 100);
        	usb_control_msg (udev, 0x40, SET_YourCALL, 0, 0, callsign, 8, 100);
        	usb_control_msg (udev, 0x40, SET_RPT2CALL, 0, 0, (char *)"DIRECT  ", 8, 100);
        	usb_control_msg (udev, 0x40, SET_RPT1CALL, 0, 0, (char *)"DIRECT  ", 8, 100);
        	usb_control_msg (udev, 0x40, SET_FLAGS, 0, 0, flags, 3, 100);

		/* PTT ON */
		while (1)
		{
		   	usb_control_msg(udev, 0xC0, GET_REMAINSPACE, 0, 0, &len ,1, 100);
			if (len >=95)
			{
				usb_control_msg(udev, 0x40, SET_PTT, ON, 0, buff, 0, 100);
				PTT_On = TRUE;
				break;
			} else {
				usleep (200000);
			}
		}

		for (i = 0 ; i < 11 ; i++)
		{
			memcpy (buff, &ConnectedMsg[i][0], 12);
			switch (i)
			{
				case 1:
					buff[10] = msg[0] ^ 0x4f;
					buff[11] = msg[1]^ 0x93;
					break;
				case 2:
					buff[ 9] = msg[2] ^ 0x70;
					buff[10] = msg[3] ^ 0x4f;
					buff[11] = msg[4] ^ 0x93;
					break;
				case 3:
					buff[10] = msg[5] ^ 0x4f;
					buff[11] = msg[6] ^ 0x93;
					break;
				case 4:
					buff[ 9] = msg[7] ^ 0x70;
					buff[10] = msg[8] ^ 0x4f;
					buff[11] = msg[9] ^ 0x93;
					break;
				case 5:
					buff[10] = msg[10] ^ 0x4f;
					buff[11] = msg[11] ^ 0x93;
					break;
				case 6:
					buff[ 9] = msg[12] ^ 0x70;
					buff[10] = msg[13] ^ 0x4f;
					buff[11] = msg[14] ^ 0x93;
					break;
				case 7:
					buff[10] = msg[15] ^ 0x4f;
					buff[11] = msg[16] ^ 0x93;
					break;
				case 8:
					buff[ 9] = msg[17] ^ 0x70;
					buff[10] = msg[18] ^ 0x4f;
					buff[11] = msg[19] ^ 0x93;
					break;
			}
			while (1)
			{
			   	usb_control_msg(udev, 0xC0, GET_REMAINSPACE, 0, 0, &len ,1, 100);
				if (len >= 12)
				{
					usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, buff, 12, 100);
					break;
				} else {
					usleep (30000);
				}
			}
		}

		while (1)
		{
		   	usb_control_msg(udev, 0xC0, GET_REMAINSPACE, 0, 0, &len ,1, 100);
			if (len >= 15)
			{
				usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, &ConnectedMsg[11][0], 15, 100);
				break;
			} else {
				usleep (50000);
			}
		}

		/* PTT OFF */
		usb_control_msg(udev, 0x40, SET_PTT, OFF, 0, buff, 0, 100);
		PTT_On = FALSE;
}

