/**
 * Created on 30 Oct. 2009
 * Created by Takaki Tsue, Masato Kawahashi
 * Copyright (C) 2009 HIMACS,Ltd. 
 * Licensed under the Apache License, Version 2.0
 *
 */
/**
 * To avoid the follwing bug
 * http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6230761
 */
package jp.himacs.avoidbugs.ipv6.bug6230761;

import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;

/**
 * @author t-tsue
 * to avoid the follwing bug
 * http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6230761
 */
public class DatagramSocketIPv6 extends DatagramSocket {
	
	/**
	 * default constructor.
	 * @throws SocketException unexpected.
	 */
	public DatagramSocketIPv6() throws SocketException {
		super();
	}

	/**
	 * constructor without binding socket.
	 */
	public DatagramSocketIPv6(DatagramSocketImpl impl) {
		super(impl);
	}

	/**
	 * constructor with binding socket.
	 */
	public DatagramSocketIPv6(SocketAddress bindaddr) throws SocketException {
		super(bindaddr);
	}

	/**
	 * constructor with binding socket.
	 */
	public DatagramSocketIPv6(int port, InetAddress address) throws SocketException {
		super(port, address);
	}

	/**
	 * constructor with binding socket port.
	 */
	public DatagramSocketIPv6(int port) throws SocketException {
		super(port);
	}

	
}
