/**
 * Created on 30 Oct. 2009
 * Created by Takaki Tsue, Masato Kawahashi
 * Copyright (C) 2009 HIMACS,Ltd. 
 * Licensed under the Apache License, Version 2.0
 *
 */
/**
 * The system clock may run fast when you use the ACPI power management timer 
 * as a high-resolution counter on Windows 2000-based, Windows XP-based, 
 * and Windows Server 2003-based computers
 */
package jp.himacs.avoidbugs.timer.kb821893;

/**
 * @see http://support.microsoft.com/kb/821893/en-us
 * @author t-tsue
 *
 */
public class TheSystemClockMayRunFast extends Thread {

	/**
	 *  ᕪ\^C}ƍ\^C}݂ɎsB
	 */
	private void doit() {
		try {
			Thread.sleep(1); // low-resolution clock
			long start = System.nanoTime(); // high-resolution counter
			Thread.sleep(10); // low-resolution clock
			long end = System.nanoTime(); // high-resolution counter
			System.out.println(this+",interval time:"+(end-start)/1000000+"msec");
			yield();
		} catch(Exception ignore) {
			// nothing to do.
		}
	}
	
	@Override
	public void run() {
		while(true) {
			doit();
		}
	}

	/**
	 * @param args if "true" then the system clock may run fast.
	 */
	public static void main(String[] args) {
		boolean isRunFast = args.length == 1 && args[0].toLowerCase().equals("true");
		
		if (!isRunFast) {
			KB821893.beginTimer(1);
		}
		TheSystemClockMayRunFast[] threads = new TheSystemClockMayRunFast[5];
		for(int i = 0; i < threads.length;i++) {
			threads[i] = new TheSystemClockMayRunFast();
			threads[i].start();
		}
	}

}
