/**
 * to avoid the following bug.
 * 
 * http://support.microsoft.com/kb/821893
 * 
 * The system clock may run fast when you use the ACPI power management timer 
 * as a high-resolution counter on Windows 2000-based, Windows XP-based, 
 * and Windows Server 2003-based computers
 */
package jp.himacs.avoidbugs.timer.kb821893;

/**
 * @author t-tsue
 *
 */
public class KB821893 {
	static {
		  System.loadLibrary("KB821893");
	}

	/**
	 * call timeBeginPeriod API.
	 * @param timer timer to be set, 1 is recommended.
	 */
	public static native void beginTimer(int timer);
	/**
	 * call timeEndPeriod API.
	 * @param timer timer to be set which must be the same value to call beginTimer method.
	 */
	public static native void endTimer(int timer);

}
