/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <joerg@FreeBSD.ORG> wrote this file.  As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return.        Joerg Wunsch
 * ----------------------------------------------------------------------------
 *
 * HD44780 LCD display driver
 *
 * $Id: hd44780.h,v 1.1.2.1 2005/12/28 22:35:08 joerg_wunsch Exp $
 */

/*
 * oCgf[^ b LCDɑB
 * rsRSM(Register Select)ŁAOƖ߃WX^APƃf[^WX^I܂B
 */
void	hd44780_outbyte(uint8_t b, uint8_t rs);

/*
 * LCDRg[PoCgǂݏo܂B
 * rsRSMŁA0BUSYtO(bit7)擾A1ƃf[^WX^擾܂B
 */
uint8_t	hd44780_inbyte(uint8_t rs);

/*
 * BUSYtONAɂȂ̂҂܂B
 */
void	hd44780_wait_ready(void);

/*
 * LCDRg[n[hEFA܂
 */
void	hd44780_init(void);


/* LCDRg[ɃR}h𑗂 */
#define hd44780_outcmd(n)	hd44780_outbyte((n), 0)

/* LCDRg[Ƀf[^oCg𑗂 */
#define hd44780_outdata(n)	hd44780_outbyte((n), 1)

/* LCDAhXJE^BUSYtO擾 */
#define hd44780_incmd()		hd44780_inbyte(0)

/* LCD猻݂̃f[^oCg擾 */
#define hd44780_indata()	hd44780_inbyte(1)


/* LCDNA */
#define HD44780_CLR \
	0x01

/* J[\z[|WVɒu */
#define HD44780_HOME \
	0x02

/*
 * Gg[hIB
 * inc̓AhXJE^̃I[gCNgL߁A
 * shift͎fBXvCshift(XN[)̗L߂
 */
#define HD44780_ENTMODE(inc, shift) \
	(0x04 | ((inc)? 0x02: 0) | ((shift)? 1: 0))

/*
 * \on/off, J[\on/off, J[\_on/off.
 */
#define HD44780_DISPCTL(disp, cursor, blink) \
	(0x08 | ((disp)? 0x04: 0) | ((cursor)? 0x02: 0) | ((blink)? 1: 0))

/*
 * shift = 1 ȂA\ŜE܂͍ɃVtg
 * shift = 0 ȂAJ[\E܂͍ɓ
 */
#define HD44780_SHIFT(shift, right) \
	(0x10 | ((shift)? 0x08: 0) | ((right)? 0x04: 0))

/*
 * if8bit ́A8-bit datapXݒB
 * twoline ́AQsfBXvCݒ
 * *font5x10 ́A5x10 dot font̎gpݒiNAȂ5x8hbgtHg)
 */
#define HD44780_FNSET(if8bit, twoline, font5x10) \
	(0x20 | ((if8bit)? 0x10: 0) | ((twoline)? 0x08: 0) | \
		((font5x10)? 0x04: 0))

/*
 * ̃LN^WFl[^AhX addrƂB
 * (Op^[GAւ̃ANZX)
 */
#define HD44780_CGADDR(addr) \
	(0x40 | ((addr) & 0x3f))

/*
 * ̕\AhX addr ƂB
 * (ʏ̃eLXgRAM)
 */
#define HD44780_DDADDR(addr) \
	(0x80 | ((addr) & 0x7f))

