/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <joerg@FreeBSD.ORG> wrote this file.  As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return.        Joerg Wunsch
 * ----------------------------------------------------------------------------
 *
 * Stdio demo, UART implementation
 *
 * $Id: uart.c,v 1.1.2.1 2005/12/28 22:35:08 joerg_wunsch Exp $
 */

#include "defines.h"

#include <stdint.h>
#include <stdio.h>

#include <avr/io.h>

#include "uart.h"

/*
 * UART9600baudɐݒBTx/RxLA8N1(data=8bit,parity=none,stopbit=1)ݒ
 */
void
uart_init(void)
{
#if F_CPU < 2000000UL && defined(U2X)
  UCSRA = _BV(U2X);             /* {[[g덷{NbNɂP(1MHz̏ꍇ傫P) */
  UBRRL = (F_CPU / (8UL * UART_BAUD)) - 1;
#else
  UBRRL = (F_CPU / (16UL * UART_BAUD)) - 1;
#endif
  UCSRB = _BV(TXEN) | _BV(RXEN); /* tx/rx enable */
}

/*
 *  c UARTM@\֑Btx holding register(UDR̃obt@)ɂȂ܂ő҂
 */
int
uart_putchar(char c, FILE *stream)
{

  if (c == '\a')
    {
      fputs("*ring*\n", stderr);
      return 0;
    }

  if (c == '\n')
    uart_putchar('\r', stream);
  loop_until_bit_is_set(UCSRA, UDRE);
  UDR = c;

  return 0;
}

/*
 * UARTM@\PM
 *
 * ͊ȈՂȃCGfB^ĂACRNewLine͂OȂ
 * ͂ꂽ폜ĕҏWł܂B
 * 󎚉\͂uart_putchar()ɃGR[obN܂
 * (^[~iœ͂)
 *
 * ҏW@\F
 *
 * \b (back space \177 delete) ́AOɎM폜܂
 * ^u (control-U, ASCII NAK) sobt@ŜNA܂
 * ^w (control-W, ASCII ETB) OɎM폜܂B
 *    uv̓zCgXy[Xŋ؂ꂽPʂӖ܂
 *    iQoCĝƂł͂Ȃj
 * ^r (control-R, ASCII DC2)  \r 𑗂Aobt@reprint܂
 *     ʁAҏWŗꂽ[̉ʂƂɂȂ܂B
 * \t (tabulator) ͂P̃Xy[Xɕϊ܂B
 *
 * ̑̃Rg[͖܂B
 *
 * Cobt@RX_BUFSIZEŋK肳As\n܂80
 * ݒ肳܂BʏCꕶƈقȂA\0͂܂B
 * obt@tȂ(RX_BUFSIZE-1łɕێĂƂ
 * \nȊO̕)A\a(BEL)uart_putchar()ɑ܂B
 * ̏ԂłsϐRg[R[h͎t\łB
 * 
 *
 * UART@\Ƃ̊Ԃ̓̓G[͒l-1Ԃ܂(G[)B
 * ̂悤ȃG[̓t[~OG[(VÃu[N
 * RfBV)A̓I[o[peBG[(peBrbg
 * gpLŁApeB`FbNn[hEFAŃT|[gĂꍇj
 * ɋN܂B
 *
 * sobt@ɂȂ܂ŁAuart_getchar()ɂsobt@̘A擾
 * R[\ɂȂ܂B
 */
int
uart_getchar(FILE *stream)
{
  uint8_t c;
  char *cp, *cp2;
  static char b[RX_BUFSIZE];
  static char *rxp;

  if (rxp == 0)
    for (cp = b;;)
      {
	loop_until_bit_is_set(UCSRA, RXC);
	if (UCSRA & _BV(FE))
	  return _FDEV_EOF;
	if (UCSRA & _BV(DOR))
	  return _FDEV_ERR;
	c = UDR;
	/* behaviour similar to Unix stty ICRNL */
	if (c == '\r')
	  c = '\n';
	if (c == '\n')
	  {
	    *cp = c;
	    uart_putchar(c, stream);
	    rxp = b;
	    break;
	  }
	else if (c == '\t')
	  c = ' ';

	if ((c >= (uint8_t)' ' && c <= (uint8_t)'\x7e') ||
	    c >= (uint8_t)'\xa0')
	  {
	    if (cp == b + RX_BUFSIZE - 1)
	      uart_putchar('\a', stream);
	    else
	      {
		*cp++ = c;
		uart_putchar(c, stream);
	      }
	    continue;
	  }

	switch (c)
	  {
	  case 'c' & 0x1f:
	    return -1;

	  case '\b':
	  case '\x7f':
	    if (cp > b)
	      {
		uart_putchar('\b', stream);
		uart_putchar(' ', stream);
		uart_putchar('\b', stream);
		cp--;
	      }
	    break;

	  case 'r' & 0x1f:
	    uart_putchar('\r', stream);
	    for (cp2 = b; cp2 < cp; cp2++)
	      uart_putchar(*cp2, stream);
	    break;

	  case 'u' & 0x1f:
	    while (cp > b)
	      {
		uart_putchar('\b', stream);
		uart_putchar(' ', stream);
		uart_putchar('\b', stream);
		cp--;
	      }
	    break;

	  case 'w' & 0x1f:
	    while (cp > b && cp[-1] != ' ')
	      {
		uart_putchar('\b', stream);
		uart_putchar(' ', stream);
		uart_putchar('\b', stream);
		cp--;
	      }
	    break;
	  }
      }

  c = *rxp++;
  if (c == '\n')
    rxp = 0;

  return c;
}

