/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <joerg@FreeBSD.ORG> ̃t@C܂B
 * Ȃȉ̂ƂCɂƂ߂ĂȂ炱̑fނǂĂ悢łB
 * Ă̑fނȂɂƂĉlƎvȂA̓@
 * ΁AԂɃr[tĂB              Joerg Wunsch
 * ----------------------------------------------------------------------------
 *
 * iAVR̃fXg[VłBOCR1AɐڑLEDRg[
 * ܂BLED̖،˂PWMŃRg[܂BPWMRg[邽߂
 * ȎiĂ܂B
 *
 * $Id: largedemo.c,v 1.1.2.2 2006/01/03 22:49:46 joerg_wunsch Exp $
 */

#include <stdint.h>
#include <stdlib.h>

#include <avr/eeprom.h>
#include <avr/interrupt.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/sleep.h>
#include <avr/wdt.h>

/* Part 1: Macro definitions */

#define CONTROL_PORT PORTD
#define CONTROL_DDR  DDRD

#define TRIGGER_DOWN PD2
#define TRIGGER_UP   PD3
#define TRIGGER_ADC  PD4
#define CLOCKOUT     PD6
#define FLASH	     PD7

#if defined(__AVR_ATmega16__)
#  define PWMDDR     DDRD
#  define PWMOUT     PD5
#elif defined(__AVR_ATmega8__) || defined(__AVR_ATmega48__) ||\
      defined(__AVR_ATmega88__) || defined(__AVR_ATmega168__)
#  define PWMDDR     DDRB
#  define PWMOUT     PB1
#else
#  error "Unsupported MCU type"
#endif

#if defined(__AVR_ATmega48__) || defined(__AVR_ATmega88__) ||\
    defined(__AVR_ATmega168__)
/* map ATmega8/16 names to ATmegaX8 names */
#  define USART_RXC_vect USART_RX_vect
#  define UDR     UDR0
#  define UCSRA   UCSR0A
#  define UCSRB   UCSR0B
#  define FE      FE0
#  define TXEN    TXEN0
#  define RXEN    RXEN0
#  define RXCIE   RXCIE0
#  define UDRE    UDRE0
#  define U2X     U2X0
#  define UBRRL   UBRR0L

#  define TIMSK   TIMSK1
#  define MCUCSR  MCUSR
#endif

#define F_CPU 1000000UL	/* CPUNbNAHzPʁ@ł1MHz */

#define SOFTCLOCK_FREQ 100	/* \tgEFANbN */

/*
 * ŌPWMlύXĂEEPROMɃobNAbv܂ł̃^CAEg
 * NbNN(悻100Hz)Ōv܂B
 */
#define EE_UPDATE_TIME (3 * SOFTCLOCK_FREQ) /* ca. 3 seconds */

/*
 * Timer1 overflow 荞݂ F_CPU / 2048 ̎gł܂B
 * 10bitPWMł̂ŁA010230ŁA2048JEgƂȂ
 * ̊荞݃[`͂ɂ̒l𕪎āA悻10msec
 * Abvf[gNbN𐶐܂B10{ĂX𑫂Ă̂́A
 * Œ菬_ۂ߂̂łEEEEHH 
 *  ̈Ӑ}ĂH
 */
#define TMR1_SCALE ((F_CPU * 10) / (2048UL * SOFTCLOCK_FREQ) + 9) / 10

/* Part 2: ϐ` */

/*
 * vOC[vO̊荞݃[`ŃZbgrbg
 */
volatile struct
{
  uint8_t tmr_int: 1;
  uint8_t adc_int: 1;
  uint8_t rx_int: 1;
}
intflags;

/*
 * UARTŌɓǂݏo
 */
volatile char rxbuff;

/*
 * ADCŌɓǂݏol
 */
volatile uint16_t adcval;

/*
 * PWMlEEPROMɕۑꏊ(EEPROMAhX)B
 * ̓ZbgdēłŌPWMlLĂ߂̂̂łB
 */
uint16_t ee_pwm __attribute__((section(".eeprom"))) = 42;

/*
 * ݂ PWM l
 */
int16_t pwm;

/*
 * EEPROM obNAbv^C}[BPWMAbvf[g[`ŏ(bumped)H
 * (莞ԖɌZA)̒l0ɂȂPWMlEEPROMɏ
 * (莞PWMl̕ύXEEPROMɒlۑ)
 */
int16_t pwm_backup_tmr;

/*
 * MCUCRWX^l̃Rs[BX^[gAbv[`擪Ŏ擾B
 */
uint8_t mcucsr __attribute__((section(".noinit")));

/* Part 3: 荞݃T[rX[` */

ISR(TIMER1_OVF_vect)
{
  static uint8_t scaler = TMR1_SCALE;

  if (--scaler == 0)
    {
      scaler = TMR1_SCALE;
      intflags.tmr_int = 1;
    }
}

/*
 * ADϊB10bitl擾APWMݒɎgHH
 */
ISR(ADC_vect)
{
  adcval = ADCW;
  ADCSRA &= ~_BV(ADIE);		/* ADC荞݋֎~ */
  intflags.adc_int = 1;
}

/*
 * UARTM荞݁Bit[~OG[΁j
 * Mobt@ɓl擾B
 * C[v͎M10ms1x`FbNȂƂɒ
 * (ZԊuŘAăf[^Ǝ肱ڂ)
 */
ISR(USART_RXC_vect)
{
  uint8_t c;

  if (bit_is_clear(UCSRA, FE))
    {
      c = UDR;
      /* ******************
      :2chŎwEꂽ̏C
      UCSRÅerbgUDRǂ܂Oɉ߂邱
      UCSRA-FEUDRlobt@Ă̂ŁAUDRǂݏoUCSRA
      ͎̃f[^ɑ΂̂ɂȂB
      ******************* */
      rxbuff = c;
      intflags.rx_int = 1;
    }
}

/* Part 4: ǉ֐ */

/*
 * X^[gAbvMCUCSRǂݏo㏉ݒ肷
 */
void handle_mcucsr(void)
  __attribute__((section(".init3")))
  __attribute__((naked));
void handle_mcucsr(void)
{
  mcucsr = MCUCSR;
  MCUCSR = 0;
}

/*
 * グӑus
 */
static void
ioinit(void)
{
  uint16_t pwm_from_eeprom;

  /*
   * 16bit^C}P̏ݒ
   *
   * ^C}110bitʑPWM(WGM10,WGM11Zbg)A
   * OC1APWMo͂ɃZbg܂B
   * OC1A̓JE^㏸rvŃZbg(HighɂȂ)AJE^~
   * rvŃNA܂iCOM1A1=1,COM1A0=1)B
   * STK500low-activeLEDڑPWMPx̂ɂ傤ǂݒłB
   * ^C}MCUNbN(vXP[Ȃ)œ삵܂B
   * (1MHz,TCCR1BCS10̂set)
   */
  TCCR1A = _BV(WGM10) | _BV(WGM11) | _BV(COM1A1) | _BV(COM1A0);
  TCCR1B = _BV(CS10);

  OCR1A = 0;			/* set PWM value to 0 */

  /* vbV{^m̂߃vAbv */
  CONTROL_PORT = _BV(TRIGGER_DOWN) | _BV(TRIGGER_UP) | _BV(TRIGGER_ADC);

  /*
   * |[gDo͐ݒɂBPD6̓NbNóHAPD7LED_ŁA
   * PD1UART-TxDłAUARTM@\ONɂDDRDɊւ炸
   * TxD͏o͐ݒɂȂ܂̂ŐݒsvłB
   */
  CONTROL_DDR = _BV(CLOCKOUT) | _BV(FLASH);

  /*
   * OC1ÃsʒuMCUނɂĈقȂ̂ŁȀo͂ɂĂ͂
   * ʓrݒ肵Ă܂BDDRxWX^͏LCONTROL_DDRƓł邩
   * ȂƂɒӂĂB(O̐ݒ㏑)Ă܂Ȃ
   * 悤ɒӂĂî߂ u=v ł͂Ȃ u|=v ƂĂ)
   */
  PWMDDR |= _BV(PWMOUT);

  UCSRA = _BV(U2X);		/* 1MHzł̃{[[gG[̌ŷ */
  UCSRB = _BV(TXEN)|_BV(RXEN)|_BV(RXCIE); /* tx/rxLAM荞ݗL*/
  UBRRL = (F_CPU / (8 * 9600UL)) - 1;  /* 9600 Bd */

  /*
   * ADCLAADCNbNIF_CPU / 8 (VXeNbN1MHz 125 kHz)
   */
  ADCSRA = _BV(ADEN) | _BV(ADPS1) | _BV(ADPS0);

  TIMSK = _BV(TOIE1);
  sei();			/* 荞ݗL */

  /*
   * EHb`hbO^C}LAővXP[gpB
   * 5V쎞AEHb`hbOZbg(NAȂ)2bɂ܂
   */
  wdt_enable(WDTO_2S);

  /*
   * EEPROMǂݏoBǂݏol0xFFFF(EEPROMZ̃ftHgl)
   * (EEPROMɂ͒lۑĂȂƔf)PWM̏lɎg܂B
   * use it as the starting value for the PWM.
   */
  if ((pwm_from_eeprom = eeprom_read_word(&ee_pwm)) != 0xffff)
    OCR1A = (pwm = pwm_from_eeprom);
}

/*
 * PUARTo͊֐
 */

/*
 *  c UART TxɑB(M̑O)Mobt@󂭂܂ő҂B
 */
static void
putchr(char c)
{

  loop_until_bit_is_set(UCSRA, UDRE);
  UDR = c;
}

/*
 * C`iNULŏI)UARTM@\ő
 */
static void
printstr(const char *s)
{

  while (*s)
    {
      if (*s == '\n')
	putchr('\r');
      putchr(*s++);
    }
}

/*
 * printstr()ƓłAvOɒuꂽΏۂɂ܂
 * ̊֐gݍނɂ"lpm"߂AVRfoCXKvłB
 */
static void
printstr_p(const char *s)
{
  char c;

  for (c = pgm_read_byte(s); c; ++s, c = pgm_read_byte(s))
    {
      if (c == '\n')
	putchr('\r');
      putchr(c);
    }
}

/*
 * PWMl̍XVBύXꂽƂɂ͐VlVAoRPC֑܂
 */
static void
set_pwm(int16_t new)
{
  char s[8];

  if (new < 0)
    new = 0;
  else if (new > 1000)
    new = 1000;

  if (new != pwm)
    {
      OCR1A = (pwm = new);

      /*
       * PʂDUTYvZ܂B
       * PWMől1000ɂ̂ŁAP10Ŋ邾OKłB
       */
      new /= 10;
      itoa(new, s, 10);
      printstr(s);
      putchr(' ');

      pwm_backup_tmr = EE_UPDATE_TIME;
    }
}

/* Part 5: main() */

int
main(void)
{
  /*
   * 샂[hF
   * MODE_UPDOWN ́APD2܂PD3LowԂłAɏ]PMWl
   *   ͌邱ƂӖ܂B̃[hftHgԂłB
   * MODE_ADC ́APWMlADC0lɏ][hłB
       PC1͂Low̎̃[hɂȂ܂B
   * MODE_SERIAL ́AUARTR}h󂯕t郂[hłB
       V.24(RS232C)A9600bpsŃf[^Mꂽ(M)
       ̃[hƂȂ܂B
   */
  enum
  {
    MODE_UPDOWN,
    MODE_ADC,
    MODE_SERIAL
  } __attribute__((packed)) mode = MODE_UPDOWN;
  uint8_t flash = 0;

  ioinit();

  if ((mcucsr & _BV(WDRF)) == _BV(WDRF))
    printstr_p(PSTR("\nOoops, the watchdog bit me!"));

  printstr_p(PSTR("\nHello, this is the avr-gcc/libc "
		  "demo running on an "
#if defined(__AVR_ATmega16__)
		  "ATmega16"
#elif defined(__AVR_ATmega8__)
		  "ATmega8"
#elif defined(__AVR_ATmega48__)
		  "ATmega48"
#elif defined(__AVR_ATmega88__)
		  "ATmega88"
#elif defined(__AVR_ATmega168__)
		  "ATmega168"
#else
		  "unknown AVR"
#endif
		  "\n"));

  for (;;)
    {
      wdt_reset();

      if (intflags.tmr_int)
	{
	  /*
	   * intflags.tmr_intZbg܂B10msecɓ銄荞݂
	   * NƂӖ܂BȂɂׂ݂Ă܂傤I
	   */
	  intflags.tmr_int = 0;
	  /*
	   * PD6sgO삵܂(LowȂHighցAHighȂLow)
	   * ɂNbNԂ񎦂ł܂B48HzɂȂ͂łB
	   */
	  CONTROL_PORT ^= _BV(CLOCKOUT);
	  /*
	   * PD7LED1bɈx_ł܂
	   */
	  flash++;
	  if (flash == 5) /* 50msec_*/
	    CONTROL_PORT |= _BV(FLASH);
	  else if (flash == 100)  /* ͖1000msec_*/
	    {
	      flash = 0;
	      CONTROL_PORT &= ~_BV(FLASH);
	    }

	  switch (mode)
	    {
	    case MODE_SERIAL:
	      /*
	       * VA[h̏ꍇ́Ał͓ɂ邱Ƃ͂܂
	       */
	      break;

	    case MODE_UPDOWN:
	      /*
	       * PWM㉺{^Ԃ₢킹
	       * NB: |[gǂݍ݂̂PINx(̓|[g)gB
	       * PORTxǂݍ݂́Ao͎͏o̓b`WX^̃~[()𓾁A
	       * ͎͓vAbv̏Ԃ𓾂邾łB
	       */
	      if (bit_is_clear(PIND, TRIGGER_DOWN))
		set_pwm(pwm - 10);
	      else if (bit_is_clear(PIND, TRIGGER_UP))
		set_pwm(pwm + 10);
	      else if (bit_is_clear(PIND, TRIGGER_ADC))
		mode = MODE_ADC;
	      break;

	    case MODE_ADC:
	      if (bit_is_set(PIND, TRIGGER_ADC))
		mode = MODE_UPDOWN;
	      else
		{
		  /*
		   * PADϊJn
		   */
		  ADCSRA |= _BV(ADIE);
		  ADCSRA |= _BV(ADSC);
		}
	      break;
	    }

	  if (pwm_backup_tmr && --pwm_backup_tmr == 0)
	    {
	      /*
	       * EEPROM obNAbv^C}0ƂȂ^CAEg܂B
	       * ݂PWMlEEPROMɃobNAbvĂB
	       * ̊֐͍ŏ̃oCg񂾌㐔msecAVRL邩
	       * ȂƂɒӂĂB
	       * 荞݂͋֎~܂̂ŁA荞݃[`͓܂B
	       */
	      eeprom_write_word(&ee_pwm, pwm);
	      printstr_p(PSTR("[EEPROM updated] "));
	    }
	}

      if (intflags.adc_int)
	{
	  intflags.adc_int = 0;
	  set_pwm(adcval);
	}

      if (intflags.rx_int)
	{
	  intflags.rx_int = 0;

	  if (rxbuff == 'q')
	    {
	      printstr_p(PSTR("\nThank you for using serial mode."
			      "  Good-bye!\n"));
	      mode = MODE_UPDOWN;
	    }
	  else
	    {
	      if (mode != MODE_SERIAL)
		{
		  printstr_p(PSTR("\nWelcome at serial control, "
				  "type +/- to adjust, or 0/1 to turn on/off\n"
				  "the LED, q to quit serial mode, "
				  "r to demonstrate a watchdog reset\n"));
		 /* VARg[ւ悤A+/-LED̖邳𒲐A
		  * 0/1œ_E܂BqŃVA[h甲܂B 
		  */
		  mode = MODE_SERIAL;
		}
	      switch (rxbuff)
		{
		case '+':
		  set_pwm(pwm + 10);
		  break;

		case '-':
		  set_pwm(pwm - 10);
		  break;

		case '0':
		  set_pwm(0);
		  break;

		case '1':
		  set_pwm(1000);
		  break;

		case 'r':
		  printstr_p(PSTR("\nzzzz... zzz..."));
		  /* Ȃł傤˂̃R}hEEEHH */
		  for (;;)
		    ;
		}
	    }
	}
      sleep_mode();
    }
}
