/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <joerg@FreeBSD.ORG> wrote this file.  As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return.		Joerg Wunsch
 * ----------------------------------------------------------------------------
 */

/* $Id: twitest.c,v 1.6 2005/11/05 22:32:46 joerg_wunsch Exp $ */

/*
 * ATmegafoCXɑgݍ܂ꂽTWIC^tF[X
 * 24Cxx I2C EEPROMƒʐMSimple demo program
 */

#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>

#include <avr/io.h>
#include <util/twi.h>		/* Note [1] */

#define DEBUG 1

/*
 * VXeNbNAHzP
 */
#define F_CPU 14745600UL	/* Note [2] */

/*
 * ݊̂߂̒`BATmega8/16/163/323/123œ삵܂B
 * (IOW: gݍTWIC^tF[XSẴfoCX)
 *
 * ATmega128ɂĂUSART1ftHgƂĂ܂B
 */
#ifndef UCSRB
# ifdef UCSR1A		/* ATmega128 */
#  define UCSRA UCSR1A
#  define UCSRB UCSR1B
#  define UBRR UBRR1L
#  define UDR UDR1
# else /* ATmega8 */
#  define UCSRA USR
#  define UCSRB UCR
# endif
#endif
#ifndef UBRR
#  define UBRR UBRRL
#endif

/*
 * Note [3]
 * TWI address for 24Cxx EEPROM:
 *
 * 1 0 1 0 E2 E1 E0 R/~W	24C01/24C02
 * 1 0 1 0 E2 E1 A8 R/~W	24C04
 * 1 0 1 0 E2 A9 A8 R/~W	24C08
 * 1 0 1 0 A10 A9 A8 R/~W	24C16
 */
#define TWI_SLA_24CXX	0xa0	/* E2 E1 E0 = 0 0 0 */

/*
 * MAX_ITER foCXIɖȏꍇ̍őJւB
 * ݂I܂ő҂Ăx傫KvB܂AX[u
 * 葶݂Ȃꍇ̖[v甲xKvB
 * 100 kHz TWI clockł̓X^[gRfBVSLA+R/WpPbgMɂ
 * 10sec܂Bɑ΂AEEPROM̍ŒݎԂ10msec
 * zȂƎv܂
 * ɂAʏ̓ł̓foCX܂ł̌JԂ҂
 * 100͉zȂ͂łB
 */
#define MAX_ITER	200

/*
 * PAGE_SIZE:rowɏ߂oCgAee24xx_write_page()֐̃RgQƁB
 * ̃x_̃foCX16oCg󂯓܂Aʂėp\
 * Œ8oCĝ悤łB
 *
 * y[WTCY͂Q̗ݏłKv܂B͉L̃y[WEvZȒPɂ܂B
 */
#define PAGE_SIZE 8

/*
 * twst:TWIXe[^XWX^l̂G[bZ[WoۑlB
 * f[^V[gTWCRTWINTrbgZbgłԂ̂TWSRWX^l͗L
 * LĂ܂̂ŁATWINTZbg̊ԂɕϐɃRs[Kv܂B
 */
uint8_t twst;

/*
 * Ӌ@평X^[gAbvFUART (fobOEeXgo͗p)ATWI clock.
 */
void
ioinit(void)
{

#if F_CPU <= 1000000UL
/*
 * Note [4]
 * xVXeNbNɊւẮA
 * U2Xwőx덷炷߃{[[g{ɂ܂
 */
	UCSRA = _BV(U2X);
	UBRR = (F_CPU / (8 * 9600UL)) - 1; /* 9600 Bd */
#else
	UBRR = (F_CPU / (16 * 9600UL)) - 1; /* 9600 Bd */
#endif
	UCSRB = _BV(TXEN);		/* tx enable */

	/* TWI clock: 100 kHz clock, TWPS = 0 => prescaler = 1 */
#if defined(TWPS0)
	/* TWSRɃvXP[rbgĂfoCX͂0ɃZbg(mega128ȍ~) */
	TWSR = 0;
#endif

#if F_CPU < 3600000UL
	TWBR = 10;			/* ŏ TWBR lB note [5] */
#else
	TWBR = (F_CPU / 100000UL - 16) / 2;
#endif
}

/*
 * Note [6]
 * UART Tx  c 𑗂BTxێWX^(UDR)ɂȂ܂ő҂
 */
int
uart_putchar(char c, FILE *unused)
{

	if (c == '\n')
	uart_putchar('\r', 0);
	loop_until_bit_is_set(UCSRA, UDRE);
	UDR = c;
	return 0;
}

/*
 * Note [7]
 *
 * EEPROM eeaddr AhXA SRAM buf ցAlen oCgǂݍ
 *
 * ͂Q̃oXTCNv܂Fŏ̃TCNł̓foCXI
 *i}X^[M[hjAAhX]܂B256zAhXrbg
 * foCXZN^E2/E2/E0rbg(TuAhXrbg)ő܂B
 *
 * QԖڂ̃oXTCN̓foCXđI(đJnA}X^[M[h)
 * Af[^foCXTWI}X^[֓]܂B
 * ˗iMjACK𑗂邱Ƃɂ蕡oCg]ł܂B
 * Ō̓]A˗iMjNACK𑗂܂B
 * ȏ̓]sȂ͈˗iMjs܂B
 */

int
ee24xx_read_bytes(uint16_t eeaddr, int len, uint8_t *buf)
{
	uint8_t sla, twcr, n = 0;
	int rv = 0;
	
	/* EEPROMAhX̍ʃrbgSLAɓ\t*/
	/*(24CXX̃X[uAhX+EEPROMAhXbit8-10)A+RȂ̂bit0=0 */
	sla = TWI_SLA_24CXX | (((eeaddr >> 8) & 0x07) << 1);
	
	/*
	 * Note [8]
	 * ŏ̃TCNF}X^[M[h
	 */
	restart:	/* SLAVE҂̎̃[vʒu */
	if (n++ >= MAX_ITER)
	return -1;
	begin:		/*  */

	TWCR = _BV(TWINT) | _BV(TWSTA) | _BV(TWEN); * JnZbg */
	while ((TWCR & _BV(TWINT)) == 0) ; /*@]҂@*/
	switch ((twst = TW_STATUS))
	{
		case TW_REP_START:		/* OKłǋNĂ͂ȂȂ */
		case TW_START:
			break;
		case TW_MT_ARB_LOST:	/* Note [9] */
			goto begin;
		default:
			return -1;	/* error: X^[gRfBVɂȂȂ */
						/* NB: Œ~𑗐M/Ȃ/ *
	}
	
	/* Note [10] */
	/* SLA+W M ɌvZĂSLA W̃tOāATWDRɏ */
	TWDR = sla | TW_WRITE;
	TWCR = _BV(TWINT) | _BV(TWEN); /* TWINTNAē]Jn */
	while ((TWCR & _BV(TWINT)) == 0) ; /* ]҂ */
	switch ((twst = TW_STATUS))
	{
		case TW_MT_SLA_ACK:
			break;
		
		case TW_MT_SLA_NACK:	
		/* X[uIɑ΂NACKԂꂽFfoCX͏busy */
		/* Note [11] */
			goto restart;
		
		case TW_MT_ARB_LOST:	/* sށAĒ */
			goto begin;
		
		default:
			goto error;		/* K~𑗐M */
	}

	TWDR = eeaddr;		/* EEPROMAhX̉8bit𑗂 */
	TWCR = _BV(TWINT) | _BV(TWEN); /* TWINTNAē]Jn */
	while ((TWCR & _BV(TWINT)) == 0) ; /* ]҂ */
	switch ((twst = TW_STATUS))
	{
		case TW_MT_DATA_ACK:	/* ACK:푗M */
			break;
		
		case TW_MT_DATA_NACK:	/* NACK:X[u󂯕tȂ */
			goto quit;
		
		case TW_MT_ARB_LOST:	/* skAĒ */
			goto begin;
		
		default:
			goto error;		/* K~𑗐M */
	}

	/*
	 * Note [12]
	 * ̃TCNF}X^[M[h
	 */
	TWCR = _BV(TWINT) | _BV(TWSTA) | _BV(TWEN); /* (đ)Jn𑗂 */
	while ((TWCR & _BV(TWINT)) == 0) ; /*@]҂@*/
	switch ((twst = TW_STATUS))
	{
		case TW_START:		/* OKłǋNĂ͂ȂȂ */
		case TW_REP_START:	/* 炪҂ */
			break;
		
		case TW_MT_ARB_LOST:	/* skAĒ */
			goto begin;			/* đJnȂ̂ł肦Ȃ */
		
		default:
			goto error;
	}

	/* SLA+R M ɌvZĂSLA R̃tOāATWDRɏ */
	TWDR = sla | TW_READ;
	TWCR = _BV(TWINT) | _BV(TWEN);	/* TWINTNAē]Jn */
	while ((TWCR & _BV(TWINT)) == 0) ;	/* ]҂ */
	switch ((twst = TW_STATUS))
	{
		case TW_MR_SLA_ACK:		/* ACK:푗M */
			break;
		
		case TW_MR_SLA_NACK:	/* NACK:X[u󂯕tȂ */
			goto quit;
		
		case TW_MR_ARB_LOST:	/* skAĒ */
		  goto begin;			/* đJnł肦EEE */
		
		default:
			goto error;
	}

	/* len̎MsBŌ̎M͓ʂȓ(NACKM) */
	for (twcr = _BV(TWINT) | _BV(TWEN) | _BV(TWEA); len > 0; len--)
	/* Note [13] */
	{
		if (len == 1) twcr = _BV(TWINT) | _BV(TWEN);
		/* Ō̎M͓ʂȓ(NACKM) */
		/* TWCRTWEAOFFɂf[^𑗂Auf[^MɁvNACKM */
			TWCR = twcr;		/* TWINTNAē]Jn */
			while ((TWCR & _BV(TWINT)) == 0) ;	/* ]҂ */
			switch ((twst = TW_STATUS))
			{
				case TW_MR_DATA_NACK:
					/* f[^M{NACK(gTWCRɐݒ肵) */
					len = 0;		/* for[vI */ /* FALLTHROUGH */
				
				case TW_MR_DATA_ACK:
					/* f[^M{ACK(gTWCRɐݒ肵) */
					*buf++ = TWDR;	/* f[^ǂݎobt@ɕۑ */
					rv++;
					break;
				
				default:
				  goto error;
			}
		}
		quit:
	
	/* Note [14] */
	TWCR = _BV(TWINT) | _BV(TWSTO) | _BV(TWEN);	/* ~M */

	return rv;	/* Mf[^Ԃ */

	error:		/* G[ */
	rv = -1;
	goto quit;	/*~MăG[R[hԂ*/
}

/*
 * SRAM buf AEEPROM̃AhX eeaddr  len oCgށB
 *
 * ͑Oq̊֐PłBAhXƃf[^oCg̓}X^[M
 * [hő܂BfoCX̍đIKvłB
 * ȂAEEPROM̓y[WPʂł̂ݏ߂܂B̂߁AP
 * CgTCNŃy[WE܂Ȃ悤ӂKvłB
 * 
 * Py[W̃f[^ʂ͐ҖɈقȂĂ܂Bx_[8oCgA
 * ̃x_[16oCgƂłBŏ̋ʍƂāA8oCg/page
 * gƂɂ܂B̓}N PAGE_SIZE Ő錾Ă܂B
 * 
 * ֐͒PɂPy[W݌ۂɏ߂f[^oCgԂ܂B
 * c̃f[^ނ߂ɌĂяo͂̊֐JԂR[
 * ƂɂȂ܂
 */
int
ee24xx_write_page(uint16_t eeaddr, int len, uint8_t *buf)
{
	uint8_t sla, n = 0;
	int rv = 0;
	uint16_t endaddr;

	/* pageE܂łȂH*/
	if (eeaddr + len < (eeaddr | (PAGE_SIZE - 1)))	
		endaddr = eeaddr + len;
	else
		/* y[WE܂ł݂̏ɗ} */
		endaddr = (eeaddr | (PAGE_SIZE - 1)) + 1;
	
	len = endaddr - eeaddr;
	
	/* EEPROMAhX̍ʃrbgSLAɓ\t*/
	/* (24CXX̃X[uAhX+EEPROMAhXbit8-10)ASLA+WȂ̂bit0=0 */
	sla = TWI_SLA_24CXX | (((eeaddr >> 8) & 0x07) << 1);

	restart:
	if (n++ >= MAX_ITER)
	return -1;
	begin:

	/* Note [15] */
	TWCR = _BV(TWINT) | _BV(TWSTA) | _BV(TWEN);	/* JnM */
	while ((TWCR & _BV(TWINT)) == 0) ;			/* ]҂ */
	switch ((twst = TW_STATUS))
	{
		case TW_REP_START:		/* OKłǋNĂ͂ȂȂ */
		case TW_START:			/* ҂铮 */
			break;
		
		case TW_MT_ARB_LOST:	/* }X^sk */
			goto begin;
		
		default:
			return -1;	
			/* error: JnɂȂȂ */
			/* NB: Œ~𑗐M/Ȃ/ */
	}

	/* SLA+W M ɌvZĂSLA W̃tOāATWDRɏ */
	TWDR = sla | TW_WRITE;
	TWCR = _BV(TWINT) | _BV(TWEN);	/* TWINTNAē]Jn */
	while ((TWCR & _BV(TWINT)) == 0) ;	/* ]҂ */
	switch ((twst = TW_STATUS))
	{
		case TW_MT_SLA_ACK:		/* X[uACKF҂铮 */
			break;
		
		case TW_MT_SLA_NACK:	/* X[uNACK: foCX͏busy */
			goto restart;
		
		case TW_MT_ARB_LOST:	/* sށAĒ */
			goto begin;
		
		default:
			goto error;		/* K~𑗐M */
	}

	TWDR = eeaddr;		/* EEPROMAhX̉8bit𑗂 */
	TWCR = _BV(TWINT) | _BV(TWEN); /* TWINTNAē]Jn */
	while ((TWCR & _BV(TWINT)) == 0) ;	/* ]҂ */
	switch ((twst = TW_STATUS))
	{
		case TW_MT_DATA_ACK:	/* X[uACKF҂铮 */
			break;
		
		case TW_MT_DATA_NACK:	/* X[uNACK:foCX͏busy */
			goto quit;
		
		case TW_MT_ARB_LOST:	/* skAĒ */
			goto begin;
		
		default:
			goto error;			/* K~𑗐M */
	}

	for (; len > 0; len--)
	{
		TWDR = *buf++;			/* Mf[^bufTWDR֏ */
		TWCR = _BV(TWINT) | _BV(TWEN);	* TWINTNAē]Jn */
		while ((TWCR & _BV(TWINT)) == 0) ;	/* ]҂ */
		switch ((twst = TW_STATUS))
		{
			case TW_MT_DATA_NACK:
				/* foCX̓CgveNg -- Note [16] */
				goto error;
			
			case TW_MT_DATA_ACK:	/* X[uACKF҂铮 */
				rv++;	/* ]łf[^oCgJEg */
				break;
			
			default:
				goto error;
		}
	}
	quit:
	TWCR = _BV(TWINT) | _BV(TWSTO) | _BV(TWEN); /*~M*/
	
	return rv;	/* Mf[^Ԃ */
	
	error:		/* G[ */
	rv = -1;
	goto quit;	/* ~M */
}

/*
 * ee24xx_write_page() bvAG[Ԃ邩A
 * Sf[^܂邩܂ŌJԂR[֐B
 */
int
ee24xx_write_bytes(uint16_t eeaddr, int len, uint8_t *buf)
{
	int rv, total;

	total = 0;
	do
	{
		#if DEBUG
			printf("Calling ee24xx_write_page(%d, %d, %p)",eeaddr, len, buf);
		#endif
		rv = ee24xx_write_page(eeaddr, len, buf);
		#if DEBUG
		 	printf(" => %d\n", rv);
		#endif
		if (rv == -1)
		return -1;
		eeaddr += rv;
		len -= rv;
		buf += rv;
		total += rv;
	}
	while (len > 0);
	
	return total;
}

void
error(void)
{
	printf("error: TWI status %#x\n", twst);
	exit(0);
}

FILE mystdout = FDEV_SETUP_STREAM(uart_putchar, NULL, _FDEV_SETUP_WRITE);

void
main(void)
{
	uint16_t a;
	int rv;
	uint8_t b[16];
	uint8_t x;

	ioinit();

	stdout = &mystdout;

	for (a = 0; a < 256;)
	{
		printf("%#04x: ", a);
		rv = ee24xx_read_bytes(a, 16, b);
		if (rv <= 0) 
			error();
		if (rv < 16) 
			printf("warning: short read %d\n", rv);
		a += rv;
		for (x = 0; x < rv; x++)
			printf("%02x ", b[x]);
		putchar('\n');
	}
	#define EE_WRITE(addr, str) ee24xx_write_bytes(addr, sizeof(str)-1, str)
	rv = EE_WRITE(55, "The quick brown fox jumps over the lazy dog.");
	if (rv < 0)
		error();
	printf("Wrote %d bytes.\n", rv);
	for (a = 0; a < 256;)
	{
		printf("%#04x: ", a);
		rv = ee24xx_read_bytes(a, 16, b);
		if (rv <= 0)
			error();
		if (rv < 16)
			printf("warning: short read %d\n", rv);
		a += rv;
		for (x = 0; x < rv; x++)
			printf("%02x ", b[x]);
		putchar('\n');
	}
	
	printf("done.\n");

}
