/*
 * Decompiled with CFR 0.152.
 */
package plus.spawn;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicReference;
import plus.io.Device;
import plus.io.Io;
import plus.io.IoHelper;
import plus.spawn.system.UtilInterface;
import plus.util.Escape;

public final class Echo
extends FilterWriter
implements UtilInterface {
    private static final String USAGE = "Usage: echo [OPTION]... [STRING]...\n  -n    do not output the trailing newline\n  -e    enable interpolation of some sequences in STRINGs\n      --help      display this help and exit (should be alone)\n\nWith -e, the following sequences are recognized and interpolated:\n  \\a alert (BEL)\n  \\b backspace\n  \\f form feed\n  \\n new line\n  \\r carriage return\n  \\t horizontal tab\n  \\v vertical tab\n  \\\\ backslash\n  \\uFEFF UNICODE\n  \\xFF Hex decimal\n  \\0777 Octal decimal";
    private final boolean hasDecode;
    private final boolean hasNewLine;
    private final AtomicReference<String> outputText = new AtomicReference();

    public Echo(String[] args, Writer output) {
        super(output);
        StringBuilder flags = new StringBuilder();
        StringBuilder txt = new StringBuilder();
        boolean isTop = true;
        for (String arg : args) {
            char c = arg.charAt(0);
            if (isTop && '-' == c && 2 == arg.length() && 0 <= "neE".indexOf(arg.charAt(1))) {
                flags.append(arg.substring(1));
                continue;
            }
            if (0 != txt.length()) {
                txt.append(' ');
            }
            txt.append(arg);
            isTop = false;
        }
        this.hasNewLine = 0 > flags.indexOf("n");
        this.hasDecode = 0 <= flags.indexOf("e");
        this.outputText.set(txt.toString());
        StringBuilder sb = new StringBuilder("`echo");
        if (0 < flags.length()) {
            sb.append(" -").append((CharSequence)flags);
        }
        sb.append(' ').append(this.outputText);
        System.err.println(sb.append('`'));
    }

    public static void main(String[] args) throws IOException {
        if (0 != args.length && args[0].startsWith("--help")) {
            System.out.println(USAGE);
        } else {
            new Echo(args, Device.openOutput("", "/dev/stdout")).close();
        }
    }

    @Override
    public void close() throws IOException {
        String x = this.outputText.getAndSet(null);
        if (null != x) {
            this.writeln(x);
            super.flush();
        }
        Io.close(this.out);
    }

    @Override
    public int exitValue() {
        return 0;
    }

    @Override
    public boolean hasInput() {
        return false;
    }

    private void writeln(String x) throws IOException {
        String txt;
        String string = txt = this.hasDecode ? Escape.outputFilter(x) : x;
        if (this.hasNewLine) {
            IoHelper.writeln(this.out, txt);
        } else {
            super.write(txt);
        }
    }
}

