/**
 * Copyright (C) 2023 awk4j - https://ja.osdn.net/projects/awk4j/
 * <p>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * <p>
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
// use std::sync::Mutex;
use std::thread;
use std::time::Duration;

// use crate::files::{_COPY, _MOVE, _RENAME};
use crate::files::{_COPY, _RENAME};

use crate::files;
use crate::files::DD;
use crate::iomod;
use crate::thmod;

const IDLING_TIME: u64 = thmod::IDLING_TIME; // 100 ms.

// static mut _SLEEP: Mutex<i32> = Mutex::new(0); // sleep lock

pub fn spawnx() {
    thread::spawn(|| loop {
        let _pop = thmod::get();
        match _pop {
            Some(x) => task(x),
            None => sleep(),
        };
    });
}

pub fn sleep() {
    // unsafe {
    // let _sleep = _SLEEP.lock().unwrap();
    thread::sleep(Duration::from_millis(IDLING_TIME));
    // }
}
fn task(dd: DD) {
    thmod::progress(dd.clone()); // プログレスを表示
    if dd.action != files::SKIP {
        // println!("cmr_mode: {} action: {} ", dd.cmr_mode, dd.action);
        if dd.cmr_mode == _RENAME {
            iomod::rename_file(&dd.input, &dd.output); // Rename
        } else {
            iomod::copy(&dd.input, &dd.output); // Copy, Move
        }
    }
    if dd.cmr_mode != _COPY {
        let _ = iomod::remove_file(&dd.input); // Move, Rename
    }
    thmod::decrement_cur_number(); // キューカウンタを減算
}
