/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.space;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

class Tools {
    static int RSTART;
    static int RLENGTH;
    private static final String WHITE_SPACES = " \t\n\r\u001e";

    Tools() {
    }

    static boolean match(@NotNull Pattern r, CharSequence s, int group) {
        Matcher m;
        if (r == null) {
            Tools.$$$reportNull$$$0(0);
        }
        if ((m = r.matcher(s)).find()) {
            RSTART = m.start(group);
            RLENGTH = m.end(group) - RSTART;
            return true;
        }
        return false;
    }

    static String replaceAll(@NotNull Pattern r, String s, String replacement) {
        Matcher m;
        if (r == null) {
            Tools.$$$reportNull$$$0(1);
        }
        if ((m = r.matcher(s)).find()) {
            return m.replaceAll(replacement);
        }
        return s;
    }

    @NotNull
    static String lTrim(@NotNull String s) {
        if (s == null) {
            Tools.$$$reportNull$$$0(2);
        }
        int i = -1;
        int len = s.length();
        while (++i < len && ' ' >= s.charAt(i)) {
        }
        String string = i > 0 ? s.substring(i) : s;
        if (string == null) {
            Tools.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    static String rTrim(@NotNull String s) {
        int len;
        if (s == null) {
            Tools.$$$reportNull$$$0(4);
        }
        int i = len = s.length();
        while (0 <= --i && ' ' >= s.charAt(i)) {
        }
        String string = ++i < len ? s.substring(0, i) : s;
        if (string == null) {
            Tools.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    static StringBuilder rTrim(@NotNull StringBuilder sb) {
        int len;
        if (sb == null) {
            Tools.$$$reportNull$$$0(6);
        }
        int i = len = sb.length();
        while (0 <= --i && ' ' >= sb.charAt(i)) {
        }
        if (++i < len) {
            sb.setLength(i);
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            Tools.$$$reportNull$$$0(7);
        }
        return stringBuilder;
    }

    static void rTrim(@NotNull StringBuilder sb, @NotNull StringBuilder sx) {
        if (sb == null) {
            Tools.$$$reportNull$$$0(8);
        }
        if (sx == null) {
            Tools.$$$reportNull$$$0(9);
        }
        int len = Tools.rTrim(sx).length();
        sb.setLength(len);
    }

    static char charAt(@NotNull CharSequence cs, int ix) {
        if (cs == null) {
            Tools.$$$reportNull$$$0(10);
        }
        assert (0 <= ix && ix < cs.length()) : String.format("IndexOutOfBoundsException Index: %d/%d [%s]", ix, cs.length(), cs);
        return Tools.toWhiteSpace(cs.charAt(ix));
    }

    static char charAtLast(@NotNull CharSequence cs) {
        if (cs == null) {
            Tools.$$$reportNull$$$0(11);
        }
        int ix = cs.length() - 1;
        assert (0 <= ix) : "Empty string";
        return Tools.toWhiteSpace(cs.charAt(ix));
    }

    static boolean endsWith(@NotNull CharSequence cs, char c) {
        if (cs == null) {
            Tools.$$$reportNull$$$0(12);
        }
        if (!cs.isEmpty()) {
            return Tools.toWhiteSpace(c) == Tools.charAtLast(cs);
        }
        return false;
    }

    static char toWhiteSpace(char c) {
        return 0 <= WHITE_SPACES.indexOf(c) ? (char)' ' : (char)c;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/awk4j/space/Tools";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sx";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/awk4j/space/Tools";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "lTrim";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "rTrim";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "replaceAll";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lTrim";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rTrim";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "charAt";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "charAtLast";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7 -> new IllegalStateException(string);
        };
    }
}

