/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.bench;

import java.util.function.Function;
import org.awk4j.bench.Bench;
import org.awk4j.bench.target.Trim;

public class F02Function {
    static final Function<String, String> rTrimRegex01Classic = Trim::rTrimRegex01Classic;
    static final Function<String, String> rTrimRegex02New = Trim::rTrimRegex02New;
    static final Function<String, String> trim03Original = String::trim;
    static final Function<String, String> trim04String = Trim::trim04String;
    static final Function<CharSequence, String> trim05CharSeq = Trim::trim05CharSeq;
    static final Function<String, String> rTrim06String = Trim::rTrim06String;
    static final Function<StringBuilder, StringBuilder> rTrim07Builder = Trim::rTrim07Builder;
    private static final StringBuilder sb = new StringBuilder(Bench.BENCH_DATA.length());

    static <T> int driver00Generics(Function<T, String> fnc, String ans) {
        String rs;
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = fnc.apply(Bench.BENCH_DATA);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert (ans.equals(rs)) : rs;
        return count;
    }

    static int driver01String(Function<String, String> fnc, String ans) {
        String rs;
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = fnc.apply(Bench.BENCH_DATA);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert (ans.equals(rs)) : rs;
        return count;
    }

    static int driver02CharSequence(Function<CharSequence, String> fnc, String ans) {
        String rs;
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = fnc.apply(Bench.BENCH_DATA);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert (ans.equals(rs)) : rs;
        return count;
    }

    static int driver03Builder(Function<StringBuilder, StringBuilder> fnc, String ans) {
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            sb.setLength(0);
            sb.append(Bench.BENCH_DATA);
            start = System.nanoTime();
            fnc.apply(sb);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert (ans.contentEquals(sb)) : sb;
        return count;
    }

    static void crew(int[] ANSWER) {
        ANSWER[1] = F02Function.driver01String(rTrimRegex01Classic, Bench.ANS_RIGHT);
        Bench.cool();
        ANSWER[2] = F02Function.driver01String(rTrimRegex02New, Bench.ANS_RIGHT);
        Bench.cool();
        ANSWER[3] = F02Function.driver01String(trim03Original, "^^);");
        Bench.cool();
        ANSWER[4] = F02Function.driver01String(trim04String, "^^);");
        Bench.cool();
        ANSWER[5] = F02Function.driver02CharSequence(trim05CharSeq, "^^);");
        Bench.cool();
        ANSWER[6] = F02Function.driver01String(rTrim06String, Bench.ANS_RIGHT);
        Bench.cool();
        ANSWER[7] = F02Function.driver03Builder(rTrim07Builder, Bench.ANS_RIGHT);
    }

    static void GenericsCrew(int[] ANSWER) {
        ANSWER[1] = F02Function.driver00Generics(rTrimRegex01Classic, Bench.ANS_RIGHT);
        Bench.cool();
        ANSWER[2] = F02Function.driver00Generics(rTrimRegex02New, Bench.ANS_RIGHT);
        Bench.cool();
        ANSWER[3] = F02Function.driver00Generics(trim03Original, "^^);");
        Bench.cool();
        ANSWER[4] = F02Function.driver00Generics(trim04String, "^^);");
        Bench.cool();
        ANSWER[5] = F02Function.driver00Generics(trim05CharSeq, "^^);");
        Bench.cool();
        ANSWER[6] = F02Function.driver00Generics(rTrim06String, Bench.ANS_RIGHT);
        Bench.cool();
        ANSWER[7] = F02Function.driver03Builder(rTrim07Builder, Bench.ANS_RIGHT);
    }
}

