/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.expr;

import java.math.BigInteger;
import net.morilib.awk.AwkCastException;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class AwkInclementer
extends AwkExpression {
    private AwkExpression e1;
    private boolean prefix;

    public AwkInclementer(AwkExpression e1, boolean prefix) {
        this.e1 = e1;
        this.prefix = prefix;
    }

    public AwkValue eval(AwkNamespace ns, AwkFiles o) {
        AwkValue w;
        AwkValue v = this.e1.eval(ns, o);
        if (v.isInteger() || v.isString() && v.isIntegerValue()) {
            BigInteger b = v.toInteger();
            w = AwkInteger.valueOf(b.add(BigInteger.ONE));
        } else if (v.isFloat() || v.isString() && v.isFloatValue()) {
            w = AwkFloat.valueOf(v.toFloat() + 1.0);
        } else if (v instanceof AwkUndefined) {
            v = AwkInteger.ZERO;
            w = AwkInteger.ONE;
        } else {
            throw new AwkCastException("number required");
        }
        v = this.prefix ? w : v;
        this.e1.assign(ns, w, o);
        return v;
    }

    public boolean isLvalue() {
        return false;
    }
}

