/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.value;

import java.math.BigInteger;
import java.util.regex.Pattern;
import net.morilib.awk.AwkCastException;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class AwkString
extends AwkValue {
    private String value;

    private AwkString(String s) {
        this.value = s;
    }

    public static AwkString valueOf(String s) {
        return new AwkString(s);
    }

    public double toFloat() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            throw new AwkCastException(this + " is not a number");
        }
    }

    public BigInteger toInteger() {
        try {
            return new BigInteger(this.value);
        }
        catch (NumberFormatException e) {
            throw new AwkCastException(this + " is not an integer");
        }
    }

    public Number toReal() {
        try {
            return new BigInteger(this.value);
        }
        catch (NumberFormatException e) {
            try {
                return Double.parseDouble(this.value);
            }
            catch (NumberFormatException f) {
                throw new AwkCastException(this + " is not a number");
            }
        }
    }

    public boolean toBoolean() {
        return !this.value.equals("");
    }

    public Pattern toRegex() {
        return Pattern.compile(this.value);
    }

    public Object toObject() {
        return this.value;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isReal() {
        return false;
    }

    public boolean isFloatValue() {
        try {
            Double.parseDouble(this.value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isIntegerValue() {
        try {
            new BigInteger(this.value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isRealValue() {
        return this.isFloatValue() || this.isIntegerValue();
    }

    public boolean isNegativeValue() {
        try {
            return new BigInteger(this.value).signum() < 0;
        }
        catch (NumberFormatException e) {
            try {
                return Double.parseDouble(this.value) < 0.0;
            }
            catch (NumberFormatException f) {
                throw new AwkCastException(this + " is not a number");
            }
        }
    }

    public boolean isPositiveValue() {
        try {
            return new BigInteger(this.value).signum() > 0;
        }
        catch (NumberFormatException e) {
            try {
                return Double.parseDouble(this.value) > 0.0;
            }
            catch (NumberFormatException f) {
                throw new AwkCastException(this + " is not a number");
            }
        }
    }

    public boolean isZeroValue() {
        try {
            return new BigInteger(this.value).signum() == 0;
        }
        catch (NumberFormatException e) {
            try {
                return Double.parseDouble(this.value) == 0.0;
            }
            catch (NumberFormatException f) {
                throw new AwkCastException(this + " is not a number");
            }
        }
    }

    public boolean isString() {
        return true;
    }

    public boolean isRegex() {
        return false;
    }

    public boolean isFunction() {
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AwkString) {
            return this.value.equals(((AwkString)o).value);
        }
        return false;
    }

    public String toString(AwkNamespace ns) {
        return this.value;
    }

    public int compareTo(AwkValue o, AwkNamespace ns) {
        if (o instanceof AwkUndefined) {
            return 1;
        }
        return this.value.compareTo(o.toString(ns));
    }
}

