/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.value;

import java.math.BigInteger;
import java.util.Collection;
import java.util.regex.Pattern;
import net.morilib.awk.AwkArithmeticException;
import net.morilib.awk.AwkCastException;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AwkValue {
    private static final BigInteger MINB = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger MAXB = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final AwkValue TRUE = AwkInteger.valueOf(1L);
    public static final AwkValue FALSE = AwkInteger.valueOf(0L);
    public static final AwkValue IOERROR = AwkInteger.valueOf(-1L);

    public BigInteger toInteger() {
        throw new AwkCastException(this + " is not a number");
    }

    public int toIntExact() {
        if (!this.isIntValue()) {
            throw new AwkArithmeticException("the integer is not small");
        }
        return this.toInteger().intValue();
    }

    public double toFloat() {
        throw new AwkCastException(this + " is not a number");
    }

    public abstract String toString(AwkNamespace var1);

    public String toString() {
        return this.toString(null);
    }

    public abstract boolean toBoolean();

    public Number toReal() {
        throw new AwkCastException(this + " is not a number");
    }

    public Pattern toRegex() {
        throw new AwkCastException(this + " is not a regular expression");
    }

    public abstract Object toObject();

    public AwkValue referArray(String v) {
        throw new AwkCastException(this + " is not an array");
    }

    public AwkValue putArray(String k, AwkValue v) {
        throw new AwkCastException(this + " is not an array");
    }

    public boolean contains(String k) {
        throw new AwkCastException(this + " is not an array");
    }

    public AwkValue deleteArray(String v) {
        throw new AwkCastException(this + " is not an array");
    }

    public Collection<AwkValue> values() {
        throw new AwkCastException(this + " is not an array");
    }

    public abstract boolean isInteger();

    public abstract boolean isFloat();

    public abstract boolean isReal();

    public abstract boolean isIntegerValue();

    public boolean isIntValue() {
        return this.isIntegerValue() && this.toInteger().compareTo(MINB) > 0 && this.toInteger().compareTo(MAXB) < 0;
    }

    public abstract boolean isFloatValue();

    public abstract boolean isRealValue();

    public abstract boolean isPositiveValue();

    public abstract boolean isZeroValue();

    public abstract boolean isNegativeValue();

    public abstract boolean isString();

    public abstract boolean isRegex();

    public abstract boolean isFunction();

    public AwkNamespace getNamespace() {
        return null;
    }

    public abstract int compareTo(AwkValue var1, AwkNamespace var2);
}

