/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.pattern;

import java.util.regex.Pattern;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;

public class AwkRegexPattern implements AwkPattern {

	private Pattern regex;

	/**
	 * 
	 * @param regex
	 */
	public AwkRegexPattern(Pattern regex) {
		this.regex = regex;
	}

	/**
	 * 
	 * @param regex
	 */
	public AwkRegexPattern(String regex) {
		this.regex = Pattern.compile(regex);
	}

	public boolean isBegin() {
		return false;
	}

	public boolean isEnd() {
		return false;
	}

	public AwkMatchState match(AwkNamespace ns, AwkFiles fs,
			String s, AwkMatchState stat) {
		for(int i = 0; i < s.length(); i++) {
			if(regex.matcher(s.substring(i)).lookingAt()) {
				return AwkMatchState.MATCHED;
			}
		}
		return AwkMatchState.NO_MATCH;
	}

	public boolean isRanged() {
		return false;
	}

}
