/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import java.util.Collection;

import net.morilib.awk.builtin.AwkBinaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.stat.StatisticsUtils;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class Regression extends AwkBinaryArgs {

	/**
	 * 
	 * @param name
	 */
	public Regression() {
		super("regression");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2) {
		Collection<AwkValue> v;
		double[] x, y, r;
		int i = 0, j = 0;
		AwkArray z;

		if((a1 instanceof AwkArray) && (a2 instanceof AwkArray)) {
			v = a1.values();
			x = new double[v.size()];
			for(AwkValue a : v)  x[i++] = a.toFloat();
			v = a2.values();
			y = new double[v.size()];
			for(AwkValue a : v)  y[j++] = a.toFloat();
			r = StatisticsUtils.regression(x, y);
			z = new AwkArray();
			z.putArray("0", AwkFloat.valueOf(r[0]));
			z.putArray("1", AwkFloat.valueOf(r[1]));
			return z;
		} else {
			return AwkUndefined.UNDEF;
		}
	}

}
