/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.parser;

public class AwkRelop extends AwkOperator {

	public static enum Operator { EQ, NE, LT, LE, GT, GE }

	public static final AwkRelop EQ = new AwkRelop(Operator.EQ, "==");
	public static final AwkRelop NE = new AwkRelop(Operator.NE, "!=");
	public static final AwkRelop LT = new AwkRelop(Operator.LT, "<");
	public static final AwkRelop LE = new AwkRelop(Operator.LE, "<=");
	public static final AwkRelop GT = new AwkRelop(Operator.GT, ">");
	public static final AwkRelop GE = new AwkRelop(Operator.GE, ">=");

	private Operator operator;

	private AwkRelop(Operator op, String desc) {
		super(desc, 28);
		operator = op;
	}

	public Operator getRelation() {
		return operator;
	}

}
