/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.builtin.mat;

import net.morilib.awk.matrix.ArrayDoubleMatrix;
import net.morilib.awk.matrix.ArrayDoubleVector;
import net.morilib.awk.matrix.DoubleMatrix;
import net.morilib.awk.matrix.DoubleVector;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public final class AwkMatrices {
    static final String SUBSEP = "SUBSEP";

    private AwkMatrices() {
    }

    public static DoubleMatrix toDoubleMatrix(AwkValue a, String sep) {
        ArrayDoubleMatrix m;
        int cs = Integer.MAX_VALUE;
        String s11 = "1" + sep + "1";
        if (!a.isArray()) {
            m = new ArrayDoubleMatrix(1, 1);
            m.set(0, 0, a.toFloat());
        } else if (a.referArray(s11) instanceof AwkUndefined) {
            m = null;
        } else {
            AwkValue v;
            int rs = 1;
            while (!((v = a.referArray(String.valueOf(rs) + sep + "1")) instanceof AwkUndefined)) {
                int j = 1;
                while (true) {
                    if ((v = a.referArray(String.valueOf(rs) + sep + j)) instanceof AwkUndefined) {
                        if (cs <= --j) break;
                        cs = j;
                        break;
                    }
                    ++j;
                }
                ++rs;
            }
            m = new ArrayDoubleMatrix(cs, --rs);
            int i = 1;
            while (i <= rs) {
                int j = 1;
                while (j <= cs) {
                    v = a.referArray(String.valueOf(i) + sep + j);
                    m.set(j - 1, i - 1, v.toFloat());
                    ++j;
                }
                ++i;
            }
        }
        return m;
    }

    public static DoubleMatrix toDoubleMatrix2(AwkValue a, String sep) {
        ArrayDoubleMatrix m;
        int cs = Integer.MAX_VALUE;
        String s11 = "1" + sep + "1";
        if (!a.isArray()) {
            m = new ArrayDoubleMatrix(1, 1);
            m.set(0, 0, a.toFloat());
        } else if (a.referArray(s11) instanceof AwkUndefined) {
            m = null;
        } else {
            AwkValue v;
            int rs = 1;
            while (!((v = a.referArray(String.valueOf(rs) + sep + "1")) instanceof AwkUndefined)) {
                int j = 1;
                while (true) {
                    if ((v = a.referArray(String.valueOf(rs) + sep + j)) instanceof AwkUndefined) {
                        if (cs <= --j) break;
                        cs = j;
                        break;
                    }
                    ++j;
                }
                ++rs;
            }
            m = new ArrayDoubleMatrix(--rs, cs);
            int i = 1;
            while (i <= rs) {
                int j = 1;
                while (j <= cs) {
                    v = a.referArray(String.valueOf(i) + sep + j);
                    m.set(i - 1, j - 1, v.toFloat());
                    ++j;
                }
                ++i;
            }
        }
        return m;
    }

    public static DoubleVector toDoubleVector(AwkValue a) {
        ArrayDoubleVector m;
        String s11 = "1";
        if (!a.isArray()) {
            m = new ArrayDoubleVector(1);
            m.set(0, a.toFloat());
        } else if (a.referArray(s11) instanceof AwkUndefined) {
            m = null;
        } else {
            AwkValue v;
            int rs = 1;
            while (!((v = a.referArray(String.valueOf(rs))) instanceof AwkUndefined)) {
                ++rs;
            }
            m = new ArrayDoubleVector(--rs);
            int i = 1;
            while (i <= rs) {
                v = a.referArray(String.valueOf(i));
                m.set(i - 1, v.toFloat());
                ++i;
            }
        }
        return m;
    }

    public static AwkArray toAwkArray(DoubleMatrix m, String sep) {
        AwkArray a = new AwkArray();
        int i = 1;
        while (i <= m.rowSize()) {
            int j = 1;
            while (j <= m.columnSize()) {
                a.putArray(String.valueOf(i) + sep + j, AwkFloat.valueOf(m.get(j - 1, i - 1)));
                ++j;
            }
            ++i;
        }
        return a;
    }

    public static AwkArray toAwkArray(DoubleVector m) {
        AwkArray a = new AwkArray();
        int i = 1;
        while (i <= m.size()) {
            a.putArray(String.valueOf(i), AwkFloat.valueOf(m.get(i - 1)));
            ++i;
        }
        return a;
    }
}

