/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist.continuous;

import net.morilib.awk.stat.dist.AbstractContinuousDistribution;
import net.morilib.awk.stat.special.Beta;

public class FDistribution
extends AbstractContinuousDistribution {
    private double d1;
    private double d2;

    public FDistribution(int d1, int d2) {
        if (d1 <= 0) {
            throw new IllegalArgumentException();
        }
        if (d2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.d1 = d1;
        this.d2 = d2;
    }

    public int getD1() {
        return (int)this.d1;
    }

    public int getD2() {
        return (int)this.d2;
    }

    public boolean isInSupport(double n) {
        return n >= 0.0;
    }

    public double supportInfimum() {
        return 0.0;
    }

    public double supportSupremum() {
        return 1.0E10;
    }

    private double _cdf(double x) {
        double k = this.d1 * x / (this.d1 * x + this.d2);
        double r = Beta.I(k, this.d1 / 2.0, this.d2 / 2.0);
        return r;
    }

    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double r = this._cdf(x);
        double a = this._cdf(x - 1.0E-4);
        double b = this._cdf(x + 1.0E-4);
        if (a > r && r < b) {
            return (a + b) / 2.0;
        }
        if (a < r && r > b) {
            return (a + b) / 2.0;
        }
        if (Double.isNaN(r)) {
            return (a + b) / 2.0;
        }
        if (r != 0.0) {
            return r;
        }
        if (this.d1 > 2.0) {
            return x > this.mode() ? 1.0 : r;
        }
        if (this.d2 > 2.0) {
            return x > this.expectedValue() ? 1.0 : r;
        }
        return x > 5.0 ? 1.0 : r;
    }

    public double expectedValue() {
        if (this.d2 > 2.0) {
            return this.d2 / (this.d2 - 2.0);
        }
        return Double.NaN;
    }

    public double kurtosis() {
        if (this.d2 > 8.0) {
            double d12m2 = this.d1 + this.d2 - 2.0;
            double d2m2 = this.d2 - 2.0;
            double d2m4 = this.d2 - 4.0;
            double d2m6 = this.d2 - 6.0;
            double d2m8 = this.d2 - 8.0;
            double r = 12.0;
            r *= this.d1 * (5.0 * this.d2 - 22.0) * d12m2 + d2m4 * d2m2 + d2m2;
            return r /= this.d1 * d2m6 * d2m8 * d12m2;
        }
        return Double.NaN;
    }

    public double mode() {
        if (this.d1 > 2.0) {
            return (this.d1 - 2.0) / this.d1 * this.d2 / (this.d2 + 2.0);
        }
        return Double.NaN;
    }

    public double skewness() {
        if (this.d2 > 6.0) {
            double d12m2 = this.d1 + this.d2 - 2.0;
            double d12m22 = 2.0 * this.d1 + this.d2 - 2.0;
            double d2m4 = this.d2 - 4.0;
            double d2m6 = this.d2 - 6.0;
            double r = d12m22 * Math.sqrt(8.0 * d2m4);
            return r /= d2m6 * Math.sqrt(this.d1 * d12m2);
        }
        return Double.NaN;
    }

    public double variance() {
        if (this.d2 > 4.0) {
            double d12m2 = this.d1 + this.d2 - 2.0;
            double d2m2 = this.d2 - 2.0;
            double d2m4 = this.d2 - 4.0;
            double r = 2.0 * this.d2 * this.d2 * d12m2;
            return r /= this.d1 * d2m2 * d2m2 * d2m4;
        }
        return Double.NaN;
    }

    public double f(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double d1x = this.d1 * x;
        double d1xd2 = this.d1 * x + this.d2;
        double l = this.d1 * Math.log(d1x) + this.d2 * Math.log(this.d2);
        l -= (this.d1 + this.d2) * Math.log(d1xd2);
        l /= 2.0;
        return Math.exp(l -= Math.log(x) + Beta.logBeta(this.d1 / 2.0, this.d2 / 2.0));
    }
}

