/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist.continuous;

import net.morilib.awk.stat.dist.AbstractContinuousDistribution;

public class LogisticDistribution
extends AbstractContinuousDistribution {
    private double mu;
    private double s;

    public LogisticDistribution(double mu, double s) {
        if (s <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.mu = mu;
        this.s = s;
    }

    public double getScale() {
        return this.s;
    }

    public double invCdf(double x) {
        if (x < 0.0 || x > 1.0) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        return this.mu - this.s * Math.log(1.0 / x - 1.0);
    }

    public boolean isInSupport(double n) {
        return true;
    }

    public double supportInfimum() {
        return Double.NEGATIVE_INFINITY;
    }

    public double supportSupremum() {
        return Double.POSITIVE_INFINITY;
    }

    public double cdf(double x) {
        return 1.0 / (1.0 + Math.exp(-(x - this.mu) / this.s));
    }

    public double expectedValue() {
        return this.mu;
    }

    public double kurtosis() {
        return 1.2;
    }

    public double mode() {
        return this.mu;
    }

    public double skewness() {
        return 0.0;
    }

    public double variance() {
        return Math.PI * this.s * (Math.PI * this.s) / 3.0;
    }

    public double f(double x) {
        double k = Math.exp(-(x - this.mu) / this.s);
        double m = Math.exp((x - this.mu) / this.s);
        return 1.0 / (2.0 + k + m) / this.s;
    }
}

