/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import net.morilib.awk.builtin.AwkTernaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.stat.StatisticsUtils;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

/**
 * 関数stat.chisquaredtestの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class ChiSquaredTest extends AwkTernaryArgs {

	public ChiSquaredTest() {
		super("chisquaredtest");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2, AwkValue a3) {
		double[] obs, exp;
		double alp;

		obs = AwkStatUtils.toDoubleArray(a1);
		exp = AwkStatUtils.toDoubleArray(a2);
		alp = a3.toFloat();
		if(alp < 0 || alp > 1) {
			throw new AwkStatisticsException("Invalid significance");
		} else if(obs.length < 2) {
			throw new AwkStatisticsException("Too few data");
		} else if(exp.length < 2) {
			throw new AwkStatisticsException("Too few data");
		}
		return StatisticsUtils.testChiSquared(obs, exp, alp) ?
				AwkInteger.ONE : AwkInteger.ZERO;
	}

}
