/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.morilib.awk.AwkCompilationException;
import net.morilib.awk.AwkException;
import net.morilib.awk.AwkExitException;
import net.morilib.awk.AwkNextException;
import net.morilib.awk.builtin.AwkBuiltInLoader;
import net.morilib.awk.code.AwkProgram;
import net.morilib.awk.encoding.EncodingDetector;
import net.morilib.awk.encoding.EncodingDetectorFactory;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.misc.FilesReader;
import net.morilib.awk.misc.RecordInputStream;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.namespace.AwkRootNamespace;
import net.morilib.awk.parser.AwkLexer;
import net.morilib.awk.parser.AwkParser;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;
import net.morilib.c.pre.CPreprocessorReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Awk {
    private static final Awk _INS = new Awk();
    public static final String VERSION = "0.1.1";

    private Awk() {
    }

    public static Awk getInstance() {
        return _INS;
    }

    public static AwkNamespace newNamespace(String filename, String ... args) {
        AwkRootNamespace r = new AwkRootNamespace();
        AwkBuiltInLoader.load(r);
        r.assign("FILENAME", AwkString.valueOf(filename));
        r.assign("ARGC", AwkInteger.valueOf(args.length));
        r.assign("ARGV", new AwkArray(0, args));
        AwkArray a = new AwkArray();
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            ((AwkValue)a).putArray(e.getKey(), AwkString.valueOf(e.getValue()));
        }
        r.assign("ENVIRON", a);
        a = new AwkArray();
        for (Object o : System.getProperties().keySet()) {
            String s = o.toString();
            ((AwkValue)a).putArray(s, AwkString.valueOf(System.getProperty(s)));
        }
        r.assign("PROPERTIES", a);
        return r;
    }

    public AwkProgram compile(AwkNamespace namespace, Reader source) throws IOException {
        AwkLexer l = new AwkLexer(source);
        AwkProgram p = AwkParser.parse(namespace, l);
        return p;
    }

    public AwkValue execute(AwkNamespace namespace, AwkProgram program, String filename, InputStream stdin, Writer stdout, Writer stderr, Charset inputEncoding, Map<Object, Object> vars, String ... args) throws IOException {
        AwkFiles f = null;
        RecordInputStream rd = new RecordInputStream(stdin, inputEncoding, namespace);
        if (vars != null) {
            for (Map.Entry<Object, Object> o : vars.entrySet()) {
                namespace.assign(o.getKey().toString(), AwkString.valueOf(o.getValue().toString()));
            }
        }
        try {
            f = new AwkFiles(rd, stdout, stderr);
            program.executeBegin(namespace, f);
            stdout.flush();
            stderr.flush();
            if (!program.isExecuteOnce()) {
                String s;
                while ((s = rd.readRecord()) != null) {
                    try {
                        program.execute(namespace, f, s);
                    }
                    catch (AwkNextException o) {
                        stdout.flush();
                        stderr.flush();
                        continue;
                    }
                    catch (AwkExitException e) {
                        try {
                            program.executeEnd(namespace, f);
                            AwkValue awkValue = e.getValue();
                            if (f != null) {
                                f.closeAll();
                            }
                            return awkValue;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            stdout.flush();
                            stderr.flush();
                        }
                    }
                    stdout.flush();
                    stderr.flush();
                }
            }
            program.executeEnd(namespace, f);
            stdout.flush();
            stderr.flush();
            AwkInteger awkInteger = AwkInteger.ZERO;
            return awkInteger;
        }
        finally {
            if (f != null) {
                f.closeAll();
            }
        }
    }

    public AwkValue execute(Reader source, String filename, InputStream stdin, Writer stdout, Writer stderr, Charset inputEncoding, Map<Object, Object> vars, String ... args) throws IOException {
        AwkNamespace r = Awk.newNamespace(filename, args);
        AwkProgram p = this.compile(r, source);
        return this.execute(r, p, filename, stdin, stdout, stderr, inputEncoding, vars, args);
    }

    public AwkValue execute(Reader source, File inputFile, File outputFile, Writer stderr, Charset inputEncoding, Charset outputEncoding, Map<Object, Object> vars, String ... args) throws IOException {
        Writer stdout = null;
        FileInputStream stdin = null;
        try {
            stdin = new FileInputStream(inputFile);
            stdout = outputEncoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), outputEncoding) : new OutputStreamWriter(new FileOutputStream(outputFile));
            AwkValue awkValue = this.execute(source, inputFile.toString(), stdin, stdout, stderr, inputEncoding, vars, args);
            return awkValue;
        }
        finally {
            if (stdin != null) {
                ((InputStream)stdin).close();
            }
            if (stdout != null) {
                stdout.flush();
                stdout.close();
            }
        }
    }

    public AwkValue execute(String source, InputStream stdin, Writer stdout, Writer stderr, Charset inputEncoding, Map<Object, Object> vars, String ... args) throws IOException {
        StringReader srd = new StringReader(source);
        return this.execute((Reader)srd, "<no name>", stdin, stdout, stderr, inputEncoding, vars, args);
    }

    public AwkValue execute(String source, InputStream stdin, OutputStream stdout, OutputStream stderr, Charset inputEncoding, Map<Object, Object> vars, String ... args) throws IOException {
        StringReader srd = new StringReader(source);
        return this.execute((Reader)srd, "<no name>", stdin, (Writer)new OutputStreamWriter(stdout), (Writer)new OutputStreamWriter(stderr), inputEncoding, vars, args);
    }

    public AwkValue execute(String source, InputStream stdin, Writer stdout, Writer stderr, Charset inputEncoding) throws IOException {
        return this.execute(source, stdin, stdout, stderr, inputEncoding, new HashMap<Object, Object>(), new String[0]);
    }

    public AwkValue execute(String source, InputStream stdin, OutputStream stdout, OutputStream stderr, Charset inputEncoding) throws IOException {
        return this.execute(source, stdin, stdout, stderr, inputEncoding, new HashMap<Object, Object>(), new String[0]);
    }

    public AwkValue execute(String source, InputStream stdin, OutputStream stdout, OutputStream stderr) throws IOException {
        return this.execute(source, stdin, stdout, stderr, Charset.defaultCharset(), new HashMap<Object, Object>(), new String[0]);
    }

    public AwkValue execute(String source, File inputFile, File outputFile, Writer stderr, Charset inputEncoding, Charset outputEncoding, Map<Object, Object> vars, String ... args) throws IOException {
        StringReader srd = new StringReader(source);
        return this.execute((Reader)srd, inputFile, outputFile, stderr, inputEncoding, outputEncoding, vars, args);
    }

    public AwkValue overwrite(Reader source, File file, Writer stderr, Charset inputEncoding, Charset outputEncoding, Map<Object, Object> vars, String ... args) throws IOException {
        AwkValue v;
        File tf = File.createTempFile("awkium", ".tmp");
        BufferedOutputStream ous = null;
        BufferedInputStream ins = null;
        byte[] b = new byte[4096];
        Writer stdout = null;
        FileInputStream stdin = null;
        try {
            stdin = new FileInputStream(file);
            stdout = outputEncoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(tf), outputEncoding) : new OutputStreamWriter(new FileOutputStream(tf));
            v = this.execute(source, file.toString(), stdin, stdout, stderr, inputEncoding, vars, args);
        }
        finally {
            if (stdin != null) {
                ((InputStream)stdin).close();
            }
            if (stdout != null) {
                stdout.flush();
                stdout.close();
            }
        }
        try {
            int l;
            ins = new BufferedInputStream(new FileInputStream(tf));
            ous = new BufferedOutputStream(new FileOutputStream(file));
            while ((l = ins.read(b)) >= 0) {
                ous.write(b, 0, l);
            }
            AwkValue awkValue = v;
            return awkValue;
        }
        finally {
            if (ins != null) {
                ins.close();
            }
            if (ous != null) {
                ous.flush();
                ous.close();
            }
            tf.delete();
        }
    }

    public AwkValue overwrite(String source, File file, Writer stderr, Charset inputEncoding, Charset outputEncoding, Map<Object, Object> vars, String ... args) throws IOException {
        StringReader srd = new StringReader(source);
        return this.overwrite(srd, file, stderr, inputEncoding, outputEncoding, vars, args);
    }

    public void usage() {
        System.err.print("awkium Ver. ");
        System.err.println(VERSION);
        System.err.println("usage:");
        System.err.println("awk [option] -f program [files ...]");
        System.err.println("awk [option] script [files ...]");
        System.err.println("option:");
        System.err.println("-F file-separator");
    }

    public int invoke(InputStream stdin, Writer stdout, Writer stderr, String ... args) throws IOException {
        String s;
        ArrayList<String> a = new ArrayList<String>();
        ArrayList<String> f = new ArrayList<String>();
        String pfn = "<command line>";
        InputStream ins = null;
        boolean pre = false;
        AwkValue z = null;
        Reader r = null;
        int i = 1;
        HashMap<Object, Object> v = new HashMap<Object, Object>();
        while (i < args.length) {
            s = args[i];
            if (s.equals("--with-cpp")) {
                pre = true;
            } else if (s.equals("-f") && i + 1 < args.length) {
                s = pfn = args[++i];
                f.add(s);
            } else if (s.equals("-F") && i + 1 < args.length) {
                v.put("FS", args[++i]);
            } else if (s.startsWith("-F")) {
                v.put("FS", s.substring(2));
            } else {
                if (r != null) break;
                r = new StringReader(s);
            }
            ++i;
        }
        if (f.size() > 0) {
            r = FilesReader.newFiles(f);
        }
        if (pre) {
            r = new CPreprocessorReader(pfn, r);
        }
        if (args.length == 0) {
            throw new IllegalArgumentException();
        }
        a.add(args[0]);
        while (i < args.length) {
            a.add(args[i]);
            ++i;
        }
        String[] a2 = a.toArray(new String[0]);
        AwkNamespace ns = Awk.newNamespace("<stdin>", a2);
        EncodingDetector en = EncodingDetectorFactory.getInstance();
        if (r == null) {
            this.usage();
            return 2;
        }
        AwkProgram p = this.compile(ns, r);
        int j = 1;
        while (j < a.size()) {
            s = (String)a.get(j);
            int x = s.indexOf(61);
            if (x > 0) {
                v.put(s.substring(0, x), s.substring(x + 1));
            } else {
                try {
                    ns.assign("FILENAME", AwkString.valueOf(s));
                    Charset ch = en.detect(new File(s));
                    ins = new FileInputStream(s);
                    z = this.execute(ns, p, s, ins, stdout, stderr, ch, v, a2);
                }
                finally {
                    if (ins != null) {
                        ins.close();
                    }
                    ins = null;
                }
            }
            ++j;
        }
        if (z == null) {
            z = this.execute(ns, p, "<stdin>", stdin, stdout, stderr, Charset.defaultCharset(), v, a2);
        }
        return z.toInteger().intValue();
    }

    /*
     * Loose catch block
     */
    public void repl() {
        AwkNamespace r = Awk.newNamespace("<stdin>", new String[0]);
        AwkValue v = AwkUndefined.UNDEF;
        AwkFiles f = null;
        try {
            r.setField("");
            InputStream rd = System.in;
            OutputStreamWriter so = new OutputStreamWriter(System.out);
            OutputStreamWriter se = new OutputStreamWriter(System.err);
            AwkLexer l = new AwkLexer("awk>", "  >>", new InputStreamReader(System.in));
            f = new AwkFiles(rd, so, se);
            while (true) {
                try {
                    try {
                        v = AwkUndefined.UNDEF;
                        AwkExpression x = AwkParser.parseStatement(l);
                        x = x.compileInternally();
                        v = x.eval(r, f);
                        continue;
                    }
                    catch (AwkNextException awkNextException) {
                        ((Writer)so).flush();
                        ((Writer)se).flush();
                        System.out.println(v.toString());
                        l.resetPrompt();
                        continue;
                    }
                    catch (AwkCompilationException e) {
                        System.err.print("Error: ");
                        System.err.println(e.getMessage());
                        ((Writer)so).flush();
                        ((Writer)se).flush();
                        System.out.println(v.toString());
                        l.resetPrompt();
                        continue;
                    }
                    catch (AwkException e) {
                        System.err.print("Error: ");
                        System.err.println(e.getMessage());
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        ((Writer)so).flush();
                        ((Writer)se).flush();
                        System.out.println(v.toString());
                        l.resetPrompt();
                        continue;
                    }
                }
                finally {
                    ((Writer)so).flush();
                    ((Writer)se).flush();
                    System.out.println(v.toString());
                    l.resetPrompt();
                    continue;
                }
                break;
            }
        }
        catch (AwkExitException e) {
            System.exit(e.getValue().toInteger().intValue());
            if (f != null) {
                f.closeAll();
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace(System.err);
                System.exit(2);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (f != null) {
                    f.closeAll();
                }
            }
        }
    }
}

