/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.expr;

import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.parser.AwkRelop;
import net.morilib.awk.value.AwkValue;

public class AwkRelationOp
extends AwkExpression {
    private AwkExpression e1;
    private AwkExpression e2;
    private AwkRelop.Operator op;

    public AwkRelationOp(AwkExpression e1, AwkExpression e2, AwkRelop.Operator op) {
        this.e1 = e1;
        this.e2 = e2;
        this.op = op;
    }

    public AwkExpression getLeft() {
        return this.e1;
    }

    public AwkExpression getRight() {
        return this.e2;
    }

    public AwkValue eval(AwkNamespace ns, AwkFiles o) {
        AwkValue r1 = this.e1.eval(ns, o);
        AwkValue r2 = this.e2.eval(ns, o);
        switch (this.op) {
            case EQ: {
                return AwkValue.equals(r1, r2, ns);
            }
            case NE: {
                return AwkValue.ne(r1, r2, ns);
            }
            case LT: {
                return AwkValue.lt(r1, r2, ns);
            }
            case LE: {
                return AwkValue.le(r1, r2, ns);
            }
            case GT: {
                return AwkValue.gt(r1, r2, ns);
            }
            case GE: {
                return AwkValue.ge(r1, r2, ns);
            }
        }
        throw new RuntimeException();
    }

    public boolean maybeInputRedirect() {
        return this.op.equals((Object)AwkRelop.Operator.LT);
    }

    public boolean maybeOutputRedirect() {
        return this.op.equals((Object)AwkRelop.Operator.GT);
    }
}

