/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.parser;

import java.io.IOException;
import java.util.ArrayList;
import net.morilib.awk.AwkLocation;
import net.morilib.awk.AwkLvalueException;
import net.morilib.awk.AwkSyntaxException;
import net.morilib.awk.builtin.AwkSplit;
import net.morilib.awk.code.AwkAction;
import net.morilib.awk.code.AwkExecutable;
import net.morilib.awk.code.AwkProgram;
import net.morilib.awk.expr.AwkAdder;
import net.morilib.awk.expr.AwkApplier;
import net.morilib.awk.expr.AwkArrayReferrer;
import net.morilib.awk.expr.AwkAssigner;
import net.morilib.awk.expr.AwkCommaOp;
import net.morilib.awk.expr.AwkConcatenator;
import net.morilib.awk.expr.AwkConditionOp;
import net.morilib.awk.expr.AwkDeclementer;
import net.morilib.awk.expr.AwkDivider;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.expr.AwkFunctionPrototype;
import net.morilib.awk.expr.AwkFunctionReferrer;
import net.morilib.awk.expr.AwkInOp;
import net.morilib.awk.expr.AwkInclementer;
import net.morilib.awk.expr.AwkLiteralFloat;
import net.morilib.awk.expr.AwkLiteralInteger;
import net.morilib.awk.expr.AwkLiteralRegex;
import net.morilib.awk.expr.AwkLiteralString;
import net.morilib.awk.expr.AwkLogicalAndOp;
import net.morilib.awk.expr.AwkLogicalNotOp;
import net.morilib.awk.expr.AwkLogicalOrOp;
import net.morilib.awk.expr.AwkMatcher;
import net.morilib.awk.expr.AwkMultiArrayOp;
import net.morilib.awk.expr.AwkMultiplier;
import net.morilib.awk.expr.AwkNegater;
import net.morilib.awk.expr.AwkNotMatcher;
import net.morilib.awk.expr.AwkPowerOp;
import net.morilib.awk.expr.AwkReferField;
import net.morilib.awk.expr.AwkReferVariable;
import net.morilib.awk.expr.AwkRelationOp;
import net.morilib.awk.expr.AwkRemainderOp;
import net.morilib.awk.expr.AwkSubtracter;
import net.morilib.awk.io.AwkClose;
import net.morilib.awk.io.AwkGetline;
import net.morilib.awk.io.AwkPrint;
import net.morilib.awk.io.AwkPrintf;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.parser.AwkAssignop;
import net.morilib.awk.parser.AwkFloatToken;
import net.morilib.awk.parser.AwkIntegerToken;
import net.morilib.awk.parser.AwkLexer;
import net.morilib.awk.parser.AwkOperator;
import net.morilib.awk.parser.AwkRelop;
import net.morilib.awk.parser.AwkReserved;
import net.morilib.awk.parser.AwkStringToken;
import net.morilib.awk.parser.AwkSymbol;
import net.morilib.awk.parser.AwkToken;
import net.morilib.awk.pattern.AwkAndPattern;
import net.morilib.awk.pattern.AwkBeginEnd;
import net.morilib.awk.pattern.AwkExpressionPattern;
import net.morilib.awk.pattern.AwkNotPattern;
import net.morilib.awk.pattern.AwkOrPattern;
import net.morilib.awk.pattern.AwkPattern;
import net.morilib.awk.pattern.AwkRangedPattern;
import net.morilib.awk.pattern.AwkRegexPattern;
import net.morilib.awk.statement.AwkBreak;
import net.morilib.awk.statement.AwkContinue;
import net.morilib.awk.statement.AwkDelete;
import net.morilib.awk.statement.AwkDoWhile;
import net.morilib.awk.statement.AwkExit;
import net.morilib.awk.statement.AwkFor;
import net.morilib.awk.statement.AwkForIn;
import net.morilib.awk.statement.AwkIf;
import net.morilib.awk.statement.AwkNext;
import net.morilib.awk.statement.AwkNop;
import net.morilib.awk.statement.AwkReturn;
import net.morilib.awk.statement.AwkSequence;
import net.morilib.awk.statement.AwkWhile;

public final class AwkParser {
    static final AwkToken BEGIN = AwkSymbol.getInstance("BEGIN");
    static final AwkToken END = AwkSymbol.getInstance("END");
    static final AwkToken SPLIT = AwkSymbol.getInstance("split");

    private AwkParser() {
    }

    static AwkPattern patid(AwkLexer rd) throws IOException {
        AwkToken t = rd.getToken();
        if (t.equals(AwkOperator.LPAREN)) {
            rd.nextToken();
            AwkPattern p = AwkParser.patterm(rd);
            rd.eatToken(AwkOperator.RPAREN);
            return p;
        }
        if (t.equals(AwkOperator.DIV)) {
            String v = rd.getPattern();
            rd.nextToken();
            return new AwkRegexPattern(v);
        }
        if (t.equals(AwkAssignop.A_DIV)) {
            String v = rd.getPattern();
            rd.nextToken();
            return new AwkRegexPattern("=" + v);
        }
        return new AwkExpressionPattern(AwkParser.parseExpression(rd));
    }

    static AwkPattern patnot(AwkLexer rd) throws IOException {
        if (rd.getToken().equals(AwkOperator.L_NOT)) {
            rd.nextToken();
            return new AwkNotPattern(AwkParser.patid(rd));
        }
        return AwkParser.patid(rd);
    }

    static AwkPattern patfactor(AwkLexer rd) throws IOException {
        AwkPattern p = AwkParser.patnot(rd);
        if (rd.getToken().equals(AwkOperator.L_AND)) {
            rd.nextToken();
            return new AwkAndPattern(p, AwkParser.patfactor(rd));
        }
        return p;
    }

    static AwkPattern patterm(AwkLexer rd) throws IOException {
        AwkPattern p = AwkParser.patfactor(rd);
        if (rd.getToken().equals(AwkOperator.L_OR)) {
            rd.nextToken();
            return new AwkOrPattern(p, AwkParser.patterm(rd));
        }
        return p;
    }

    public static AwkPattern parsePattern(AwkLexer rd) throws IOException {
        AwkToken t = rd.getToken();
        if (t.equals(BEGIN)) {
            rd.nextToken();
            return AwkBeginEnd.BEGIN;
        }
        if (t.equals(END)) {
            rd.nextToken();
            return AwkBeginEnd.END;
        }
        AwkPattern p1 = AwkParser.patterm(rd);
        t = rd.getToken();
        if (t.equals(AwkOperator.COMMA)) {
            rd.nextToken();
            AwkPattern p2 = AwkParser.patterm(rd);
            return new AwkRangedPattern(p1, p2);
        }
        return p1;
    }

    static AwkExpression funcall0(AwkLexer rd, AwkExpression s) throws IOException {
        AwkToken t;
        ArrayList<AwkExpression> l = new ArrayList<AwkExpression>();
        boolean fi = true;
        while (true) {
            if ((t = rd.getToken()).equals(AwkOperator.RPAREN)) {
                rd.nextToken();
                return new AwkApplier(s, l);
            }
            if (fi) {
                l.add(AwkParser.assignop(rd));
                fi = false;
                continue;
            }
            if (!t.equals(AwkOperator.COMMA)) break;
            rd.nextToken();
            l.add(AwkParser.assignop(rd));
        }
        throw new AwkSyntaxException(rd.getLineNumber(), AwkOperator.RPAREN, t);
    }

    static AwkExpression printp(AwkLexer rd, AwkToken t) throws IOException {
        AwkExpression e;
        ArrayList<AwkExpression> l = new ArrayList<AwkExpression>();
        ArrayList<AwkToken> m = new ArrayList<AwkToken>();
        boolean first = true;
        int a = 0;
        while (!rd.isEos() && !rd.getToken().equals(AwkOperator.RPAREN)) {
            if (!first) {
                rd.eatToken(AwkOperator.COMMA);
            }
            m.add(rd.getToken());
            l.add(AwkParser.assignop(rd));
            first = false;
        }
        if (t.equals(AwkOperator.LPAREN)) {
            rd.eatToken(AwkOperator.RPAREN);
            AwkExpression f = null;
            if (rd.getToken().equals(AwkRelop.GT)) {
                rd.nextToken();
                f = AwkParser.parseExpression(rd);
                a = 0;
            } else if (rd.getToken().equals(AwkReserved.APNDOUT)) {
                rd.nextToken();
                f = AwkParser.parseExpression(rd);
                a = 1;
            } else if (rd.getToken().equals(AwkReserved.PIPE)) {
                rd.nextToken();
                f = AwkParser.parseExpression(rd);
                a = 2;
            }
            return new AwkPrint(f, l, a);
        }
        if (rd.getToken().equals(AwkReserved.APNDOUT)) {
            rd.nextToken();
            AwkExpression f = AwkParser.parseExpression(rd);
            return new AwkPrint(f, l, 1);
        }
        if (rd.getToken().equals(AwkReserved.PIPE)) {
            rd.nextToken();
            AwkExpression f = AwkParser.parseExpression(rd);
            return new AwkPrint(f, l, 2);
        }
        if (m.size() > 0 && !((AwkToken)m.get(m.size() - 1)).equals(AwkOperator.LPAREN) && (e = (AwkExpression)l.get(l.size() - 1)).maybeOutputRedirect()) {
            AwkExpression f = ((AwkRelationOp)e).getRight();
            e = ((AwkRelationOp)e).getLeft();
            l.set(l.size() - 1, e);
            return new AwkPrint(f, l, 0);
        }
        return new AwkPrint(null, l, 1);
    }

    static AwkExpression printfp(AwkLexer rd, AwkToken t) throws IOException {
        AwkExpression e;
        ArrayList<AwkExpression> l = new ArrayList<AwkExpression>();
        ArrayList<AwkToken> m = new ArrayList<AwkToken>();
        boolean first = true;
        int a = 0;
        while (!rd.isEos() && !rd.getToken().equals(AwkOperator.RPAREN)) {
            if (!first) {
                rd.eatToken(AwkOperator.COMMA);
            }
            m.add(rd.getToken());
            l.add(AwkParser.assignop(rd));
            first = false;
        }
        if (m.size() < 1) {
            throw new AwkSyntaxException(rd.getLineNumber(), "format required");
        }
        if (t.equals(AwkOperator.LPAREN)) {
            rd.eatToken(AwkOperator.RPAREN);
            AwkExpression f = null;
            if (rd.getToken().equals(AwkRelop.GT)) {
                rd.nextToken();
                f = AwkParser.parseExpression(rd);
                a = 0;
            } else if (rd.getToken().equals(AwkReserved.APNDOUT)) {
                rd.nextToken();
                f = AwkParser.parseExpression(rd);
                a = 1;
            } else if (rd.getToken().equals(AwkReserved.PIPE)) {
                rd.nextToken();
                f = AwkParser.parseExpression(rd);
                a = 2;
            }
            AwkExpression g = (AwkExpression)l.remove(0);
            return new AwkPrintf(f, g, l, a);
        }
        if (rd.getToken().equals(AwkReserved.APNDOUT)) {
            rd.nextToken();
            AwkExpression f = AwkParser.parseExpression(rd);
            AwkExpression g = (AwkExpression)l.remove(0);
            return new AwkPrintf(f, g, l, 1);
        }
        if (rd.getToken().equals(AwkReserved.PIPE)) {
            rd.nextToken();
            AwkExpression f = AwkParser.parseExpression(rd);
            AwkExpression g = (AwkExpression)l.remove(0);
            return new AwkPrintf(f, g, l, 2);
        }
        if (m.size() > 0 && !((AwkToken)m.get(m.size() - 1)).equals(AwkOperator.LPAREN) && (e = (AwkExpression)l.get(l.size() - 1)).maybeOutputRedirect()) {
            AwkExpression f = ((AwkRelationOp)e).getRight();
            e = ((AwkRelationOp)e).getLeft();
            l.set(l.size() - 1, e);
            AwkExpression g = (AwkExpression)l.remove(0);
            return new AwkPrintf(f, g, l, 0);
        }
        AwkExpression g = (AwkExpression)l.remove(0);
        return new AwkPrintf(null, g, l, 1);
    }

    static AwkFunctionPrototype funcq(AwkLexer rd) throws IOException {
        AwkToken t;
        ArrayList<String> l = new ArrayList<String>();
        boolean fi = true;
        rd.eatToken(AwkOperator.LPAREN);
        while (!(t = rd.getToken()).equals(AwkOperator.RPAREN)) {
            if (!fi) {
                rd.eatToken(AwkOperator.COMMA);
            }
            if ((t = rd.getToken()) instanceof AwkSymbol) {
                l.add(t.getString());
                rd.nextToken();
                fi = false;
                continue;
            }
            throw new AwkSyntaxException(rd.getLineNumber(), "symbol", t);
        }
        rd.nextToken();
        if (!rd.getToken().equals(AwkReserved.BLOCK_B)) {
            throw new AwkSyntaxException(rd.getLineNumber(), AwkReserved.BLOCK_B, t);
        }
        AwkExpression e = AwkParser.parseStatement(rd);
        return new AwkFunctionPrototype(e, l);
    }

    static AwkExpression arrlist2(AwkLexer rd, AwkExpression e) throws IOException {
        ArrayList<AwkExpression> l = new ArrayList<AwkExpression>();
        l.add(e);
        AwkToken t = rd.getToken();
        while (!t.equals(AwkOperator.RPAREN)) {
            l.add(AwkParser.assignop(rd));
            t = rd.getToken();
            if (!t.equals(AwkOperator.COMMA)) continue;
            t = rd.nextToken();
        }
        return new AwkMultiArrayOp(l);
    }

    static AwkExpression identifier(AwkLexer rd) throws IOException {
        AwkToken t = rd.getToken();
        String v = null;
        if (t instanceof AwkIntegerToken) {
            rd.nextToken();
            return new AwkLiteralInteger(t.getInteger());
        }
        if (t instanceof AwkStringToken) {
            rd.nextToken();
            return new AwkLiteralString(t.getString());
        }
        if (t instanceof AwkFloatToken) {
            rd.nextToken();
            return new AwkLiteralFloat(t.getFloat());
        }
        if (t.equals(SPLIT)) {
            rd.nextToken();
            rd.eatToken(AwkOperator.LPAREN);
            AwkExpression e = AwkParser.assignop(rd);
            rd.eatToken(AwkOperator.COMMA);
            AwkExpression f = AwkParser.assignop(rd);
            if (!f.isLvalue()) {
                throw new AwkLvalueException("assignment to non-lvalue");
            }
            rd.eatToken(AwkOperator.COMMA);
            AwkExpression g = AwkParser.parseExpression(rd);
            rd.eatToken(AwkOperator.RPAREN);
            return new AwkSplit(e, f, g);
        }
        if (t instanceof AwkSymbol) {
            return new AwkReferVariable(AwkParser.loc1(rd));
        }
        if (t.equals(AwkOperator.DIV)) {
            v = rd.getPattern();
            rd.nextToken();
            return new AwkLiteralRegex(v);
        }
        if (t.equals(AwkAssignop.A_DIV)) {
            v = rd.getPattern();
            rd.nextToken();
            return new AwkLiteralRegex("=" + v);
        }
        if (t.equals(AwkOperator.LPAREN)) {
            rd.nextToken();
            AwkExpression e = AwkParser.assignop(rd);
            if (rd.getToken().equals(AwkOperator.COMMA)) {
                rd.nextToken();
                e = AwkParser.arrlist2(rd, e);
            }
            rd.eatToken(AwkOperator.RPAREN);
            return e;
        }
        if (t.equals(AwkReserved.GETLINE)) {
            AwkExpression e;
            t = rd.nextToken();
            if (t instanceof AwkSymbol) {
                v = t.getString();
                t = rd.nextToken();
            }
            if (t.equals(AwkRelop.LT)) {
                rd.nextToken();
                e = AwkParser.parseExpression(rd);
            } else {
                e = null;
            }
            return new AwkGetline(v, e, null);
        }
        if (t.equals(AwkReserved.PRINT)) {
            t = rd.nextToken();
            if (t.equals(AwkOperator.LPAREN)) {
                rd.nextToken();
            }
            AwkExpression e = AwkParser.printp(rd, t);
            return e;
        }
        if (t.equals(AwkReserved.PRINTF)) {
            t = rd.nextToken();
            if (t.equals(AwkOperator.LPAREN)) {
                rd.nextToken();
            }
            AwkExpression e = AwkParser.printfp(rd, t);
            return e;
        }
        if (t.equals(AwkReserved.FUNC)) {
            rd.nextToken();
            return AwkParser.funcq(rd);
        }
        if (t.equals(AwkOperator.REFFN)) {
            t = rd.nextToken();
            if (t instanceof AwkSymbol) {
                rd.nextToken();
                return new AwkFunctionReferrer(t.getString());
            }
            throw new AwkSyntaxException(rd.getLineNumber(), "<symbol>", t);
        }
        if (t.equals(AwkReserved.SEMICL)) {
            return new AwkNop();
        }
        throw new AwkSyntaxException(rd.getLineNumber(), "identifier", t);
    }

    static AwkExpression funcall(AwkLexer rd) throws IOException {
        AwkExpression e = AwkParser.identifier(rd);
        if (rd.getToken().equals(AwkOperator.LPAREN)) {
            rd.nextToken();
            AwkExpression f = AwkParser.funcall0(rd, e);
            return f;
        }
        return e;
    }

    static AwkExpression arrlist(AwkLexer rd) throws IOException {
        ArrayList<AwkExpression> l = new ArrayList<AwkExpression>();
        AwkToken t = rd.getToken();
        while (!t.equals(AwkOperator.RBRAKET)) {
            l.add(AwkParser.assignop(rd));
            t = rd.getToken();
            if (!t.equals(AwkOperator.COMMA)) continue;
            t = rd.nextToken();
        }
        return new AwkMultiArrayOp(l);
    }

    static AwkExpression refarray(AwkLexer rd) throws IOException {
        ArrayList<AwkExpression> l = new ArrayList<AwkExpression>();
        l.add(AwkParser.funcall(rd));
        AwkToken t = rd.getToken();
        while (t.equals(AwkOperator.LBRAKET)) {
            rd.nextToken();
            l.add(AwkParser.arrlist(rd));
            if (!rd.getToken().equals(AwkOperator.RBRAKET)) continue;
            t = rd.nextToken();
        }
        AwkExpression e = (AwkExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            e = new AwkArrayReferrer(e, (AwkExpression)l.get(i));
            ++i;
        }
        return e;
    }

    static AwkExpression field(AwkLexer rd) throws IOException {
        AwkToken t = rd.getToken();
        if (t.equals(AwkOperator.FIELD)) {
            t = rd.nextToken();
            return new AwkReferField(AwkParser.refarray(rd));
        }
        return AwkParser.refarray(rd);
    }

    static AwkExpression incdec(AwkLexer rd) throws IOException {
        AwkToken t = rd.getToken();
        if (t.equals(AwkOperator.INC)) {
            t = rd.nextToken();
            return new AwkInclementer(AwkParser.field(rd), true);
        }
        if (t.equals(AwkOperator.DEC)) {
            t = rd.nextToken();
            return new AwkDeclementer(AwkParser.field(rd), true);
        }
        AwkExpression e = AwkParser.field(rd);
        t = rd.getToken();
        if (t.equals(AwkOperator.INC)) {
            t = rd.nextToken();
            return new AwkInclementer(e, false);
        }
        if (t.equals(AwkOperator.DEC)) {
            t = rd.nextToken();
            return new AwkDeclementer(e, false);
        }
        return e;
    }

    static AwkExpression pow(AwkLexer rd) throws IOException {
        AwkExpression e = AwkParser.incdec(rd);
        if (rd.getToken().equals(AwkOperator.POW)) {
            rd.nextToken();
            return new AwkPowerOp(e, AwkParser.pow(rd));
        }
        return e;
    }

    static AwkExpression unaries(AwkLexer rd) throws IOException {
        AwkToken t = rd.getToken();
        if (t.equals(AwkOperator.ADD)) {
            t = rd.nextToken();
            return AwkParser.pow(rd);
        }
        if (t.equals(AwkOperator.SUB)) {
            t = rd.nextToken();
            return new AwkNegater(AwkParser.pow(rd));
        }
        if (t.equals(AwkOperator.L_NOT)) {
            t = rd.nextToken();
            return new AwkLogicalNotOp(AwkParser.pow(rd));
        }
        return AwkParser.pow(rd);
    }

    static AwkExpression factor(AwkLexer rd) throws IOException {
        AwkToken t;
        ArrayList<AwkExpression> l = new ArrayList<AwkExpression>();
        ArrayList<AwkToken> m = new ArrayList<AwkToken>();
        l.add(AwkParser.unaries(rd));
        m.add(null);
        while ((t = rd.getToken()).equals(AwkOperator.MUL) || t.equals(AwkOperator.DIV) || t.equals(AwkOperator.MOD)) {
            m.add(t);
            rd.nextToken();
            l.add(AwkParser.unaries(rd));
        }
        AwkExpression e = (AwkExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            if (((AwkToken)m.get(i)).equals(AwkOperator.MUL)) {
                e = new AwkMultiplier(e, (AwkExpression)l.get(i));
            } else if (((AwkToken)m.get(i)).equals(AwkOperator.DIV)) {
                e = new AwkDivider(e, (AwkExpression)l.get(i));
            } else if (((AwkToken)m.get(i)).equals(AwkOperator.MOD)) {
                e = new AwkRemainderOp(e, (AwkExpression)l.get(i));
            }
            ++i;
        }
        return e;
    }

    static AwkExpression term(AwkLexer rd) throws IOException {
        AwkToken t;
        ArrayList<AwkExpression> l = new ArrayList<AwkExpression>();
        ArrayList<AwkToken> m = new ArrayList<AwkToken>();
        l.add(AwkParser.factor(rd));
        m.add(null);
        while ((t = rd.getToken()).equals(AwkOperator.ADD) || t.equals(AwkOperator.SUB)) {
            m.add(t);
            rd.nextToken();
            l.add(AwkParser.factor(rd));
        }
        AwkExpression e = (AwkExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            if (((AwkToken)m.get(i)).equals(AwkOperator.ADD)) {
                e = new AwkAdder(e, (AwkExpression)l.get(i));
            } else if (((AwkToken)m.get(i)).equals(AwkOperator.SUB)) {
                e = new AwkSubtracter(e, (AwkExpression)l.get(i));
            }
            ++i;
        }
        return e;
    }

    static AwkExpression concat(AwkLexer rd) throws IOException {
        ArrayList<AwkExpression> l = new ArrayList<AwkExpression>();
        l.add(AwkParser.term(rd));
        while (!(rd.getToken() instanceof AwkOperator) && !rd.isEos() || rd.getToken().equals(AwkOperator.FIELD) || rd.getToken().equals(AwkOperator.L_NOT)) {
            l.add(AwkParser.term(rd));
        }
        AwkExpression e = (AwkExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            e = new AwkConcatenator(e, (AwkExpression)l.get(i));
            ++i;
        }
        return e;
    }

    static AwkExpression relop(AwkLexer rd) throws IOException {
        AwkToken t;
        ArrayList<AwkExpression> l = new ArrayList<AwkExpression>();
        ArrayList<AwkRelop.Operator> m = new ArrayList<AwkRelop.Operator>();
        l.add(AwkParser.concat(rd));
        m.add(null);
        while ((t = rd.getToken()) instanceof AwkRelop) {
            m.add(t.getRelation());
            rd.nextToken();
            l.add(AwkParser.concat(rd));
        }
        AwkExpression e = (AwkExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            e = new AwkRelationOp(e, (AwkExpression)l.get(i), (AwkRelop.Operator)((Object)m.get(i)));
            ++i;
        }
        return e;
    }

    static AwkExpression matchop(AwkLexer rd) throws IOException {
        AwkToken t;
        ArrayList<AwkExpression> l = new ArrayList<AwkExpression>();
        ArrayList<AwkToken> m = new ArrayList<AwkToken>();
        l.add(AwkParser.relop(rd));
        m.add(null);
        while ((t = rd.getToken()).equals(AwkOperator.MATCH) || t.equals(AwkOperator.NMATCH)) {
            m.add(t);
            rd.nextToken();
            l.add(AwkParser.relop(rd));
        }
        AwkExpression e = (AwkExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            if (((AwkToken)m.get(i)).equals(AwkOperator.MATCH)) {
                e = new AwkMatcher(e, (AwkExpression)l.get(i));
            } else if (((AwkToken)m.get(i)).equals(AwkOperator.NMATCH)) {
                e = new AwkNotMatcher(e, (AwkExpression)l.get(i));
            }
            ++i;
        }
        return e;
    }

    static AwkExpression pin(AwkLexer rd) throws IOException {
        AwkExpression e = AwkParser.matchop(rd);
        if (rd.getToken().equals(AwkOperator.IN)) {
            rd.nextToken();
            return new AwkInOp(e, AwkParser.matchop(rd));
        }
        return e;
    }

    static AwkExpression logand(AwkLexer rd) throws IOException {
        ArrayList<AwkExpression> l = new ArrayList<AwkExpression>();
        l.add(AwkParser.pin(rd));
        while (rd.getToken().equals(AwkOperator.L_AND)) {
            rd.nextToken();
            l.add(AwkParser.pin(rd));
        }
        AwkExpression e = (AwkExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            e = new AwkLogicalAndOp(e, (AwkExpression)l.get(i));
            ++i;
        }
        return e;
    }

    static AwkExpression logor(AwkLexer rd) throws IOException {
        ArrayList<AwkExpression> l = new ArrayList<AwkExpression>();
        l.add(AwkParser.logand(rd));
        while (rd.getToken().equals(AwkOperator.L_OR)) {
            rd.nextToken();
            l.add(AwkParser.logand(rd));
        }
        AwkExpression e = (AwkExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            e = new AwkLogicalOrOp(e, (AwkExpression)l.get(i));
            ++i;
        }
        return e;
    }

    static AwkExpression cond(AwkLexer rd) throws IOException {
        AwkExpression e = AwkParser.logor(rd);
        if (rd.getToken().equals(AwkOperator.TRI1)) {
            rd.nextToken();
            AwkExpression f = AwkParser.parseExpression(rd);
            rd.eatToken(AwkOperator.TRI2);
            AwkExpression g = AwkParser.parseExpression(rd);
            return new AwkConditionOp(e, f, g);
        }
        return e;
    }

    static AwkExpression assignop(AwkLexer rd) throws IOException {
        AwkExpression e = AwkParser.cond(rd);
        AwkToken t = rd.getToken();
        if (t.equals(AwkAssignop.ASSIGN)) {
            rd.nextToken();
            return new AwkAssigner(e, AwkParser.assignop(rd), null);
        }
        if (t.equals(AwkAssignop.A_ADD)) {
            rd.nextToken();
            AwkExpression f = AwkParser.assignop(rd);
            return new AwkAssigner(e, f, new AwkAdder(e, f));
        }
        if (t.equals(AwkAssignop.A_SUB)) {
            rd.nextToken();
            AwkExpression f = AwkParser.assignop(rd);
            return new AwkAssigner(e, f, new AwkSubtracter(e, f));
        }
        if (t.equals(AwkAssignop.A_MUL)) {
            rd.nextToken();
            AwkExpression f = AwkParser.assignop(rd);
            return new AwkAssigner(e, f, new AwkMultiplier(e, f));
        }
        if (t.equals(AwkAssignop.A_DIV)) {
            rd.nextToken();
            AwkExpression f = AwkParser.assignop(rd);
            return new AwkAssigner(e, f, new AwkDivider(e, f));
        }
        if (t.equals(AwkAssignop.A_MOD)) {
            rd.nextToken();
            AwkExpression f = AwkParser.assignop(rd);
            return new AwkAssigner(e, f, new AwkRemainderOp(e, f));
        }
        if (t.equals(AwkAssignop.A_POW)) {
            rd.nextToken();
            AwkExpression f = AwkParser.assignop(rd);
            return new AwkAssigner(e, f, new AwkPowerOp(e, f));
        }
        return e;
    }

    static AwkExpression commaop(AwkLexer rd) throws IOException {
        AwkExpression e = AwkParser.assignop(rd);
        if (rd.getToken().equals(AwkOperator.COMMA)) {
            rd.nextToken();
            return new AwkCommaOp(e, AwkParser.commaop(rd));
        }
        return e;
    }

    public static AwkExpression parseExpression(AwkLexer rd) throws IOException {
        return AwkParser.commaop(rd);
    }

    private static void checkEos(AwkLexer rd) throws IOException {
        if (!rd.eatEos()) {
            throw new AwkSyntaxException(rd.getLineNumber(), "end of statement", rd.getToken());
        }
    }

    static AwkExpression stmt(AwkLexer rd) throws IOException {
        String v = null;
        AwkToken t = rd.getToken();
        if (t.equals(AwkReserved.BREAK)) {
            rd.nextToken();
            AwkParser.checkEos(rd);
            return new AwkBreak();
        }
        if (t.equals(AwkReserved.CONT)) {
            rd.nextToken();
            AwkParser.checkEos(rd);
            return new AwkContinue();
        }
        if (t.equals(AwkReserved.DELETE)) {
            rd.nextToken();
            AwkExpression e = AwkParser.parseExpression(rd);
            if (!(e instanceof AwkArrayReferrer)) {
                throw new AwkSyntaxException(rd.getLineNumber(), "array[index] required");
            }
            AwkParser.checkEos(rd);
            return new AwkDelete(((AwkArrayReferrer)e).getArray(), ((AwkArrayReferrer)e).getIndex());
        }
        if (t.equals(AwkReserved.NEXT)) {
            rd.nextToken();
            AwkParser.checkEos(rd);
            return new AwkNext();
        }
        if (t.equals(AwkReserved.EXIT)) {
            rd.nextToken();
            AwkExpression e = rd.isEos() ? AwkLiteralInteger.FALSE : AwkParser.parseExpression(rd);
            AwkParser.checkEos(rd);
            return new AwkExit(e);
        }
        if (t.equals(AwkReserved.RETURN)) {
            rd.nextToken();
            AwkExpression e = AwkParser.parseExpression(rd);
            AwkParser.checkEos(rd);
            return new AwkReturn(e);
        }
        if (t.equals(AwkReserved.CLOSE)) {
            rd.nextToken();
            AwkExpression e = AwkParser.parseExpression(rd);
            AwkParser.checkEos(rd);
            return new AwkClose(e);
        }
        AwkExpression e = AwkParser.parseExpression(rd);
        if (rd.getToken().equals(AwkReserved.PIPE)) {
            rd.nextToken();
            rd.eatToken(AwkReserved.GETLINE);
            t = rd.nextToken();
            if (t instanceof AwkSymbol) {
                v = t.getString();
                t = rd.nextToken();
            }
            return new AwkGetline(v, null, e);
        }
        AwkParser.checkEos(rd);
        return e;
    }

    private static AwkExpression forsem(AwkLexer rd, AwkToken t) throws IOException {
        if (rd.getToken().equals(t)) {
            return AwkLiteralInteger.TRUE;
        }
        AwkExpression e = AwkParser.parseExpression(rd);
        return e;
    }

    public static AwkExpression parseStatement(AwkLexer rd) throws IOException {
        ArrayList<AwkExpression> l = new ArrayList<AwkExpression>();
        AwkToken t = rd.getToken();
        if (t.equals(AwkReserved.BLOCK_B)) {
            rd.nextTokenBegin();
            while (!(t = rd.getToken()).equals(AwkReserved.BLOCK_E)) {
                if (t.equals(AwkReserved.ENDMARKER)) {
                    throw new AwkSyntaxException(rd.getLineNumber(), AwkReserved.BLOCK_E, t);
                }
                l.add(AwkParser.parseStatement(rd));
            }
            rd.eatTokenEnd(AwkReserved.BLOCK_E);
            return new AwkSequence(l);
        }
        if (t.equals(AwkReserved.IF)) {
            rd.nextToken();
            rd.eatToken(AwkOperator.LPAREN);
            AwkExpression e = AwkParser.parseExpression(rd);
            rd.eatToken(AwkOperator.RPAREN);
            AwkExpression f = AwkParser.parseStatement(rd);
            if (rd.getToken().equals(AwkReserved.ELSE)) {
                rd.nextToken();
                AwkExpression g = AwkParser.parseStatement(rd);
                return new AwkIf(e, f, g);
            }
            return new AwkIf(e, f, null);
        }
        if (t.equals(AwkReserved.WHILE)) {
            rd.nextToken();
            rd.eatToken(AwkOperator.LPAREN);
            AwkExpression e = AwkParser.parseExpression(rd);
            rd.eatToken(AwkOperator.RPAREN);
            AwkExpression f = AwkParser.parseStatement(rd);
            return new AwkWhile(e, f);
        }
        if (t.equals(AwkReserved.DO)) {
            t = rd.nextToken();
            if (!t.equals(AwkReserved.BLOCK_B)) {
                throw new AwkSyntaxException(rd.getLineNumber(), AwkReserved.BLOCK_B, t);
            }
            AwkExpression e = AwkParser.parseStatement(rd);
            rd.eatToken(AwkReserved.WHILE);
            rd.eatToken(AwkOperator.LPAREN);
            AwkExpression f = AwkParser.parseExpression(rd);
            rd.eatToken(AwkOperator.RPAREN);
            AwkParser.checkEos(rd);
            return new AwkDoWhile(f, e);
        }
        if (t.equals(AwkReserved.FOR)) {
            AwkToken s = rd.nextToken();
            rd.eatToken(AwkOperator.LPAREN);
            AwkExpression e = rd.getToken().equals(AwkReserved.SEMICL) ? AwkLiteralInteger.TRUE : AwkParser.parseExpression(rd);
            t = rd.getToken();
            if (t.equals(AwkReserved.SEMICL)) {
                rd.nextToken();
                AwkExpression f = AwkParser.forsem(rd, AwkReserved.SEMICL);
                rd.nextToken();
                AwkExpression g = AwkParser.forsem(rd, AwkOperator.RPAREN);
                rd.nextToken();
                AwkExpression h = AwkParser.parseStatement(rd);
                return new AwkFor(e, f, g, h);
            }
            if (e instanceof AwkInOp) {
                AwkExpression f = ((AwkInOp)e).getArray();
                e = ((AwkInOp)e).getElement();
                rd.eatToken(AwkOperator.RPAREN);
                AwkExpression h = AwkParser.parseStatement(rd);
                if (!(e instanceof AwkReferVariable)) {
                    throw new AwkSyntaxException(rd.getLineNumber(), "symbol", s);
                }
                AwkLocation z = ((AwkReferVariable)e).getLocation();
                if (!z.isSimpleName()) {
                    throw new AwkSyntaxException(rd.getLineNumber(), "namespace is not allowed");
                }
                return new AwkForIn(f, h, z.getName());
            }
            throw new AwkSyntaxException(rd.getLineNumber(), ";/in", t);
        }
        return AwkParser.stmt(rd);
    }

    static AwkLocation loc1(AwkLexer rd) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        AwkToken t = AwkOperator.NAME;
        AwkToken g = rd.getToken();
        boolean rt = g.equals(AwkOperator.NAME);
        if (rt) {
            rd.nextToken();
        }
        while (t.equals(AwkOperator.NAME)) {
            AwkToken f;
            if (rd.getToken().equals(AwkOperator.NAME)) {
                rd.nextToken();
            }
            if (!((f = rd.getToken()) instanceof AwkSymbol)) {
                throw new AwkSyntaxException(rd.getLineNumber(), "symbol", f);
            }
            l.add(f.getString());
            t = rd.nextToken();
        }
        return new AwkLocation(rt, l);
    }

    static AwkFunctionPrototype funcp(AwkLexer rd) throws IOException {
        AwkToken t;
        ArrayList<String> l = new ArrayList<String>();
        boolean fi = true;
        AwkLocation lc = AwkParser.loc1(rd);
        rd.eatToken(AwkOperator.LPAREN);
        while (!(t = rd.getToken()).equals(AwkOperator.RPAREN)) {
            if (!fi) {
                rd.eatToken(AwkOperator.COMMA);
            }
            if ((t = rd.getToken()) instanceof AwkSymbol) {
                l.add(t.getString());
                rd.nextToken();
                fi = false;
                continue;
            }
            throw new AwkSyntaxException(rd.getLineNumber(), "symbol", t);
        }
        rd.nextToken();
        if (!rd.getToken().equals(AwkReserved.BLOCK_B)) {
            throw new AwkSyntaxException(rd.getLineNumber(), AwkReserved.BLOCK_B, t);
        }
        AwkExpression e = AwkParser.parseStatement(rd);
        return new AwkFunctionPrototype(lc, e, l);
    }

    static AwkExecutable actionp(AwkNamespace ns, AwkLexer rd) throws IOException {
        AwkExpression e = null;
        AwkToken t = rd.getToken();
        if (t.equals(AwkReserved.BLOCK_B)) {
            e = AwkParser.parseStatement(rd);
            rd.eatTokenOpt(AwkReserved.SEMICL);
            return new AwkAction(null, e);
        }
        if (t.equals(AwkReserved.FUNC)) {
            boolean cl;
            t = rd.nextToken();
            if (t.equals(AwkOperator.FIELD)) {
                cl = true;
                rd.nextToken();
            } else {
                cl = false;
            }
            AwkFunctionPrototype f = AwkParser.funcp(rd);
            f.defun(ns, cl);
            rd.eatTokenOpt(AwkReserved.SEMICL);
            return null;
        }
        AwkPattern p = AwkParser.parsePattern(rd);
        if (rd.getToken().equals(AwkReserved.BLOCK_B)) {
            e = AwkParser.parseStatement(rd);
        }
        rd.eatTokenOpt(AwkReserved.SEMICL);
        return new AwkAction(p, e);
    }

    public static AwkProgram parse(AwkNamespace ns, AwkLexer rd) throws IOException {
        ArrayList<AwkExecutable> l = new ArrayList<AwkExecutable>();
        while (!rd.getToken().equals(AwkReserved.ENDMARKER)) {
            AwkExecutable e = AwkParser.actionp(ns, rd);
            if (e == null) continue;
            l.add(e);
        }
        return new AwkProgram(l);
    }
}

