/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist.discrete;

import net.morilib.awk.stat.dist.AbstractDiscreteDistribution;
import net.morilib.awk.stat.dist.discrete.BinomialDistribution;

public class DiscreteUniformDistribution
extends AbstractDiscreteDistribution {
    private int a;
    private int b;

    public DiscreteUniformDistribution(int a, int b) {
        if (a < 0 || b < 0) {
            throw new IllegalArgumentException();
        }
        if (a >= b) {
            throw new IllegalArgumentException();
        }
        this.a = a;
        this.b = b;
    }

    public int getA() {
        return this.a;
    }

    public int getB() {
        return this.b;
    }

    public double expectedValue() {
        return (double)(this.a + this.b) / 2.0;
    }

    public double variance() {
        double n = this.b - this.a + 1;
        return (n * n - 1.0) / 12.0;
    }

    public double mode() {
        return (double)(this.a + this.b) / 2.0;
    }

    public double median() {
        return (double)(this.a + this.b) / 2.0;
    }

    public double skewness() {
        return 0.0;
    }

    public double kurtosis() {
        double n = this.b - this.a + 1;
        return -1.2 * (n * n + 1.0) / (n * n - 1.0);
    }

    public double f(int x) {
        return this.a <= x && x <= this.b ? 1.0 / (double)(this.b - this.a + 1) : 0.0;
    }

    public boolean isInSupport(int n) {
        return true;
    }

    public double cdf(double x) {
        double n = this.b - this.a + 1;
        if (x < (double)this.a) {
            return 0.0;
        }
        if (x < (double)this.b) {
            return (Math.floor(x) - (double)this.a + 1.0) / n;
        }
        return 1.0;
    }

    public int supportMinimum() {
        return 0;
    }

    public int supportMaximum() {
        return 0x7FFFFFFE;
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (this.a + r);
        r = 37 * (this.b + r);
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof BinomialDistribution) {
            DiscreteUniformDistribution d = (DiscreteUniformDistribution)o;
            return this.a == d.a && this.b == d.b;
        }
        return false;
    }
}

